/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.builders;

import org.odpi.openmetadata.accessservices.dataengine.model.PortType;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class PortPropertiesBuilder
extends ReferenceableBuilder {
    private final String displayName;
    private final PortType portType;

    public PortPropertiesBuilder(String qualifiedName, String displayName, PortType portType, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.portType = portType;
    }

    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.displayName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", this.displayName, methodName);
        }
        if (this.portType != null) {
            properties = this.addPortTypeProperty(this.portType, properties);
        }
        return properties;
    }

    private InstanceProperties addPortTypeProperty(PortType portType, InstanceProperties properties) {
        return this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, "portType", portType.getOrdinal(), portType.getName(), portType.getDescription(), "addPortTypeProperty");
    }
}

