/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.handlers;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.odpi.openmetadata.accessservices.dataengine.model.Attribute;
import org.odpi.openmetadata.accessservices.dataengine.model.DataFile;
import org.odpi.openmetadata.accessservices.dataengine.model.SchemaType;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineCommonHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineFolderHierarchyHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineSchemaTypeHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DataEngineDataFileHandler {
    private final InvalidParameterHandler invalidParameterHandler;
    private final OMRSRepositoryHelper repositoryHelper;
    private final DataEngineCommonHandler dataEngineCommonHandler;
    private final AssetHandler<DataFile> fileHandler;
    private final DataEngineSchemaTypeHandler dataEngineSchemaTypeHandler;
    private final DataEngineFolderHierarchyHandler dataEngineFolderHierarchyHandler;

    public DataEngineDataFileHandler(InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, DataEngineCommonHandler dataEngineCommonHandler, AssetHandler<DataFile> fileHandler, DataEngineSchemaTypeHandler dataEngineSchemaTypeHandler, DataEngineFolderHierarchyHandler dataEngineFolderHierarchyHandler) {
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.dataEngineCommonHandler = dataEngineCommonHandler;
        this.fileHandler = fileHandler;
        this.dataEngineSchemaTypeHandler = dataEngineSchemaTypeHandler;
        this.dataEngineFolderHierarchyHandler = dataEngineFolderHierarchyHandler;
    }

    public String upsertFileAssetIntoCatalog(String fileTypeName, String fileTypeGuid, DataFile file, SchemaType schemaType, List<Attribute> columns, Map<String, Object> extendedProperties, String externalSourceGuid, String externalSourceName, String userId, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.validateParameters(file, schemaType, columns, externalSourceGuid, userId, methodName);
        Optional<EntityDetail> fileAsEntity = this.dataEngineCommonHandler.findEntity(userId, file.getQualifiedName(), fileTypeName);
        String fileGuid = fileAsEntity.isPresent() ? this.updateFileInRepository(userId, externalSourceGuid, externalSourceName, fileAsEntity.get(), file, extendedProperties, methodName) : this.createFileInRepository(fileTypeName, fileTypeGuid, file, extendedProperties, externalSourceGuid, externalSourceName, userId, methodName);
        String schemaTypeGuid = this.dataEngineSchemaTypeHandler.upsertSchemaType(userId, schemaType, externalSourceName);
        this.dataEngineCommonHandler.upsertExternalRelationship(userId, fileGuid, schemaTypeGuid, "AssetSchemaType", fileTypeName, externalSourceName, null);
        this.dataEngineFolderHierarchyHandler.upsertFolderHierarchy(fileGuid, file.getPathName(), externalSourceGuid, externalSourceName, userId, methodName);
        return fileGuid;
    }

    private String updateFileInRepository(String userId, String externalSourceGuid, String externalSourceName, EntityDetail fileAsEntity, DataFile file, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        TypeDef entityTypeDef = this.repositoryHelper.getTypeDefByName(userId, "DataFile");
        this.fileHandler.updateAsset(userId, externalSourceGuid, externalSourceName, fileAsEntity.getGUID(), "guid", file.getQualifiedName(), file.getDisplayName(), file.getDescription(), file.getAdditionalProperties(), entityTypeDef.getGUID(), entityTypeDef.getName(), extendedProperties, methodName);
        return fileAsEntity.getGUID();
    }

    private String createFileInRepository(String typeName, String typeGuid, DataFile file, Map<String, Object> extendedProperties, String externalSourceGuid, String externalSourceName, String userId, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        int ownerType = this.dataEngineCommonHandler.getOwnerTypeOrdinal(file.getOwnerType());
        return this.fileHandler.createAssetInRepository(userId, externalSourceGuid, externalSourceName, file.getQualifiedName(), file.getDisplayName(), file.getDescription(), file.getZoneMembership(), file.getOwner(), ownerType, file.getOriginOrganizationGUID(), file.getOriginBusinessCapabilityGUID(), file.getOtherOriginValues(), file.getAdditionalProperties(), typeGuid, typeName, extendedProperties, methodName);
    }

    private void validateParameters(DataFile file, SchemaType schemaType, List<Attribute> columns, String externalSourceGuid, String userId, String methodName) throws InvalidParameterException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)externalSourceGuid, "externalSourceGuid", methodName);
        this.invalidParameterHandler.validateObject((Object)file, "file", methodName);
        this.invalidParameterHandler.validateName(file.getQualifiedName(), "file.qualifiedName", methodName);
        this.invalidParameterHandler.validateName(file.getPathName(), "file.pathName", methodName);
        if (schemaType != null) {
            this.invalidParameterHandler.validateObject((Object)schemaType.getQualifiedName(), "schema.qualifiedName", methodName);
        }
        this.invalidParameterHandler.validateObject(columns, "columns", methodName);
        for (Attribute column : columns) {
            this.invalidParameterHandler.validateName(column.getQualifiedName(), "columns.column.qualifiedName", methodName);
        }
    }
}

