/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.handlers;

import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineErrorCode;
import org.odpi.openmetadata.accessservices.dataengine.model.Attribute;
import org.odpi.openmetadata.accessservices.dataengine.model.Database;
import org.odpi.openmetadata.accessservices.dataengine.model.DatabaseSchema;
import org.odpi.openmetadata.accessservices.dataengine.model.OwnerType;
import org.odpi.openmetadata.accessservices.dataengine.model.RelationalColumn;
import org.odpi.openmetadata.accessservices.dataengine.model.RelationalTable;
import org.odpi.openmetadata.accessservices.dataengine.model.SchemaType;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineCommonHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineRegistrationHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.RelationalDataHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DataEngineRelationalDataHandler {
    private final String serviceName;
    private final String serverName;
    private final RepositoryHandler repositoryHandler;
    private final OMRSRepositoryHelper repositoryHelper;
    private final InvalidParameterHandler invalidParameterHandler;
    private final RelationalDataHandler<Database, DatabaseSchema, RelationalTable, RelationalTable, RelationalColumn, SchemaType> relationalDataHandler;
    private final DataEngineCommonHandler dataEngineCommonHandler;
    private final DataEngineRegistrationHandler registrationHandler;

    public DataEngineRelationalDataHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, RelationalDataHandler<Database, DatabaseSchema, RelationalTable, RelationalTable, RelationalColumn, SchemaType> relationalDataHandler, DataEngineRegistrationHandler registrationHandler, DataEngineCommonHandler dataEngineCommonHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.relationalDataHandler = relationalDataHandler;
        this.registrationHandler = registrationHandler;
        this.dataEngineCommonHandler = dataEngineCommonHandler;
    }

    public String upsertDatabase(String userId, Database database, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String databaseGUID;
        String methodName = "upsertDatabase";
        this.validateParameters(userId, "upsertDatabase", database.getQualifiedName(), database.getDisplayName());
        String externalSourceGUID = this.registrationHandler.getExternalDataEngineByQualifiedName(userId, externalSourceName);
        Optional<EntityDetail> originalDatabaseEntity = this.findDatabaseEntity(userId, database.getQualifiedName());
        int ownerTypeOrdinal = this.dataEngineCommonHandler.getOwnerTypeOrdinal(database.getOwnerType());
        if (!originalDatabaseEntity.isPresent()) {
            databaseGUID = this.relationalDataHandler.createDatabase(userId, externalSourceGUID, externalSourceName, database.getQualifiedName(), database.getDisplayName(), database.getDescription(), database.getOwner(), ownerTypeOrdinal, database.getZoneMembership(), database.getOriginOrganizationGUID(), database.getOriginBusinessCapabilityGUID(), database.getOtherOriginValues(), database.getPathName(), database.getCreateTime(), database.getModifiedTime(), database.getEncodingType(), database.getEncodingLanguage(), database.getEncodingDescription(), database.getEncodingProperties(), database.getDatabaseType(), database.getDatabaseVersion(), database.getDatabaseInstance(), database.getDatabaseImportedFrom(), database.getAdditionalProperties(), "Database", null, null, "upsertDatabase");
        } else {
            databaseGUID = originalDatabaseEntity.get().getGUID();
            this.relationalDataHandler.updateDatabase(userId, externalSourceGUID, externalSourceName, databaseGUID, database.getQualifiedName(), database.getDisplayName(), database.getDescription(), database.getOwner(), ownerTypeOrdinal, database.getZoneMembership(), database.getOriginOrganizationGUID(), database.getOriginBusinessCapabilityGUID(), database.getOtherOriginValues(), database.getCreateTime(), database.getModifiedTime(), database.getEncodingType(), database.getEncodingLanguage(), database.getEncodingDescription(), database.getEncodingProperties(), database.getDatabaseType(), database.getDatabaseVersion(), database.getDatabaseInstance(), database.getDatabaseImportedFrom(), database.getAdditionalProperties(), "Database", null, null, "upsertDatabase");
        }
        DatabaseSchema databaseSchema = database.getDatabaseSchema();
        if (databaseSchema == null) {
            databaseSchema = this.createDefaultDatabaseSchema(database.getQualifiedName());
        }
        this.addAssetProperties(databaseSchema, database.getOwner(), database.getOwnerType(), database.getZoneMembership());
        this.upsertDatabaseSchema(userId, databaseGUID, databaseSchema, externalSourceName);
        return databaseGUID;
    }

    private Optional<EntityDetail> findDatabaseEntity(String userId, String qualifiedName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.dataEngineCommonHandler.findEntity(userId, qualifiedName, "Database");
    }

    private void upsertDatabaseSchema(String userId, String databaseGUID, DatabaseSchema databaseSchema, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "upsertDatabaseSchema";
        this.invalidParameterHandler.validateUserId(userId, "upsertDatabaseSchema");
        this.invalidParameterHandler.validateName(databaseSchema.getQualifiedName(), "qualifiedName", "upsertDatabaseSchema");
        String externalSourceGUID = this.registrationHandler.getExternalDataEngineByQualifiedName(userId, externalSourceName);
        Optional<EntityDetail> originalDatabaseSchemaEntity = this.dataEngineCommonHandler.findEntity(userId, databaseSchema.getQualifiedName(), "DeployedDatabaseSchema");
        int ownerTypeOrdinal = this.dataEngineCommonHandler.getOwnerTypeOrdinal(databaseSchema.getOwnerType());
        if (!originalDatabaseSchemaEntity.isPresent()) {
            this.relationalDataHandler.createDatabaseSchema(userId, externalSourceGUID, externalSourceName, databaseGUID, databaseSchema.getQualifiedName(), databaseSchema.getDisplayName(), databaseSchema.getDescription(), databaseSchema.getOwner(), ownerTypeOrdinal, databaseSchema.getZoneMembership(), databaseSchema.getOriginOrganizationGUID(), databaseSchema.getOriginBusinessCapabilityGUID(), databaseSchema.getOtherOriginValues(), databaseSchema.getAdditionalProperties(), "DeployedDatabaseSchema", null, null, "upsertDatabaseSchema");
        } else {
            String databaseSchemaGUID = originalDatabaseSchemaEntity.get().getGUID();
            this.relationalDataHandler.updateDatabaseSchema(userId, externalSourceGUID, externalSourceName, databaseSchemaGUID, databaseSchema.getQualifiedName(), databaseSchema.getDisplayName(), databaseSchema.getDescription(), databaseSchema.getOwner(), ownerTypeOrdinal, databaseSchema.getZoneMembership(), databaseSchema.getOriginOrganizationGUID(), databaseSchema.getOriginBusinessCapabilityGUID(), databaseSchema.getOtherOriginValues(), databaseSchema.getAdditionalProperties(), "DeployedDatabaseSchema", null, null, "upsertDatabaseSchema");
        }
    }

    private Optional<String> findSchemaForDatabase(String userId, String databaseGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findSchemaForDatabase";
        this.invalidParameterHandler.validateUserId(userId, "findSchemaForDatabase");
        this.invalidParameterHandler.validateGUID(databaseGUID, "guid", "findSchemaForDatabase");
        TypeDef relationshipTypeDef = this.repositoryHelper.getTypeDefByName(userId, "DataContentForDataSet");
        EntityDetail entity = this.repositoryHandler.getEntityForRelationshipType(userId, databaseGUID, "Database", relationshipTypeDef.getGUID(), relationshipTypeDef.getName(), "findSchemaForDatabase");
        if (entity == null) {
            return Optional.empty();
        }
        return Optional.of(entity.getGUID());
    }

    public String upsertRelationalTable(String userId, String databaseQualifiedName, RelationalTable relationalTable, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String relationalTableGUID;
        String methodName = "upsertRelationalTable";
        this.validateParameters(userId, "upsertRelationalTable", relationalTable.getQualifiedName(), relationalTable.getDisplayName());
        String externalSourceGUID = this.registrationHandler.getExternalDataEngineByQualifiedName(userId, externalSourceName);
        Optional<EntityDetail> originalRelationalTableEntity = this.dataEngineCommonHandler.findEntity(userId, relationalTable.getQualifiedName(), "RelationalTable");
        if (!originalRelationalTableEntity.isPresent()) {
            String databaseSchemaGUID = this.getDatabaseSchemaGUID(userId, databaseQualifiedName, "upsertRelationalTable");
            relationalTableGUID = this.relationalDataHandler.createDatabaseTable(userId, externalSourceGUID, externalSourceName, databaseSchemaGUID, relationalTable.getQualifiedName(), relationalTable.getDisplayName(), relationalTable.getDescription(), relationalTable.isDeprecated(), relationalTable.getAliases(), relationalTable.getAdditionalProperties(), "RelationalTable", null, null, "upsertRelationalTable");
        } else {
            relationalTableGUID = originalRelationalTableEntity.get().getGUID();
            this.relationalDataHandler.updateDatabaseTable(userId, externalSourceGUID, externalSourceName, relationalTableGUID, relationalTable.getQualifiedName(), relationalTable.getDisplayName(), relationalTable.getDescription(), relationalTable.isDeprecated(), relationalTable.getAliases(), relationalTable.getAdditionalProperties(), "RelationalTable", null, null, "upsertRelationalTable");
        }
        this.upsertRelationalColumns(userId, externalSourceGUID, externalSourceName, relationalTableGUID, relationalTable.getColumns());
        return relationalTableGUID;
    }

    private void upsertRelationalColumns(String userId, String externalSourceGUID, String externalSourceName, String relationalTableGUID, List<RelationalColumn> columns) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "upsertRelationalColumns";
        if (CollectionUtils.isEmpty(columns)) {
            return;
        }
        for (RelationalColumn column : columns) {
            int sortOrder = this.dataEngineCommonHandler.getSortOrder((Attribute)column);
            Optional<EntityDetail> originalRelationalColumnEntity = this.dataEngineCommonHandler.findEntity(userId, column.getQualifiedName(), "RelationalColumn");
            if (!originalRelationalColumnEntity.isPresent()) {
                this.relationalDataHandler.createDatabaseColumn(userId, externalSourceGUID, externalSourceName, relationalTableGUID, column.getQualifiedName(), column.getDisplayName(), column.getDescription(), column.getExternalTypeGUID(), column.getDataType(), column.getDefaultValue(), column.getFixedValue(), column.getValidValuesSetGUID(), column.getFormula(), column.isDeprecated(), column.getPosition(), column.getMinCardinality(), column.getMaxCardinality(), column.getAllowsDuplicateValues(), column.getOrderedValues(), column.getDefaultValueOverride(), sortOrder, column.getMinimumLength(), column.getLength(), column.getPrecision(), column.isNullable(), column.getNativeClass(), column.getAliases(), column.getAdditionalProperties(), "RelationalColumn", null, null, "upsertRelationalColumns");
                continue;
            }
            this.relationalDataHandler.updateDatabaseColumn(userId, externalSourceGUID, externalSourceName, originalRelationalColumnEntity.get().getGUID(), column.getQualifiedName(), column.getDisplayName(), column.getDescription(), column.getDataType(), column.getDefaultValue(), column.getFixedValue(), column.getFormula(), column.isDeprecated(), column.getPosition(), column.getMinCardinality(), column.getMaxCardinality(), column.getAllowsDuplicateValues(), column.getOrderedValues(), column.getDefaultValueOverride(), sortOrder, column.getMinimumLength(), column.getLength(), column.getPrecision(), column.isNullable(), column.getNativeClass(), column.getAliases(), column.getAdditionalProperties(), "RelationalColumn", null, null, "upsertRelationalColumns");
        }
    }

    private String getDatabaseSchemaGUID(String userId, String databaseQualifiedName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Optional<EntityDetail> databaseOptional = this.findDatabaseEntity(userId, databaseQualifiedName);
        if (!databaseOptional.isPresent()) {
            this.dataEngineCommonHandler.throwInvalidParameterException(DataEngineErrorCode.DATABASE_NOT_FOUND, methodName, databaseQualifiedName);
        } else {
            Optional<String> databaseSchemaOptional = this.findSchemaForDatabase(userId, databaseOptional.get().getGUID());
            if (!databaseSchemaOptional.isPresent()) {
                this.dataEngineCommonHandler.throwInvalidParameterException(DataEngineErrorCode.DATABASE_NOT_FOUND, methodName, databaseQualifiedName);
            } else {
                return databaseSchemaOptional.get();
            }
        }
        return null;
    }

    private void addAssetProperties(DatabaseSchema databaseSchema, String owner, OwnerType ownerType, List<String> zoneMembership) {
        databaseSchema.setOwner(owner);
        databaseSchema.setOwnerType(ownerType);
        databaseSchema.setZoneMembership(zoneMembership);
    }

    private DatabaseSchema createDefaultDatabaseSchema(String databaseQualifiedName) {
        String postfix = ":schema";
        DatabaseSchema databaseSchema = new DatabaseSchema();
        databaseSchema.setQualifiedName(databaseQualifiedName + postfix);
        return databaseSchema;
    }

    private void validateParameters(String userId, String methodName, String qualifiedName, String displayName) throws InvalidParameterException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.validateName(displayName, "displayName", methodName);
    }
}

