/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.handlers;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineErrorCode;
import org.odpi.openmetadata.accessservices.dataengine.model.Attribute;
import org.odpi.openmetadata.accessservices.dataengine.model.SchemaType;
import org.odpi.openmetadata.accessservices.dataengine.server.builders.SchemaAttributePropertiesBuilder;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineCommonHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineRegistrationHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetailDifferences;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DataEngineSchemaTypeHandler {
    public static final String SCHEMA_TYPE_GUID_PARAMETER_NAME = "schemaTypeGUID";
    private final String serviceName;
    private final String serverName;
    private final RepositoryHandler repositoryHandler;
    private final OMRSRepositoryHelper repositoryHelper;
    private final InvalidParameterHandler invalidParameterHandler;
    private final SchemaTypeHandler<SchemaType> schemaTypeHandler;
    private final SchemaAttributeHandler<Attribute, SchemaType> schemaAttributeHandler;
    private final DataEngineRegistrationHandler dataEngineRegistrationHandler;
    private final DataEngineCommonHandler dataEngineCommonHandler;

    public DataEngineSchemaTypeHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, SchemaTypeHandler<SchemaType> schemaTypeHandler, SchemaAttributeHandler<Attribute, SchemaType> schemaAttributeHandler, DataEngineRegistrationHandler dataEngineRegistrationHandler, DataEngineCommonHandler dataEngineCommonHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.schemaTypeHandler = schemaTypeHandler;
        this.schemaAttributeHandler = schemaAttributeHandler;
        this.dataEngineRegistrationHandler = dataEngineRegistrationHandler;
        this.dataEngineCommonHandler = dataEngineCommonHandler;
    }

    public String upsertSchemaType(String userId, SchemaType schemaType, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String schemaTypeGUID;
        String methodName = "upsertSchemaType";
        this.invalidParameterHandler.validateUserId(userId, "upsertSchemaType");
        this.invalidParameterHandler.validateName(schemaType.getQualifiedName(), "qualifiedName", "upsertSchemaType");
        this.invalidParameterHandler.validateName(schemaType.getDisplayName(), "displayName", "upsertSchemaType");
        Optional<EntityDetail> originalSchemaTypeEntity = this.findSchemaTypeEntity(userId, schemaType.getQualifiedName());
        SchemaTypeBuilder schemaTypeBuilder = this.getSchemaTypeBuilder(schemaType);
        String externalSourceGUID = this.dataEngineRegistrationHandler.getExternalDataEngineByQualifiedName(userId, externalSourceName);
        if (!originalSchemaTypeEntity.isPresent()) {
            schemaTypeGUID = this.schemaTypeHandler.addSchemaType(userId, externalSourceGUID, externalSourceName, schemaTypeBuilder, "upsertSchemaType");
        } else {
            schemaTypeGUID = originalSchemaTypeEntity.get().getGUID();
            EntityDetail updatedSchemaTypeEntity = this.buildSchemaTypeEntityDetail(schemaTypeGUID, schemaType);
            EntityDetailDifferences entityDetailDifferences = this.repositoryHelper.getEntityDetailDifferences(originalSchemaTypeEntity.get(), updatedSchemaTypeEntity, true);
            if (entityDetailDifferences.hasInstancePropertiesDifferences()) {
                this.schemaTypeHandler.updateSchemaType(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, SCHEMA_TYPE_GUID_PARAMETER_NAME, schemaTypeBuilder);
            }
        }
        this.upsertSchemaAttributes(userId, schemaType, schemaTypeGUID, schemaType.getAttributeList(), externalSourceName);
        return schemaTypeGUID;
    }

    public Optional<EntityDetail> findSchemaTypeEntity(String userId, String qualifiedName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        return this.dataEngineCommonHandler.findEntity(userId, qualifiedName, "SchemaType");
    }

    public Optional<EntityDetail> findSchemaAttributeEntity(String userId, String qualifiedName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        return this.dataEngineCommonHandler.findEntity(userId, qualifiedName, "SchemaAttribute");
    }

    public void addLineageMappingRelationship(String userId, String sourceSchemaAttributeQualifiedName, String targetSchemaAttributeQualifiedName, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addLineageMappingRelationship";
        this.invalidParameterHandler.validateUserId(userId, "addLineageMappingRelationship");
        this.invalidParameterHandler.validateName(sourceSchemaAttributeQualifiedName, "qualifiedName", "addLineageMappingRelationship");
        this.invalidParameterHandler.validateName(targetSchemaAttributeQualifiedName, "qualifiedName", "addLineageMappingRelationship");
        Optional<EntityDetail> sourceSchemaAttributeEntity = this.findSchemaAttributeEntity(userId, sourceSchemaAttributeQualifiedName);
        Optional<EntityDetail> targetSchemaAttributeEntity = this.findSchemaAttributeEntity(userId, targetSchemaAttributeQualifiedName);
        if (!sourceSchemaAttributeEntity.isPresent()) {
            this.dataEngineCommonHandler.throwInvalidParameterException(DataEngineErrorCode.SCHEMA_ATTRIBUTE_NOT_FOUND, "addLineageMappingRelationship", sourceSchemaAttributeQualifiedName);
            return;
        }
        if (!targetSchemaAttributeEntity.isPresent()) {
            this.dataEngineCommonHandler.throwInvalidParameterException(DataEngineErrorCode.SCHEMA_ATTRIBUTE_NOT_FOUND, "addLineageMappingRelationship", targetSchemaAttributeQualifiedName);
            return;
        }
        this.dataEngineCommonHandler.upsertExternalRelationship(userId, sourceSchemaAttributeEntity.get().getGUID(), targetSchemaAttributeEntity.get().getGUID(), "LineageMapping", "SchemaAttribute", externalSourceName, null);
    }

    public void removeSchemaType(String userId, String schemaTypeGUID, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeSchemaType";
        this.invalidParameterHandler.validateUserId(userId, "removeSchemaType");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "guid", "removeSchemaType");
        Set<String> schemaAttributeGUIDs = this.getSchemaAttributesForSchemaType(userId, schemaTypeGUID);
        for (String schemaAttributeGUID : schemaAttributeGUIDs) {
            this.dataEngineCommonHandler.removeEntity(userId, schemaAttributeGUID, "TabularColumn", externalSourceName);
        }
        this.dataEngineCommonHandler.removeEntity(userId, schemaTypeGUID, "TabularSchemaType", externalSourceName);
    }

    public void addAnchorGUID(String userId, Attribute attribute, String processGUID, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addAnchorGUID";
        Optional<EntityDetail> schemaAttributeEntity = this.findSchemaAttributeEntity(userId, attribute.getQualifiedName());
        if (!schemaAttributeEntity.isPresent()) {
            this.dataEngineCommonHandler.throwInvalidParameterException(DataEngineErrorCode.SCHEMA_ATTRIBUTE_NOT_FOUND, "addAnchorGUID", attribute.getQualifiedName());
        } else {
            attribute.setAnchorGUID(processGUID);
            String externalSourceGUID = this.dataEngineRegistrationHandler.getExternalDataEngineByQualifiedName(userId, externalSourceName);
            this.schemaAttributeHandler.updateSchemaAttribute(userId, externalSourceGUID, externalSourceName, schemaAttributeEntity.get().getGUID(), this.getSchemaAttributeBuilder(attribute).getInstanceProperties("addAnchorGUID"));
        }
    }

    private void upsertSchemaAttributes(String userId, SchemaType schemaType, String schemaTypeGUID, List<Attribute> attributeList, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "upsertSchemaAttributes";
        for (Attribute attribute : attributeList) {
            Optional<EntityDetail> schemaAttributeEntity = this.findSchemaAttributeEntity(userId, attribute.getQualifiedName());
            if (!schemaAttributeEntity.isPresent()) {
                this.createSchemaAttribute(userId, schemaType, schemaTypeGUID, attribute, attribute.getDataType(), externalSourceName);
                continue;
            }
            String schemaAttributeGUID = schemaAttributeEntity.get().getGUID();
            EntityDetail updatedSchemaAttributeEntity = this.buildSchemaAttributeEntityDetail(schemaAttributeGUID, attribute);
            EntityDetailDifferences entityDetailDifferences = this.repositoryHelper.getEntityDetailDifferences(schemaAttributeEntity.get(), updatedSchemaAttributeEntity, true);
            if (!entityDetailDifferences.hasInstancePropertiesDifferences()) continue;
            String externalSourceGUID = this.dataEngineRegistrationHandler.getExternalDataEngineByQualifiedName(userId, externalSourceName);
            this.schemaAttributeHandler.updateSchemaAttribute(userId, externalSourceGUID, externalSourceName, schemaAttributeGUID, this.getSchemaAttributeBuilder(attribute).getInstanceProperties(methodName));
        }
    }

    private EntityDetail buildSchemaAttributeEntityDetail(String schemaAttributeGUID, Attribute attribute) throws InvalidParameterException {
        String methodName = "buildSchemaAttributeEntityDetail";
        SchemaAttributePropertiesBuilder schemaAttributeBuilder = this.getSchemaAttributeBuilder(attribute);
        return this.dataEngineCommonHandler.buildEntityDetail(schemaAttributeGUID, schemaAttributeBuilder.getInstanceProperties(methodName));
    }

    SchemaAttributePropertiesBuilder getSchemaAttributeBuilder(Attribute attribute) {
        HashMap<String, String> additionalProperties = new HashMap<String, String>();
        additionalProperties.put("anchorGUID", attribute.getAnchorGUID());
        return new SchemaAttributePropertiesBuilder(attribute.getQualifiedName(), attribute.getDisplayName(), null, attribute.getPosition(), attribute.getMinCardinality(), attribute.getMaxCardinality(), false, attribute.getDefaultValueOverride(), attribute.getAllowsDuplicateValues(), attribute.getOrderedValues(), 0, 0, 0, 0, false, null, null, additionalProperties, "d81a0425-4e9b-4f31-bc1c-e18c3566da10", "TabularColumn", null, this.repositoryHelper, this.serviceName, this.serverName, attribute.getAnchorGUID());
    }

    private void createSchemaAttribute(String userId, SchemaType schemaType, String schemaTypeGUID, Attribute attribute, String dataType, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSchemaAttribute";
        SchemaAttributePropertiesBuilder schemaAttributeBuilder = this.getSchemaAttributeBuilder(attribute);
        SchemaTypeBuilder schemaTypeBuilder = this.getSchemaTypeBuilder(schemaType);
        schemaTypeBuilder.setDataType(dataType);
        schemaAttributeBuilder.setSchemaType(userId, schemaTypeBuilder, "createSchemaAttribute");
        String schemaTypeGUIDParameterName = SCHEMA_TYPE_GUID_PARAMETER_NAME;
        String qualifiedNameParameterName = "schemaAttribute.getQualifiedName()";
        String externalSourceGUID = this.dataEngineRegistrationHandler.getExternalDataEngineByQualifiedName(userId, externalSourceName);
        this.schemaAttributeHandler.createNestedSchemaAttribute(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, SCHEMA_TYPE_GUID_PARAMETER_NAME, "TabularSchemaType", "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", attribute.getQualifiedName(), "schemaAttribute.getQualifiedName()", (SchemaAttributeBuilder)schemaAttributeBuilder, "createSchemaAttribute");
    }

    private EntityDetail buildSchemaTypeEntityDetail(String schemaTypeGUID, SchemaType schemaType) throws InvalidParameterException {
        String methodName = "buildSchemaTypeEntityDetail";
        SchemaTypeBuilder schemaTypeBuilder = this.getSchemaTypeBuilder(schemaType);
        return this.dataEngineCommonHandler.buildEntityDetail(schemaTypeGUID, schemaTypeBuilder.getInstanceProperties(methodName));
    }

    SchemaTypeBuilder getSchemaTypeBuilder(SchemaType schemaType) {
        return new SchemaTypeBuilder(schemaType.getQualifiedName(), schemaType.getDisplayName(), null, schemaType.getVersionNumber(), false, schemaType.getAuthor(), schemaType.getUsage(), schemaType.getEncodingStandard(), null, null, "248975ec-8019-4b8a-9caf-084c8b724233", "TabularSchemaType", null, this.repositoryHelper, this.serviceName, this.serverName);
    }

    private Set<String> getSchemaAttributesForSchemaType(String userId, String schemaTypeGUID) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        String methodName = "getSchemaAttributesForSchemaType";
        this.invalidParameterHandler.validateUserId(userId, "getSchemaAttributesForSchemaType");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "guid", "getSchemaAttributesForSchemaType");
        TypeDef relationshipTypeDef = this.repositoryHelper.getTypeDefByName(userId, "AttributeForSchema");
        List entities = this.repositoryHandler.getEntitiesForRelationshipType(userId, schemaTypeGUID, "SchemaType", relationshipTypeDef.getGUID(), relationshipTypeDef.getName(), 0, 0, "getSchemaAttributesForSchemaType");
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return new HashSet<String>();
        }
        return entities.parallelStream().map(InstanceHeader::getGUID).collect(Collectors.toSet());
    }
}

