/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.handlers;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.odpi.openmetadata.accessservices.dataengine.model.DeleteSemantic;
import org.odpi.openmetadata.accessservices.dataengine.model.FileFolder;
import org.odpi.openmetadata.accessservices.dataengine.model.OwnerType;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineCommonHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;

public class DataEngineFolderHierarchyHandler {
    private final InvalidParameterHandler invalidParameterHandler;
    private final RepositoryHandler repositoryHandler;
    private final DataEngineCommonHandler dataEngineCommonHandler;
    private final AssetHandler<FileFolder> folderHandler;

    public DataEngineFolderHierarchyHandler(InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, DataEngineCommonHandler dataEngineCommonHandler, AssetHandler<FileFolder> folderHandler) {
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHandler = repositoryHandler;
        this.dataEngineCommonHandler = dataEngineCommonHandler;
        this.folderHandler = folderHandler;
    }

    public void upsertFolderHierarchy(String fileGuid, String pathName, String externalSourceGuid, String externalSourceName, String userId, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.validateParameters(fileGuid, pathName, externalSourceGuid, externalSourceName, userId, methodName);
        List<FileFolder> folders = this.extractFolders(pathName, externalSourceName, methodName);
        String folderGuid = "";
        String previousEntityGuid = fileGuid;
        String relationshipTypeName = "NestedFile";
        for (FileFolder folder : folders) {
            if (relationshipTypeName.equals("NestedFile")) {
                this.deleteExistingNestedFileRelationships(fileGuid, externalSourceGuid, externalSourceName, userId, methodName);
            }
            folderGuid = this.upsertFolder(externalSourceGuid, externalSourceName, folder, userId, methodName);
            this.dataEngineCommonHandler.upsertExternalRelationship(userId, folderGuid, previousEntityGuid, relationshipTypeName, "FileFolder", externalSourceName, null);
            previousEntityGuid = folderGuid;
            relationshipTypeName = "FolderHierarchy";
        }
        this.dataEngineCommonHandler.upsertExternalRelationship(userId, externalSourceGuid, folderGuid, "ServerAssetUse", "SoftwareServerCapability", externalSourceName, null);
    }

    public void removeFolder(String userId, String folderGUID, DeleteSemantic deleteSemantic, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "removeFolder";
        this.dataEngineCommonHandler.validateDeleteSemantic(deleteSemantic, methodName);
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(folderGUID, "guid", methodName);
        this.dataEngineCommonHandler.removeEntity(userId, folderGUID, "FileFolder", externalSourceName);
    }

    private void deleteExistingNestedFileRelationships(String fileGuid, String externalSourceGuid, String externalSourceName, String userId, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        Optional<List> optionalRelationships = Optional.ofNullable(this.repositoryHandler.getRelationshipsByType(userId, fileGuid, "DataFile", "4cb88900-1446-4eb6-acea-29cd9da45e63", "NestedFile", methodName));
        if (!optionalRelationships.isPresent()) {
            return;
        }
        for (Relationship relationship : optionalRelationships.get()) {
            this.repositoryHandler.removeRelationship(userId, externalSourceGuid, externalSourceName, relationship, methodName);
        }
    }

    private String upsertFolder(String externalSourceGuid, String externalSourceName, FileFolder folder, String userId, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Optional<EntityDetail> folderAsEntity = this.dataEngineCommonHandler.findEntity(userId, folder.getQualifiedName(), "FileFolder");
        if (folderAsEntity.isPresent()) {
            return folderAsEntity.get().getGUID();
        }
        return this.folderHandler.createAssetInRepository(userId, externalSourceGuid, externalSourceName, folder.getQualifiedName(), folder.getDisplayName(), folder.getDescription(), folder.getZoneMembership(), folder.getOwner(), folder.getOwnerType().getOpenTypeOrdinal(), null, null, folder.getOtherOriginValues(), folder.getAdditionalProperties(), "229ed5cc-de31-45fc-beb4-9919fd247398", "FileFolder", null, methodName);
    }

    private List<FileFolder> extractFolders(String pathName, String externalSourceName, String methodName) throws InvalidParameterException {
        File parentFile;
        boolean fileSeparatorReversed = false;
        if (pathName.contains("\\")) {
            pathName = pathName.replace("\\", "/");
            fileSeparatorReversed = true;
        }
        Path path = Paths.get(pathName, new String[0]);
        this.invalidParameterHandler.validateObject((Object)parentFile, "pathName", methodName);
        ArrayList<FileFolder> folders = new ArrayList<FileFolder>();
        for (parentFile = path.toFile().getParentFile(); parentFile != null; parentFile = parentFile.getParentFile()) {
            String parentFilePath = fileSeparatorReversed ? parentFile.getPath().replace("/", "\\") : parentFile.getPath();
            FileFolder folder = this.buildFileFolder(parentFilePath, externalSourceName);
            folders.add(folder);
        }
        return folders;
    }

    private FileFolder buildFileFolder(String pathName, String externalSourceName) {
        FileFolder fileFolder = new FileFolder();
        fileFolder.setQualifiedName(externalSourceName + "::" + pathName);
        fileFolder.setPathName(pathName);
        fileFolder.setDisplayName(this.computeDisplayName(pathName));
        fileFolder.setOwnerType(OwnerType.USER_ID);
        return fileFolder;
    }

    private String computeDisplayName(String pathName) {
        return new File(pathName).getName().length() < 1 ? pathName : new File(pathName).getName();
    }

    private void validateParameters(String fileGuid, String pathName, String externalSourceGuid, String externalSourceName, String userId, String methodName) throws InvalidParameterException {
        this.invalidParameterHandler.validateObject((Object)fileGuid, "fileGuid", methodName);
        this.invalidParameterHandler.validateObject((Object)pathName, "pathName", methodName);
        this.invalidParameterHandler.validateObject((Object)externalSourceGuid, "externalSourceGuid", methodName);
        this.invalidParameterHandler.validateObject((Object)externalSourceName, "externalSourceName", methodName);
        this.invalidParameterHandler.validateUserId(userId, methodName);
    }
}

