/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.handlers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineErrorCode;
import org.odpi.openmetadata.accessservices.dataengine.model.Attribute;
import org.odpi.openmetadata.accessservices.dataengine.model.DeleteSemantic;
import org.odpi.openmetadata.accessservices.dataengine.model.SchemaType;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineCommonHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineRegistrationHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetailDifferences;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;

public class DataEngineSchemaTypeHandler {
    public static final String SCHEMA_TYPE_GUID_PARAMETER_NAME = "schemaTypeGUID";
    private final String serviceName;
    private final String serverName;
    private final OMRSRepositoryHelper repositoryHelper;
    private final InvalidParameterHandler invalidParameterHandler;
    private final SchemaTypeHandler<SchemaType> schemaTypeHandler;
    private final SchemaAttributeHandler<Attribute, SchemaType> schemaAttributeHandler;
    private final DataEngineRegistrationHandler dataEngineRegistrationHandler;
    private final DataEngineCommonHandler dataEngineCommonHandler;

    public DataEngineSchemaTypeHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, SchemaTypeHandler<SchemaType> schemaTypeHandler, SchemaAttributeHandler<Attribute, SchemaType> schemaAttributeHandler, DataEngineRegistrationHandler dataEngineRegistrationHandler, DataEngineCommonHandler dataEngineCommonHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.schemaTypeHandler = schemaTypeHandler;
        this.schemaAttributeHandler = schemaAttributeHandler;
        this.dataEngineRegistrationHandler = dataEngineRegistrationHandler;
        this.dataEngineCommonHandler = dataEngineCommonHandler;
    }

    public String upsertSchemaType(String userId, SchemaType schemaType, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String schemaTypeGUID;
        String methodName = "upsertSchemaType";
        this.invalidParameterHandler.validateUserId(userId, "upsertSchemaType");
        this.invalidParameterHandler.validateName(schemaType.getQualifiedName(), "qualifiedName", "upsertSchemaType");
        this.invalidParameterHandler.validateName(schemaType.getDisplayName(), "displayName", "upsertSchemaType");
        Optional<EntityDetail> originalSchemaTypeEntity = this.findSchemaTypeEntity(userId, schemaType.getQualifiedName());
        SchemaTypeBuilder schemaTypeBuilder = this.getSchemaTypeBuilder(schemaType);
        String externalSourceGUID = this.dataEngineRegistrationHandler.getExternalDataEngine(userId, externalSourceName);
        if (originalSchemaTypeEntity.isEmpty()) {
            schemaTypeGUID = this.schemaTypeHandler.addSchemaType(userId, externalSourceGUID, externalSourceName, schemaTypeBuilder, "upsertSchemaType");
        } else {
            schemaTypeGUID = originalSchemaTypeEntity.get().getGUID();
            EntityDetail updatedSchemaTypeEntity = this.buildSchemaTypeEntityDetail(schemaTypeGUID, schemaType);
            EntityDetailDifferences entityDetailDifferences = this.repositoryHelper.getEntityDetailDifferences(originalSchemaTypeEntity.get(), updatedSchemaTypeEntity, true);
            if (entityDetailDifferences.hasInstancePropertiesDifferences()) {
                this.schemaTypeHandler.updateSchemaType(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, SCHEMA_TYPE_GUID_PARAMETER_NAME, schemaTypeBuilder);
            }
        }
        this.upsertSchemaAttributes(userId, schemaType, schemaTypeGUID, externalSourceName);
        return schemaTypeGUID;
    }

    public Optional<EntityDetail> findSchemaTypeEntity(String userId, String qualifiedName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        return this.dataEngineCommonHandler.findEntity(userId, qualifiedName, "SchemaType");
    }

    public Optional<EntityDetail> findSchemaAttributeEntity(String userId, String qualifiedName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        return this.dataEngineCommonHandler.findEntity(userId, qualifiedName, "SchemaAttribute");
    }

    public void addLineageMappingRelationship(String userId, String sourceQualifiedName, String targetQualifiedName, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addLineageMappingRelationship";
        this.invalidParameterHandler.validateUserId(userId, "addLineageMappingRelationship");
        this.invalidParameterHandler.validateName(sourceQualifiedName, "qualifiedName", "addLineageMappingRelationship");
        this.invalidParameterHandler.validateName(targetQualifiedName, "qualifiedName", "addLineageMappingRelationship");
        Optional<EntityDetail> sourceEntity = this.getLineageMappingEntity(userId, sourceQualifiedName);
        Optional<EntityDetail> targetEntity = this.getLineageMappingEntity(userId, targetQualifiedName);
        if (sourceEntity.isEmpty()) {
            this.dataEngineCommonHandler.throwInvalidParameterException(DataEngineErrorCode.REFERENCEABLE_NOT_FOUND, "addLineageMappingRelationship", sourceQualifiedName);
            return;
        }
        if (targetEntity.isEmpty()) {
            this.dataEngineCommonHandler.throwInvalidParameterException(DataEngineErrorCode.REFERENCEABLE_NOT_FOUND, "addLineageMappingRelationship", targetQualifiedName);
            return;
        }
        this.dataEngineCommonHandler.upsertExternalRelationship(userId, sourceEntity.get().getGUID(), targetEntity.get().getGUID(), "LineageMapping", sourceEntity.get().getType().getTypeDefName(), externalSourceName, null);
    }

    private Optional<EntityDetail> getLineageMappingEntity(String userId, String qualifiedName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        Optional<EntityDetail> assetEntity;
        Optional<EntityDetail> referenceableEntity = this.dataEngineCommonHandler.findEntity(userId, qualifiedName, "Referenceable");
        if (referenceableEntity.isEmpty()) {
            return Optional.empty();
        }
        EntityDetail entityDetail = referenceableEntity.get();
        if ("TabularSchemaType".equalsIgnoreCase(entityDetail.getType().getTypeDefName()) && (assetEntity = this.dataEngineCommonHandler.getEntityForRelationship(userId, entityDetail.getGUID(), "AssetSchemaType", "TabularSchemaType")).isPresent()) {
            entityDetail = assetEntity.get();
        }
        return Optional.of(entityDetail);
    }

    public void removeSchemaType(String userId, String schemaTypeGUID, String externalSourceName, DeleteSemantic deleteSemantic) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "removeSchemaType";
        this.dataEngineCommonHandler.validateDeleteSemantic(deleteSemantic, "removeSchemaType");
        this.invalidParameterHandler.validateUserId(userId, "removeSchemaType");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "guid", "removeSchemaType");
        Set<String> schemaAttributeGUIDs = this.getSchemaAttributesForSchemaType(userId, schemaTypeGUID);
        for (String schemaAttributeGUID : schemaAttributeGUIDs) {
            this.dataEngineCommonHandler.removeEntity(userId, schemaAttributeGUID, "TabularColumn", externalSourceName);
        }
        this.dataEngineCommonHandler.removeEntity(userId, schemaTypeGUID, "TabularSchemaType", externalSourceName);
    }

    private Set<String> getSchemaAttributesForSchemaType(String userId, String schemaTypeGUID) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        Set<EntityDetail> entities = this.dataEngineCommonHandler.getEntitiesForRelationship(userId, schemaTypeGUID, "AttributeForSchema", "SchemaType");
        if (CollectionUtils.isEmpty(entities)) {
            return new HashSet<String>();
        }
        return entities.parallelStream().map(InstanceHeader::getGUID).collect(Collectors.toSet());
    }

    private void upsertSchemaAttributes(String userId, SchemaType schemaType, String schemaTypeGUID, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "upsertSchemaAttributes";
        for (Attribute tabularColumn : schemaType.getAttributeList()) {
            Optional<EntityDetail> schemaAttributeEntity = this.findSchemaAttributeEntity(userId, tabularColumn.getQualifiedName());
            if (schemaAttributeEntity.isEmpty()) {
                this.createSchemaAttribute(userId, schemaType, schemaTypeGUID, tabularColumn, tabularColumn.getDataType(), externalSourceName);
                continue;
            }
            String schemaAttributeGUID = schemaAttributeEntity.get().getGUID();
            EntityDetail updatedSchemaAttributeEntity = this.buildSchemaAttributeEntityDetail(schemaAttributeGUID, tabularColumn);
            EntityDetailDifferences entityDetailDifferences = this.repositoryHelper.getEntityDetailDifferences(schemaAttributeEntity.get(), updatedSchemaAttributeEntity, true);
            if (!entityDetailDifferences.hasInstancePropertiesDifferences()) continue;
            String externalSourceGUID = this.dataEngineRegistrationHandler.getExternalDataEngine(userId, externalSourceName);
            this.schemaAttributeHandler.updateSchemaAttribute(userId, externalSourceGUID, externalSourceName, schemaAttributeGUID, this.getSchemaAttributeBuilder(tabularColumn).getInstanceProperties(methodName));
        }
    }

    private EntityDetail buildSchemaAttributeEntityDetail(String schemaAttributeGUID, Attribute attribute) throws InvalidParameterException {
        String methodName = "buildSchemaAttributeEntityDetail";
        SchemaAttributeBuilder schemaAttributeBuilder = this.getSchemaAttributeBuilder(attribute);
        return this.dataEngineCommonHandler.buildEntityDetail(schemaAttributeGUID, schemaAttributeBuilder.getInstanceProperties(methodName));
    }

    SchemaAttributeBuilder getSchemaAttributeBuilder(Attribute attribute) {
        HashMap additionalProperties = new HashMap();
        return new SchemaAttributeBuilder(attribute.getQualifiedName(), attribute.getDisplayName(), attribute.getDescription(), attribute.getPosition(), attribute.getMinCardinality(), attribute.getMaxCardinality(), attribute.getIsDeprecated(), attribute.getDefaultValueOverride(), attribute.getAllowsDuplicateValues(), attribute.getOrderedValues(), this.dataEngineCommonHandler.getSortOrder(attribute), attribute.getMinimumLength(), attribute.getLength(), attribute.getPrecision(), attribute.getIsNullable(), attribute.getNativeClass(), attribute.getAliases(), additionalProperties, attribute.getTypeGuid() != null ? attribute.getTypeGuid() : "d81a0425-4e9b-4f31-bc1c-e18c3566da10", attribute.getTypeName() != null ? attribute.getTypeName() : "TabularColumn", null, this.repositoryHelper, this.serviceName, this.serverName);
    }

    private void createSchemaAttribute(String userId, SchemaType schemaType, String schemaTypeGUID, Attribute attribute, String dataType, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSchemaAttribute";
        SchemaAttributeBuilder schemaAttributeBuilder = this.getSchemaAttributeBuilder(attribute);
        SchemaTypeBuilder schemaTypeBuilder = this.getSchemaTypeBuilder(schemaType);
        schemaTypeBuilder.setDataType(dataType);
        schemaAttributeBuilder.setSchemaType(userId, schemaTypeBuilder, "createSchemaAttribute");
        String qualifiedNameParameterName = "schemaAttribute.getQualifiedName()";
        String externalSourceGUID = this.dataEngineRegistrationHandler.getExternalDataEngine(userId, externalSourceName);
        this.schemaAttributeHandler.createNestedSchemaAttribute(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, SCHEMA_TYPE_GUID_PARAMETER_NAME, "TabularSchemaType", "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", attribute.getQualifiedName(), "schemaAttribute.getQualifiedName()", schemaAttributeBuilder, "createSchemaAttribute");
    }

    private EntityDetail buildSchemaTypeEntityDetail(String schemaTypeGUID, SchemaType schemaType) throws InvalidParameterException {
        String methodName = "buildSchemaTypeEntityDetail";
        SchemaTypeBuilder schemaTypeBuilder = this.getSchemaTypeBuilder(schemaType);
        return this.dataEngineCommonHandler.buildEntityDetail(schemaTypeGUID, schemaTypeBuilder.getInstanceProperties(methodName));
    }

    SchemaTypeBuilder getSchemaTypeBuilder(SchemaType schemaType) {
        return new SchemaTypeBuilder(schemaType.getQualifiedName(), schemaType.getDisplayName(), null, schemaType.getVersionNumber(), false, schemaType.getAuthor(), schemaType.getUsage(), schemaType.getEncodingStandard(), null, null, "248975ec-8019-4b8a-9caf-084c8b724233", "TabularSchemaType", null, this.repositoryHelper, this.serviceName, this.serverName);
    }
}

