/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.builders;

import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class EndpointBuilder
extends ReferenceableBuilder {
    private final String protocol;
    private final String networkAddress;

    public EndpointBuilder(String protocol, String networkAddress, String qualifiedName, String typeId, String typeName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, typeId, typeName, repositoryHelper, serviceName, serverName);
        this.protocol = protocol;
        this.networkAddress = networkAddress;
    }

    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.networkAddress != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "networkAddress", this.networkAddress, methodName);
        }
        if (this.protocol != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "protocol", this.protocol, methodName);
        }
        return properties;
    }
}

