/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.handlers;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.dataengine.model.DeleteSemantic;
import org.odpi.openmetadata.accessservices.dataengine.model.EventType;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineCommonHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineRegistrationHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineSchemaAttributeHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.EventTypeHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;

public class DataEngineEventTypeHandler {
    private final InvalidParameterHandler invalidParameterHandler;
    private final EventTypeHandler<EventType> eventTypeHandler;
    private final DataEngineCommonHandler dataEngineCommonHandler;
    private final DataEngineRegistrationHandler registrationHandler;
    private final DataEngineSchemaAttributeHandler dataEngineSchemaAttributeHandler;
    public static final String EVENT_TYPE_GUID_PARAMETER_NAME = "eventTypeGUID";

    public DataEngineEventTypeHandler(InvalidParameterHandler invalidParameterHandler, EventTypeHandler<EventType> eventTypeHandler, DataEngineRegistrationHandler dataEngineRegistrationHandler, DataEngineCommonHandler dataEngineCommonHandler, DataEngineSchemaAttributeHandler dataEngineSchemaAttributeHandler) {
        this.invalidParameterHandler = invalidParameterHandler;
        this.eventTypeHandler = eventTypeHandler;
        this.registrationHandler = dataEngineRegistrationHandler;
        this.dataEngineCommonHandler = dataEngineCommonHandler;
        this.dataEngineSchemaAttributeHandler = dataEngineSchemaAttributeHandler;
    }

    public String upsertEventType(String userId, EventType eventType, String topicGUID, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String eventTypeGUID;
        String methodName = "upsertEventType";
        this.validateParameters(userId, "upsertEventType", eventType.getQualifiedName(), eventType.getDisplayName());
        Optional<EntityDetail> originalEventTypeEntity = this.dataEngineCommonHandler.findEntity(userId, eventType.getQualifiedName(), "EventType");
        String externalSourceGUID = this.registrationHandler.getExternalDataEngine(userId, externalSourceName);
        if (originalEventTypeEntity.isEmpty()) {
            this.eventTypeHandler.verifyExternalSourceIdentity(userId, externalSourceGUID, externalSourceName, false, false, null, null);
            eventTypeGUID = this.eventTypeHandler.createEventType(userId, externalSourceGUID, externalSourceName, topicGUID, "topicGUID", eventType.getQualifiedName(), eventType.getDisplayName(), eventType.getDescription(), eventType.getVersionNumber(), eventType.getIsDeprecated(), eventType.getAuthor(), eventType.getUsage(), eventType.getEncodingStandard(), eventType.getNamespace(), eventType.getAdditionalProperties(), "EventType", null, "upsertEventType");
        } else {
            eventTypeGUID = originalEventTypeEntity.get().getGUID();
            this.eventTypeHandler.updateEventType(userId, externalSourceGUID, externalSourceName, eventTypeGUID, EVENT_TYPE_GUID_PARAMETER_NAME, eventType.getQualifiedName(), eventType.getDisplayName(), eventType.getDescription(), eventType.getVersionNumber(), eventType.getIsDeprecated(), eventType.getAuthor(), eventType.getUsage(), eventType.getEncodingStandard(), eventType.getNamespace(), eventType.getAdditionalProperties(), "EventType", null, true, "upsertEventType");
        }
        List attributeList = eventType.getAttributeList();
        if (CollectionUtils.isNotEmpty((Collection)attributeList)) {
            attributeList.forEach(column -> {
                column.setTypeName("EventSchemaAttribute");
                column.setTypeGuid("5be4ee8f-4d0c-45cd-a411-22a468950342");
            });
        }
        this.dataEngineSchemaAttributeHandler.upsertSchemaAttributes(userId, attributeList, externalSourceName, externalSourceGUID, eventTypeGUID);
        return eventTypeGUID;
    }

    private void validateParameters(String userId, String methodName, String qualifiedName, String displayName) throws InvalidParameterException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.validateName(displayName, "displayName", methodName);
    }

    public void removeEventType(String userId, String eventTypeGUID, String qualifiedName, String externalSourceName, DeleteSemantic deleteSemantic) throws FunctionNotSupportedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeEventType";
        this.dataEngineCommonHandler.validateDeleteSemantic(deleteSemantic, "removeEventType");
        String externalSourceGUID = this.registrationHandler.getExternalDataEngine(userId, externalSourceName);
        this.eventTypeHandler.removeEventType(userId, externalSourceGUID, externalSourceName, eventTypeGUID, EVENT_TYPE_GUID_PARAMETER_NAME, qualifiedName, "removeEventType");
    }
}

