/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.handlers;

import java.util.Optional;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineErrorCode;
import org.odpi.openmetadata.accessservices.dataengine.model.DeleteSemantic;
import org.odpi.openmetadata.accessservices.dataengine.model.Port;
import org.odpi.openmetadata.accessservices.dataengine.model.PortAlias;
import org.odpi.openmetadata.accessservices.dataengine.model.PortImplementation;
import org.odpi.openmetadata.accessservices.dataengine.model.PortType;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineCommonHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineRegistrationHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.PortBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.PortHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetailDifferences;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;

public class DataEnginePortHandler {
    private final String serviceName;
    private final String serverName;
    private final OMRSRepositoryHelper repositoryHelper;
    private final InvalidParameterHandler invalidParameterHandler;
    private final DataEngineCommonHandler dataEngineCommonHandler;
    private final PortHandler<Port> portHandler;
    private final DataEngineRegistrationHandler registrationHandler;
    private static final String PROCESS_GUID_PARAMETER_NAME = "processGUID";
    private static final String PORT_GUID_PARAMETER_NAME = "portGUID";
    private static final String SCHEMA_TYPE_GUID_PARAMETER_NAME = "schemaTypeGUID";

    public DataEnginePortHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, DataEngineCommonHandler dataEngineCommonHandler, PortHandler<Port> portHandler, DataEngineRegistrationHandler registrationHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.dataEngineCommonHandler = dataEngineCommonHandler;
        this.portHandler = portHandler;
        this.registrationHandler = registrationHandler;
    }

    public String createPortImplementation(String userId, PortImplementation portImplementation, String processGUID, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createPort(userId, (Port)portImplementation, "PortImplementation", processGUID, externalSourceName);
    }

    public String createPortAlias(String userId, PortAlias portAlias, String processGUID, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createPort(userId, (Port)portAlias, "PortAlias", processGUID, externalSourceName);
    }

    public void updatePortImplementation(String userId, EntityDetail originalPortEntity, PortImplementation portImplementation, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updatePort(userId, originalPortEntity, (Port)portImplementation, "PortImplementation", externalSourceName);
    }

    public void updatePortAlias(String userId, EntityDetail originalPortEntity, PortAlias portAlias, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updatePort(userId, originalPortEntity, (Port)portAlias, "PortAlias", externalSourceName);
    }

    private String createPort(String userId, Port port, String entityTpeName, String processGUID, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createPort";
        this.validatePortParameters(userId, port.getQualifiedName(), port.getDisplayName(), "createPort");
        this.invalidParameterHandler.validateGUID(processGUID, "guid", "createPort");
        String externalSourceGUID = this.registrationHandler.getExternalDataEngine(userId, externalSourceName);
        return this.portHandler.createPort(userId, externalSourceGUID, externalSourceName, processGUID, PROCESS_GUID_PARAMETER_NAME, port.getQualifiedName(), port.getDisplayName(), port.getPortType().getOrdinal(), port.getAdditionalProperties(), entityTpeName, null, "createPort");
    }

    private void updatePort(String userId, EntityDetail originalPortEntity, Port port, String entityTypeName, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updatePort";
        this.validatePortParameters(userId, port.getQualifiedName(), port.getDisplayName(), "updatePort");
        String portGUID = originalPortEntity.getGUID();
        String externalSourceGUID = this.registrationHandler.getExternalDataEngine(userId, externalSourceName);
        PortBuilder updatedPortBuilder = new PortBuilder(port.getQualifiedName(), port.getDisplayName(), port.getPortType().getOrdinal(), port.getAdditionalProperties(), externalSourceGUID, externalSourceName, null, this.repositoryHelper, this.serviceName, this.serverName);
        EntityDetail updatedPortEntity = this.dataEngineCommonHandler.buildEntityDetail(portGUID, updatedPortBuilder.getInstanceProperties("updatePort"));
        EntityDetailDifferences entityDetailDifferences = this.repositoryHelper.getEntityDetailDifferences(originalPortEntity, updatedPortEntity, true);
        if (!entityDetailDifferences.hasInstancePropertiesDifferences()) {
            return;
        }
        this.portHandler.updatePort(userId, externalSourceGUID, externalSourceName, portGUID, PORT_GUID_PARAMETER_NAME, port.getQualifiedName(), port.getDisplayName(), port.getPortType().getOrdinal(), port.getAdditionalProperties(), entityTypeName, null, "updatePort");
    }

    public void addPortSchemaRelationship(String userId, String portGUID, String schemaTypeGUID, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addPortSchemaRelationship";
        this.invalidParameterHandler.validateUserId(userId, "addPortSchemaRelationship");
        this.invalidParameterHandler.validateGUID(portGUID, "guid", "addPortSchemaRelationship");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "guid", "addPortSchemaRelationship");
        Optional<Relationship> relationship = this.dataEngineCommonHandler.findRelationship(userId, portGUID, schemaTypeGUID, "Port", "SchemaType", "PortSchema");
        if (relationship.isEmpty()) {
            String externalSourceGUID = this.registrationHandler.getExternalDataEngine(userId, externalSourceName);
            this.portHandler.setupPortSchemaType(userId, externalSourceGUID, externalSourceName, portGUID, PORT_GUID_PARAMETER_NAME, schemaTypeGUID, SCHEMA_TYPE_GUID_PARAMETER_NAME, "addPortSchemaRelationship");
        }
    }

    public Optional<EntityDetail> findSchemaTypeForPort(String userId, String portGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataEngineCommonHandler.getEntityForRelationship(userId, portGUID, "PortSchema", "Port");
    }

    public void addPortDelegationRelationship(String userId, String portGUID, PortType portType, String delegatesToQualifiedName, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String delegatedPortGUID;
        Optional<Relationship> relationship;
        String methodName = "addPortDelegationRelationship";
        this.invalidParameterHandler.validateUserId(userId, "addPortDelegationRelationship");
        this.invalidParameterHandler.validateName(delegatesToQualifiedName, "qualifiedName", "addPortDelegationRelationship");
        Optional<EntityDetail> delegatedPortEntity = this.findPortEntity(userId, delegatesToQualifiedName);
        if (delegatedPortEntity.isEmpty()) {
            this.dataEngineCommonHandler.throwInvalidParameterException(DataEngineErrorCode.PORT_NOT_FOUND, "addPortDelegationRelationship", delegatesToQualifiedName);
        }
        String delegatedPortType = this.getPortType(delegatedPortEntity.get());
        if (!portType.getName().equalsIgnoreCase(delegatedPortType)) {
            this.dataEngineCommonHandler.throwInvalidParameterException(DataEngineErrorCode.INVALID_PORT_TYPE, "addPortDelegationRelationship", delegatesToQualifiedName, delegatedPortType);
        }
        if ((relationship = this.dataEngineCommonHandler.findRelationship(userId, portGUID, delegatedPortGUID = delegatedPortEntity.get().getGUID(), "Port", "Port", "PortDelegation")).isEmpty()) {
            String externalSourceGUID = this.registrationHandler.getExternalDataEngine(userId, externalSourceName);
            this.portHandler.setupPortDelegation(userId, externalSourceGUID, externalSourceName, portGUID, PORT_GUID_PARAMETER_NAME, delegatedPortGUID, PORT_GUID_PARAMETER_NAME, "addPortDelegationRelationship");
        }
    }

    public void removePort(String userId, String portGUID, String externalSourceName, DeleteSemantic deleteSemantic) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "removePort";
        this.dataEngineCommonHandler.validateDeleteSemantic(deleteSemantic, "removePort");
        String externalSourceGUID = this.registrationHandler.getExternalDataEngine(userId, externalSourceName);
        this.portHandler.removePort(userId, externalSourceGUID, externalSourceName, portGUID, PORT_GUID_PARAMETER_NAME, "removePort");
    }

    public Optional<EntityDetail> findPortImplementationEntity(String userId, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataEngineCommonHandler.findEntity(userId, qualifiedName, "PortImplementation");
    }

    public Optional<EntityDetail> findPortAliasEntity(String userId, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataEngineCommonHandler.findEntity(userId, qualifiedName, "PortAlias");
    }

    public Optional<EntityDetail> findPortEntity(String userId, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        Optional<EntityDetail> portEntity = this.findPortAliasEntity(userId, qualifiedName);
        if (portEntity.isEmpty()) {
            portEntity = this.findPortImplementationEntity(userId, qualifiedName);
        }
        return portEntity;
    }

    private String getPortType(EntityDetail delegatedPort) {
        if (delegatedPort == null) {
            return null;
        }
        InstanceProperties instanceProperties = delegatedPort.getProperties();
        if (instanceProperties == null) {
            return null;
        }
        EnumPropertyValue portTypeValue = (EnumPropertyValue)delegatedPort.getProperties().getPropertyValue("portType");
        if (portTypeValue == null) {
            return null;
        }
        return portTypeValue.getSymbolicName();
    }

    private void validatePortParameters(String userId, String qualifiedName, String displayName, String methodName) throws InvalidParameterException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(displayName, "displayName", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
    }
}

