/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineErrorCode;
import org.odpi.openmetadata.accessservices.dataengine.model.Attribute;
import org.odpi.openmetadata.accessservices.dataengine.model.CSVFile;
import org.odpi.openmetadata.accessservices.dataengine.model.DataFile;
import org.odpi.openmetadata.accessservices.dataengine.model.Database;
import org.odpi.openmetadata.accessservices.dataengine.model.DatabaseSchema;
import org.odpi.openmetadata.accessservices.dataengine.model.DeleteSemantic;
import org.odpi.openmetadata.accessservices.dataengine.model.EventType;
import org.odpi.openmetadata.accessservices.dataengine.model.LineageMapping;
import org.odpi.openmetadata.accessservices.dataengine.model.ParentProcess;
import org.odpi.openmetadata.accessservices.dataengine.model.Port;
import org.odpi.openmetadata.accessservices.dataengine.model.PortAlias;
import org.odpi.openmetadata.accessservices.dataengine.model.PortImplementation;
import org.odpi.openmetadata.accessservices.dataengine.model.Process;
import org.odpi.openmetadata.accessservices.dataengine.model.ProcessHierarchy;
import org.odpi.openmetadata.accessservices.dataengine.model.Referenceable;
import org.odpi.openmetadata.accessservices.dataengine.model.RelationalTable;
import org.odpi.openmetadata.accessservices.dataengine.model.SchemaType;
import org.odpi.openmetadata.accessservices.dataengine.model.SoftwareServerCapability;
import org.odpi.openmetadata.accessservices.dataengine.model.Topic;
import org.odpi.openmetadata.accessservices.dataengine.model.UpdateSemantic;
import org.odpi.openmetadata.accessservices.dataengine.rest.DataEngineOMASAPIRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.DataEngineRegistrationRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.DataFileRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.DatabaseRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.DatabaseSchemaRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.DeleteRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.EventTypeRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.FindRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.LineageMappingsRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.PortAliasRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.PortImplementationRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.ProcessHierarchyRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.ProcessRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.RelationalTableRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.SchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.TopicRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.server.admin.DataEngineInstanceHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineCollectionHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineCommonHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineConnectionAndEndpointHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineDataFileHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineEventTypeHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineFindHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineFolderHierarchyHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEnginePortHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineProcessHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineRegistrationHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineRelationalDataHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineSchemaTypeHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineTopicHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ConnectionResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class DataEngineRESTServices {
    private static final Logger log = LoggerFactory.getLogger(DataEngineRESTServices.class);
    private static final String DEBUG_MESSAGE_METHOD_DETAILS = "Calling method {} for entity: {}";
    private static final String DEBUG_MESSAGE_METHOD_RETURN = "Returning from method: {} with response: {}";
    private static final String EXCEPTION_WHILE_ADDING_LINEAGE_MAPPING = "Exception while adding lineage mapping {} : {}";
    private static final String EXCEPTION_WHILE_CREATING_PROCESS = "Exception while creating process {} : {}";
    private static final String EXCEPTION_WHILE_CREATING_PROCESS_HIERARCHY = "Exception while creating process relationships for process {} : {}";
    private static final String DEBUG_DELETE_MESSAGE = "Data Engine OMAS deleted entity with GUID {} and type {}";
    private static final String PROCESS_UPSERT = "Data Engine OMAS has created or updated a Process with qualified name {} and guid {}";
    private static final String EXTERNAL_ENGINE_WAS_REGISTERED = "Data Engine OMAS has registered an external engine with qualified name {} and GUID {}";
    private static final String PROCESS_HIERARCHY_ADDED_BETWEEN_CHILD_AND_PARENT_PROCESS = "Data Engine OMAS has added a relationship of type ProcessHierarchy between child process {} and parent process {}";
    private static final String CHILD_PROCESS = "childProcess";
    public static final String DATABASE_SCHEMA_PARAMETER_NAME = "databaseSchema";
    public static final String DATABASE_PARAMETER_NAME = "database";
    public static final String RELATIONAL_TABLE_PARAMETER_NAME = "relationalTable";
    public static final String SCHEMA = "Schema";
    public static final String SCHEMA_SUFFIX = "::schema";
    public static final String EXTERNAL_SOURCE_NAME_PARAMETER_NAME = "externalSourceName";
    public static final String UPSERT_METHOD_CALLS_FOR = "Method {} will take longer. Inside it, upsert method will be called for: {} and/or {}";
    public static final String TOPIC_PARAMETER_NAME = "topic";
    private static final String EVENT_TYPE_PARAMETER_NAME = "eventType";
    private static final String TOPIC_QUALIFIED_NAME_PARAMETER_NAME = "topicQualifiedName";
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private final DataEngineInstanceHandler instanceHandler = new DataEngineInstanceHandler();

    public GUIDResponse createExternalDataEngine(String serverName, String userId, DataEngineRegistrationRequestBody requestBody) {
        String methodName = "createExternalDataEngine";
        GUIDResponse response = new GUIDResponse();
        try {
            if (requestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "createExternalDataEngine", serverName);
                return response;
            }
            response.setGUID(this.createExternalDataEngine(userId, serverName, requestBody.getSoftwareServerCapability()));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createExternalDataEngine");
        }
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"createExternalDataEngine", (Object)response);
        return response;
    }

    public GUIDResponse getExternalDataEngine(String serverName, String userId, String qualifiedName) {
        String methodName = "getExternalDataEngineByQualifiedName";
        log.debug(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"getExternalDataEngineByQualifiedName", (Object)qualifiedName);
        GUIDResponse response = new GUIDResponse();
        try {
            DataEngineRegistrationHandler handler = this.instanceHandler.getRegistrationHandler(userId, serverName, "getExternalDataEngineByQualifiedName");
            response.setGUID(handler.getExternalDataEngine(userId, qualifiedName));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getExternalDataEngineByQualifiedName");
        }
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"getExternalDataEngineByQualifiedName", (Object)response);
        return response;
    }

    public VoidResponse deleteExternalDataEngine(String userId, String serverName, DeleteRequestBody requestBody) {
        String methodName = "deleteExternalDataEngine";
        VoidResponse response = new VoidResponse();
        try {
            this.deleteExternalDataEngine(userId, serverName, requestBody.getExternalSourceName(), requestBody.getGuid(), requestBody.getQualifiedName(), requestBody.getDeleteSemantic());
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteExternalDataEngine");
        }
        return response;
    }

    public void deleteExternalDataEngine(String userId, String serverName, String externalSourceName, String guid, String qualifiedName, DeleteSemantic deleteSemantic) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, FunctionNotSupportedException {
        String methodName = "deleteExternalDataEngine";
        DataEngineRegistrationHandler dataEngineRegistrationHandler = this.instanceHandler.getRegistrationHandler(userId, serverName, "deleteExternalDataEngine");
        Optional<String> dataEngineGUID = Optional.ofNullable(guid);
        if (dataEngineGUID.isEmpty()) {
            dataEngineGUID = Optional.ofNullable(dataEngineRegistrationHandler.getExternalDataEngine(userId, qualifiedName));
        }
        if (dataEngineGUID.isEmpty()) {
            return;
        }
        dataEngineRegistrationHandler.removeExternalDataEngine(userId, qualifiedName, externalSourceName, deleteSemantic);
        log.debug(DEBUG_DELETE_MESSAGE, dataEngineGUID, (Object)"SoftwareServerCapability");
    }

    public Optional<String> getEntityGUID(String serverName, String userId, String qualifiedName, String typeName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getEntityDetails(serverName, userId, qualifiedName, typeName).map(InstanceHeader::getGUID);
    }

    public Optional<EntityDetail> getEntityDetails(String serverName, String userId, String qualifiedName, String typeName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getEntityDetails";
        if (StringUtils.isEmpty((CharSequence)qualifiedName)) {
            return Optional.empty();
        }
        DataEngineCommonHandler dataEngineCommonHandler = this.instanceHandler.getCommonHandler(userId, serverName, "getEntityDetails");
        return dataEngineCommonHandler.findEntity(userId, qualifiedName, typeName);
    }

    public GUIDResponse upsertSchemaType(String userId, String serverName, SchemaTypeRequestBody schemaTypeRequestBody) {
        String methodName = "upsertSchemaType";
        GUIDResponse response = new GUIDResponse();
        try {
            this.validateRequestBody(userId, serverName, (DataEngineOMASAPIRequestBody)schemaTypeRequestBody, "upsertSchemaType");
            String externalSourceName = schemaTypeRequestBody.getExternalSourceName();
            String schemasTypeGUID = this.upsertSchemaType(userId, serverName, null, schemaTypeRequestBody.getSchemaType(), externalSourceName);
            response.setGUID(schemasTypeGUID);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "upsertSchemaType");
        }
        return response;
    }

    public VoidResponse deleteSchemaType(String userId, String serverName, DeleteRequestBody requestBody) {
        String methodName = "deleteSchemaType";
        VoidResponse response = new VoidResponse();
        try {
            this.validateRequestBody(userId, serverName, (DataEngineOMASAPIRequestBody)requestBody, "deleteSchemaType");
            this.deleteSchemaType(userId, serverName, requestBody.getExternalSourceName(), requestBody.getGuid(), requestBody.getQualifiedName(), requestBody.getDeleteSemantic());
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteSchemaType");
        }
        return response;
    }

    public void deleteSchemaType(String userId, String serverName, String externalSourceName, String guid, String qualifiedName, DeleteSemantic deleteSemantic) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, FunctionNotSupportedException, EntityNotDeletedException {
        String methodName = "deleteSchemaType";
        DataEngineSchemaTypeHandler dataEngineSchemaTypeHandler = this.instanceHandler.getDataEngineSchemaTypeHandler(userId, serverName, "deleteSchemaType");
        String schemaTypeGUID = this.getEntityGUID(userId, serverName, guid, qualifiedName, "SchemaType", "deleteSchemaType");
        dataEngineSchemaTypeHandler.removeSchemaType(userId, schemaTypeGUID, externalSourceName, deleteSemantic);
        log.debug(DEBUG_DELETE_MESSAGE, (Object)schemaTypeGUID, (Object)"SchemaType");
    }

    public GUIDResponse upsertPortImplementation(String userId, String serverName, PortImplementationRequestBody portImplementationRequestBody) {
        String methodName = "upsertPortImplementation";
        GUIDResponse response = new GUIDResponse();
        try {
            this.validateRequestBody(userId, serverName, (DataEngineOMASAPIRequestBody)portImplementationRequestBody, "upsertPortImplementation");
            String processGUID = this.getEntityGUID(serverName, userId, portImplementationRequestBody.getProcessQualifiedName(), "Process").orElse(null);
            String externalSourceName = portImplementationRequestBody.getExternalSourceName();
            PortImplementation portImplementation = portImplementationRequestBody.getPortImplementation();
            this.updateProcessStatus(userId, serverName, processGUID, InstanceStatus.DRAFT, externalSourceName);
            String portImplementationGUID = this.upsertPortImplementation(userId, serverName, portImplementation, processGUID, externalSourceName);
            response.setGUID(portImplementationGUID);
            this.upsertSchemaType(userId, serverName, portImplementationGUID, portImplementation.getSchemaType(), externalSourceName);
            this.updateProcessStatus(userId, serverName, processGUID, InstanceStatus.ACTIVE, externalSourceName);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "upsertPortImplementation");
        }
        return response;
    }

    public GUIDResponse upsertPortAlias(String userId, String serverName, PortAliasRequestBody portAliasRequestBody) {
        String methodName = "upsertPortAliasWithDelegation";
        GUIDResponse response = new GUIDResponse();
        try {
            this.validateRequestBody(userId, serverName, (DataEngineOMASAPIRequestBody)portAliasRequestBody, "upsertPortAliasWithDelegation");
            String processGUID = this.getEntityGUID(serverName, userId, portAliasRequestBody.getProcessQualifiedName(), "Process").orElse(null);
            String externalSourceName = portAliasRequestBody.getExternalSourceName();
            this.updateProcessStatus(userId, serverName, processGUID, InstanceStatus.DRAFT, externalSourceName);
            response.setGUID(this.upsertPortAliasWithDelegation(userId, serverName, portAliasRequestBody.getPortAlias(), processGUID, externalSourceName));
            this.updateProcessStatus(userId, serverName, processGUID, InstanceStatus.ACTIVE, externalSourceName);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "upsertPortAliasWithDelegation");
        }
        return response;
    }

    public VoidResponse deletePort(String userId, String serverName, DeleteRequestBody requestBody, String portType) {
        String methodName = "deletePort";
        VoidResponse response = new VoidResponse();
        try {
            this.validateRequestBody(userId, serverName, (DataEngineOMASAPIRequestBody)requestBody, "deletePort");
            this.deletePort(userId, serverName, requestBody.getExternalSourceName(), requestBody.getGuid(), requestBody.getQualifiedName(), portType, requestBody.getDeleteSemantic());
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deletePort");
        }
        return response;
    }

    public void deletePort(String userId, String serverName, String externalSourceName, String guid, String qualifiedName, String portType, DeleteSemantic deleteSemantic) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, FunctionNotSupportedException, EntityNotDeletedException {
        Optional<EntityDetail> schemaType;
        String methodName = "deletePort";
        String portGUID = this.getEntityGUID(userId, serverName, guid, qualifiedName, "Port", "deletePort");
        DataEnginePortHandler dataEnginePortHandler = this.instanceHandler.getPortHandler(userId, serverName, "deletePort");
        if ("PortImplementation".equalsIgnoreCase(portType) && (schemaType = dataEnginePortHandler.findSchemaTypeForPort(userId, portGUID)).isPresent()) {
            this.deleteSchemaType(userId, serverName, externalSourceName, schemaType.get().getGUID(), null, deleteSemantic);
        }
        dataEnginePortHandler.removePort(userId, portGUID, externalSourceName, deleteSemantic);
        log.debug(DEBUG_DELETE_MESSAGE, (Object)portGUID, (Object)"Port");
    }

    public GUIDResponse addProcessHierarchy(String userId, String serverName, ProcessHierarchyRequestBody processHierarchyRequestBody) {
        String methodName = "addProcessHierarchy";
        GUIDResponse response = new GUIDResponse();
        try {
            this.validateRequestBody(userId, serverName, (DataEngineOMASAPIRequestBody)processHierarchyRequestBody, "addProcessHierarchy");
            response.setGUID(this.addProcessHierarchyToProcess(userId, serverName, processHierarchyRequestBody.getProcessHierarchy(), processHierarchyRequestBody.getExternalSourceName()));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addProcessHierarchy");
        }
        return response;
    }

    public GUIDResponse upsertProcess(String userId, String serverName, ProcessRequestBody processRequestBody) {
        String methodName = "upsertProcess";
        GUIDResponse response = new GUIDResponse();
        try {
            this.validateRequestBody(userId, serverName, (DataEngineOMASAPIRequestBody)processRequestBody, "upsertProcess");
            Process process = processRequestBody.getProcess();
            if (process == null) {
                this.restExceptionHandler.handleMissingValue("process", "upsertProcess");
                return response;
            }
            return this.upsertProcess(userId, serverName, process, processRequestBody.getExternalSourceName());
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "upsertProcess");
            return response;
        }
    }

    public VoidResponse deleteProcess(String userId, String serverName, DeleteRequestBody requestBody) {
        String methodName = "deleteProcess";
        VoidResponse response = new VoidResponse();
        try {
            this.validateRequestBody(userId, serverName, (DataEngineOMASAPIRequestBody)requestBody, "deleteProcess");
            this.deleteProcess(userId, serverName, requestBody.getExternalSourceName(), requestBody.getGuid(), requestBody.getQualifiedName(), requestBody.getDeleteSemantic());
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteProcess");
        }
        return response;
    }

    public void deleteProcess(String userId, String serverName, String externalSourceName, String guid, String qualifiedName, DeleteSemantic deleteSemantic) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, FunctionNotSupportedException, EntityNotDeletedException {
        String methodName = "deleteProcess";
        String processGUID = this.getEntityGUID(userId, serverName, guid, qualifiedName, "Process", "deleteProcess");
        DataEngineProcessHandler processHandler = this.instanceHandler.getProcessHandler(userId, serverName, "deleteProcess");
        Set<EntityDetail> portImplementations = processHandler.getPortsForProcess(userId, processGUID, "PortImplementation");
        for (EntityDetail port : portImplementations) {
            this.deletePort(userId, serverName, externalSourceName, port.getGUID(), null, "PortImplementation", deleteSemantic);
        }
        Set<EntityDetail> portAliases = processHandler.getPortsForProcess(userId, processGUID, "PortAlias");
        for (EntityDetail port : portAliases) {
            this.deletePort(userId, serverName, externalSourceName, port.getGUID(), null, "PortAlias", deleteSemantic);
        }
        processHandler.removeProcess(userId, processGUID, externalSourceName, deleteSemantic);
        log.debug(DEBUG_DELETE_MESSAGE, (Object)processGUID, (Object)"Process");
    }

    public String upsertPortAliasWithDelegation(String userId, String serverName, PortAlias portAlias, String processGUID, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String portAliasGUID;
        String methodName = "upsertPortAliasWithDelegation";
        log.trace(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"upsertPortAliasWithDelegation", (Object)portAlias);
        DataEnginePortHandler dataEnginePortHandler = this.instanceHandler.getPortHandler(userId, serverName, "upsertPortAliasWithDelegation");
        Optional<EntityDetail> portEntity = dataEnginePortHandler.findPortAliasEntity(userId, portAlias.getQualifiedName());
        if (portEntity.isEmpty()) {
            portAliasGUID = dataEnginePortHandler.createPortAlias(userId, portAlias, processGUID, externalSourceName);
        } else {
            portAliasGUID = portEntity.get().getGUID();
            dataEnginePortHandler.updatePortAlias(userId, portEntity.get(), portAlias, externalSourceName);
        }
        if (!StringUtils.isEmpty((CharSequence)portAlias.getDelegatesTo())) {
            dataEnginePortHandler.addPortDelegationRelationship(userId, portAliasGUID, portAlias.getPortType(), portAlias.getDelegatesTo(), externalSourceName);
        }
        log.trace(DEBUG_MESSAGE_METHOD_RETURN, (Object)"upsertPortAliasWithDelegation", (Object)portAliasGUID);
        return portAliasGUID;
    }

    public String addProcessHierarchyToProcess(String userId, String serverName, ProcessHierarchy processHierarchy, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addProcessHierarchyToProcess";
        log.debug(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"addProcessHierarchyToProcess", (Object)processHierarchy);
        DataEngineProcessHandler processHandler = this.instanceHandler.getProcessHandler(userId, serverName, "addProcessHierarchyToProcess");
        Optional<EntityDetail> childProcessEntity = processHandler.findProcessEntity(userId, processHierarchy.getChildProcess());
        if (!childProcessEntity.isPresent()) {
            throw new InvalidParameterException(DataEngineErrorCode.PROCESS_NOT_FOUND.getMessageDefinition(new String[]{processHierarchy.getChildProcess()}), this.getClass().getName(), "addProcessHierarchyToProcess", CHILD_PROCESS);
        }
        String childProcessGUID = childProcessEntity.get().getGUID();
        ParentProcess parentProcess = new ParentProcess();
        parentProcess.setQualifiedName(processHierarchy.getParentProcess());
        parentProcess.setProcessContainmentType(processHierarchy.getProcessContainmentType());
        processHandler.upsertProcessHierarchyRelationship(userId, parentProcess, childProcessGUID, externalSourceName);
        log.info(PROCESS_HIERARCHY_ADDED_BETWEEN_CHILD_AND_PARENT_PROCESS, (Object)processHierarchy.getChildProcess(), (Object)processHierarchy.getParentProcess());
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"addProcessHierarchyToProcess", (Object)childProcessGUID);
        return childProcessGUID;
    }

    public String upsertPortImplementation(String userId, String serverName, PortImplementation portImplementation, String processGUID, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, FunctionNotSupportedException {
        String portImplementationGUID;
        String methodName = "upsertPortImplementation";
        log.trace(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"upsertPortImplementation", (Object)portImplementation);
        DataEnginePortHandler dataEnginePortHandler = this.instanceHandler.getPortHandler(userId, serverName, "upsertPortImplementation");
        Optional<EntityDetail> portEntity = dataEnginePortHandler.findPortImplementationEntity(userId, portImplementation.getQualifiedName());
        if (portEntity.isEmpty()) {
            portImplementationGUID = dataEnginePortHandler.createPortImplementation(userId, portImplementation, processGUID, externalSourceName);
        } else {
            Optional<EntityDetail> schemaTypeForPort;
            portImplementationGUID = portEntity.get().getGUID();
            dataEnginePortHandler.updatePortImplementation(userId, portEntity.get(), portImplementation, externalSourceName);
            if (portImplementation.getUpdateSemantic() == UpdateSemantic.REPLACE && (schemaTypeForPort = dataEnginePortHandler.findSchemaTypeForPort(userId, portImplementationGUID)).isPresent()) {
                String oldSchemaTypeQualifiedName = schemaTypeForPort.get().getProperties().getPropertyValue("qualifiedName").valueAsString();
                this.deleteObsoleteSchemaType(userId, serverName, portImplementation.getSchemaType().getQualifiedName(), oldSchemaTypeQualifiedName, externalSourceName);
            }
        }
        log.trace(DEBUG_MESSAGE_METHOD_RETURN, (Object)"upsertPortImplementation", (Object)portImplementationGUID);
        return portImplementationGUID;
    }

    public String createExternalDataEngine(String userId, String serverName, SoftwareServerCapability softwareServerCapability) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createExternalDataEngine";
        log.debug(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"createExternalDataEngine", (Object)softwareServerCapability);
        if (softwareServerCapability == null) {
            return null;
        }
        DataEngineRegistrationHandler handler = this.instanceHandler.getRegistrationHandler(userId, serverName, "createExternalDataEngine");
        String softwareServerCapabilityGUID = handler.upsertExternalDataEngine(userId, softwareServerCapability);
        log.info(EXTERNAL_ENGINE_WAS_REGISTERED, (Object)softwareServerCapability.getQualifiedName(), (Object)softwareServerCapabilityGUID);
        return softwareServerCapabilityGUID;
    }

    public void addLineageMappings(String userId, String serverName, List<LineageMapping> lineageMappings, FFDCResponseBase response, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addLineageMappings";
        log.debug(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"addLineageMappings", lineageMappings);
        if (CollectionUtils.isEmpty(lineageMappings)) {
            return;
        }
        DataEngineSchemaTypeHandler dataEngineSchemaTypeHandler = this.instanceHandler.getDataEngineSchemaTypeHandler(userId, serverName, "addLineageMappings");
        lineageMappings.parallelStream().forEach(lineageMapping -> {
            try {
                dataEngineSchemaTypeHandler.addLineageMappingRelationship(userId, lineageMapping.getSourceAttribute(), lineageMapping.getTargetAttribute(), externalSourceName);
            }
            catch (Exception error) {
                log.error(EXCEPTION_WHILE_ADDING_LINEAGE_MAPPING, (Object)lineageMapping.toString(), (Object)error.toString());
                this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addLineageMappings");
            }
        });
    }

    public VoidResponse addLineageMappings(String userId, String serverName, LineageMappingsRequestBody lineageMappingsRequestBody) {
        String methodName = "addLineageMappings";
        VoidResponse response = new VoidResponse();
        try {
            if (lineageMappingsRequestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "addLineageMappings", serverName);
                return response;
            }
            this.addLineageMappings(userId, serverName, lineageMappingsRequestBody.getLineageMappings(), (FFDCResponseBase)response, lineageMappingsRequestBody.getExternalSourceName());
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addLineageMappings");
        }
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"addLineageMappings", (Object)response);
        return response;
    }

    public ConnectionResponse getInTopicConnection(String serverName, String userId) {
        String methodName = "getInTopicConnection";
        ConnectionResponse response = new ConnectionResponse();
        try {
            response.setConnection(this.instanceHandler.getInTopicConnection(userId, serverName, "getInTopicConnection"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getInTopicConnection");
        }
        return response;
    }

    public String upsertSchemaType(String userId, String serverName, String portImplementationGUID, SchemaType schemaType, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "upsertSchemaType";
        log.debug(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"upsertSchemaType", (Object)schemaType);
        DataEngineSchemaTypeHandler dataEngineSchemaTypeHandler = this.instanceHandler.getDataEngineSchemaTypeHandler(userId, serverName, "upsertSchemaType");
        DataEnginePortHandler dataEnginePortHandler = this.instanceHandler.getPortHandler(userId, serverName, "upsertSchemaType");
        String schemaTypeGUID = dataEngineSchemaTypeHandler.upsertSchemaType(userId, schemaType, externalSourceName);
        if (StringUtils.isNotEmpty((CharSequence)portImplementationGUID)) {
            dataEnginePortHandler.addPortSchemaRelationship(userId, portImplementationGUID, schemaTypeGUID, "upsertSchemaType");
        }
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"upsertSchemaType", (Object)schemaTypeGUID);
        return schemaTypeGUID;
    }

    public GUIDResponse upsertDatabase(String userId, String serverName, DatabaseRequestBody databaseRequestBody) {
        String methodName = "upsertDatabase";
        GUIDResponse response = new GUIDResponse();
        try {
            this.validateDatabaseRequestBody(userId, serverName, databaseRequestBody, "upsertDatabase");
            String databaseGUID = this.upsertDatabase(userId, serverName, databaseRequestBody.getDatabase(), databaseRequestBody.getExternalSourceName());
            response.setGUID(databaseGUID);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "upsertDatabase");
        }
        return response;
    }

    public String upsertDatabase(String userId, String serverName, Database database, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "upsertDatabase";
        log.debug(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"upsertDatabase", (Object)database);
        DatabaseSchema databaseSchema = database.getDatabaseSchema();
        List tables = database.getTables();
        if (databaseSchema != null || CollectionUtils.isNotEmpty((Collection)tables)) {
            log.debug(UPSERT_METHOD_CALLS_FOR, new Object[]{"upsertDatabase", databaseSchema, tables});
        }
        DataEngineRelationalDataHandler dataEngineRelationalDataHandler = this.instanceHandler.getRelationalDataHandler(userId, serverName, "upsertDatabase");
        String databaseGUID = dataEngineRelationalDataHandler.upsertDatabase(userId, database, externalSourceName);
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"upsertDatabase", (Object)databaseGUID);
        return databaseGUID;
    }

    public GUIDResponse upsertDatabaseSchema(String userId, String serverName, DatabaseSchemaRequestBody databaseSchemaRequestBody) {
        String methodName = "upsertDatabaseSchema";
        GUIDResponse response = new GUIDResponse();
        try {
            this.validateDatabaseSchemaRequestBody(userId, serverName, databaseSchemaRequestBody, "upsertDatabaseSchema");
            DatabaseSchema databaseSchema = databaseSchemaRequestBody.getDatabaseSchema();
            String databaseGUID = this.upsertDatabaseSchema(userId, serverName, databaseSchemaRequestBody.getDatabaseQualifiedName(), databaseSchema, databaseSchemaRequestBody.getExternalSourceName());
            response.setGUID(databaseGUID);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "upsertDatabaseSchema");
        }
        return response;
    }

    public String upsertDatabaseSchema(String userId, String serverName, String databaseQualifiedName, DatabaseSchema databaseSchema, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "upsertDatabaseSchema";
        log.debug(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"upsertDatabaseSchema", (Object)databaseSchema);
        DataEngineRelationalDataHandler dataEngineRelationalDataHandler = this.instanceHandler.getRelationalDataHandler(userId, serverName, "upsertDatabaseSchema");
        Optional<EntityDetail> databaseEntityOptional = this.getEntityDetails(serverName, userId, databaseQualifiedName, "Database");
        String databaseGUID = null;
        if (databaseEntityOptional.isPresent()) {
            databaseGUID = databaseEntityOptional.get().getGUID();
        }
        String databaseSchemaGUID = dataEngineRelationalDataHandler.upsertDatabaseSchema(userId, databaseGUID, databaseSchema, externalSourceName);
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"upsertDatabaseSchema", (Object)databaseSchemaGUID);
        return databaseSchemaGUID;
    }

    public VoidResponse deleteDatabase(String userId, String serverName, DeleteRequestBody requestBody) {
        String methodName = "deleteDatabase";
        VoidResponse response = new VoidResponse();
        try {
            this.validateRequestBody(userId, serverName, (DataEngineOMASAPIRequestBody)requestBody, "deleteDatabase");
            this.deleteDatabase(userId, serverName, requestBody.getExternalSourceName(), requestBody.getGuid(), requestBody.getQualifiedName(), requestBody.getDeleteSemantic());
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteDatabase");
        }
        return response;
    }

    public void deleteDatabase(String userId, String serverName, String externalSourceName, String guid, String qualifiedName, DeleteSemantic deleteSemantic) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, EntityNotDeletedException, FunctionNotSupportedException {
        String methodName = "deleteDatabase";
        DataEngineRelationalDataHandler relationalDataHandler = this.instanceHandler.getRelationalDataHandler(userId, serverName, "deleteDatabase");
        String databaseGUID = this.getEntityGUID(userId, serverName, guid, qualifiedName, "Database", "deleteDatabase");
        relationalDataHandler.removeDatabase(userId, databaseGUID, externalSourceName, deleteSemantic);
        log.debug(DEBUG_DELETE_MESSAGE, (Object)databaseGUID, (Object)"Database");
    }

    public VoidResponse deleteDatabaseSchema(String userId, String serverName, DeleteRequestBody requestBody) {
        String methodName = "deleteDatabaseSchema";
        VoidResponse response = new VoidResponse();
        try {
            this.validateRequestBody(userId, serverName, (DataEngineOMASAPIRequestBody)requestBody, "deleteDatabaseSchema");
            this.deleteDatabaseSchema(userId, serverName, requestBody.getExternalSourceName(), requestBody.getGuid(), requestBody.getQualifiedName(), requestBody.getDeleteSemantic());
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteDatabaseSchema");
        }
        return response;
    }

    public void deleteDatabaseSchema(String userId, String serverName, String externalSourceName, String guid, String qualifiedName, DeleteSemantic deleteSemantic) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, EntityNotDeletedException, FunctionNotSupportedException {
        String methodName = "deleteDatabaseSchema";
        DataEngineRelationalDataHandler relationalDataHandler = this.instanceHandler.getRelationalDataHandler(userId, serverName, "deleteDatabaseSchema");
        String databaseSchemaGUID = this.getEntityGUID(userId, serverName, guid, qualifiedName, "DeployedDatabaseSchema", "deleteDatabaseSchema");
        relationalDataHandler.removeDatabaseSchema(userId, databaseSchemaGUID, externalSourceName, deleteSemantic);
        log.debug(DEBUG_DELETE_MESSAGE, (Object)databaseSchemaGUID, (Object)"DeployedDatabaseSchema");
    }

    public GUIDResponse upsertRelationalTable(String userId, String serverName, RelationalTableRequestBody relationalTableRequestBody) {
        String methodName = "upsertRelationalTable";
        GUIDResponse response = new GUIDResponse();
        try {
            this.validateRelationalTableRequestBody(userId, serverName, relationalTableRequestBody, "upsertRelationalTable");
            String relationalTableGUID = this.upsertRelationalTable(userId, serverName, relationalTableRequestBody.getDatabaseSchemaQualifiedName(), relationalTableRequestBody.getRelationalTable(), relationalTableRequestBody.getExternalSourceName());
            response.setGUID(relationalTableGUID);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "upsertRelationalTable");
        }
        return response;
    }

    public String upsertRelationalTable(String userId, String serverName, String databaseSchemaQualifiedName, RelationalTable relationalTable, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "upsertRelationalTable";
        log.debug(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"upsertRelationalTable", (Object)relationalTable);
        DataEngineRelationalDataHandler dataEngineRelationalDataHandler = this.instanceHandler.getRelationalDataHandler(userId, serverName, "upsertRelationalTable");
        String relationalTableGUID = dataEngineRelationalDataHandler.upsertRelationalTable(userId, databaseSchemaQualifiedName, relationalTable, externalSourceName);
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"upsertRelationalTable", (Object)relationalTableGUID);
        return relationalTableGUID;
    }

    public VoidResponse deleteRelationalTable(String userId, String serverName, DeleteRequestBody requestBody) {
        String methodName = "deleteRelationalTable";
        VoidResponse response = new VoidResponse();
        try {
            this.validateRequestBody(userId, serverName, (DataEngineOMASAPIRequestBody)requestBody, "deleteRelationalTable");
            this.deleteRelationalTable(userId, serverName, requestBody.getExternalSourceName(), requestBody.getGuid(), requestBody.getQualifiedName(), requestBody.getDeleteSemantic());
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteRelationalTable");
        }
        return response;
    }

    public void deleteRelationalTable(String userId, String serverName, String externalSourceName, String guid, String qualifiedName, DeleteSemantic deleteSemantic) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, EntityNotDeletedException, FunctionNotSupportedException {
        String methodName = "deleteRelationalTable";
        DataEngineRelationalDataHandler relationalDataHandler = this.instanceHandler.getRelationalDataHandler(userId, serverName, "deleteRelationalTable");
        String relationalTableGUID = this.getEntityGUID(userId, serverName, guid, qualifiedName, "RelationalTable", "deleteRelationalTable");
        relationalDataHandler.removeRelationalTable(userId, relationalTableGUID, externalSourceName, deleteSemantic);
        log.debug(DEBUG_DELETE_MESSAGE, (Object)relationalTableGUID, (Object)"RelationalTable");
    }

    public GUIDResponse upsertDataFile(String serverName, String userId, DataFileRequestBody dataFileRequestBody) {
        String methodName = "upsertDataFile";
        GUIDResponse response = new GUIDResponse();
        try {
            this.validateRequestBody(userId, serverName, (DataEngineOMASAPIRequestBody)dataFileRequestBody, methodName);
            String guid = this.upsertDataFile(userId, serverName, dataFileRequestBody.getDataFile(), dataFileRequestBody.getExternalSourceName());
            response.setGUID(guid);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, methodName);
        }
        return response;
    }

    public String upsertDataFile(String userId, String serverName, DataFile file, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "upsertDataFile";
        log.debug(DEBUG_MESSAGE_METHOD_DETAILS, (Object)methodName, (Object)file);
        DataEngineDataFileHandler dataFileHandler = this.instanceHandler.getDataFileHandler(userId, serverName, methodName);
        DataEngineRegistrationHandler registrationHandler = this.instanceHandler.getRegistrationHandler(userId, serverName, methodName);
        String externalSourceGuid = registrationHandler.getExternalDataEngine(userId, externalSourceName);
        List columns = file.getColumns();
        SchemaType schemaType = this.getDefaultSchemaTypeIfAbsentAndAddAttributes(file, file.getSchema(), columns);
        HashMap<String, Object> extendedProperties = this.getExtendedProperties(file);
        String fileTypeGuid = file instanceof CSVFile ? "2ccb2117-9cee-47ca-8150-9b3a543adcec" : "10752b4a-4b5d-4519-9eae-fdd6d162122f";
        String fileTypeName = file instanceof CSVFile ? "CSVFile" : "DataFile";
        file.setFileType(fileTypeName);
        if (CollectionUtils.isNotEmpty((Collection)columns)) {
            columns.forEach(column -> {
                column.setTypeName("TabularFileColumn");
                column.setTypeGuid("af6265e7-5f58-4a9c-9ae7-8d4284be62bd");
            });
        }
        String guid = dataFileHandler.upsertFileAssetIntoCatalog(fileTypeName, fileTypeGuid, file, schemaType, extendedProperties, externalSourceGuid, externalSourceName, userId, methodName);
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)methodName, (Object)guid);
        return guid;
    }

    public VoidResponse deleteDataFile(String userId, String serverName, DeleteRequestBody requestBody) {
        String methodName = "deleteDataFile";
        VoidResponse response = new VoidResponse();
        try {
            this.validateRequestBody(userId, serverName, (DataEngineOMASAPIRequestBody)requestBody, "deleteDataFile");
            this.deleteDataFile(userId, serverName, requestBody.getExternalSourceName(), requestBody.getGuid(), requestBody.getQualifiedName(), requestBody.getDeleteSemantic());
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteDataFile");
        }
        return response;
    }

    public void deleteDataFile(String userId, String serverName, String externalSourceName, String guid, String qualifiedName, DeleteSemantic deleteSemantic) throws InvalidParameterException, PropertyServerException, EntityNotDeletedException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "deleteDataFile";
        DataEngineDataFileHandler dataFileHandler = this.instanceHandler.getDataFileHandler(userId, serverName, "deleteDataFile");
        DataEngineRegistrationHandler registrationHandler = this.instanceHandler.getRegistrationHandler(userId, serverName, "deleteDataFile");
        String dataFileGUID = this.getEntityGUID(userId, serverName, guid, qualifiedName, "DataFile", "deleteDataFile");
        String externalSourceGuid = registrationHandler.getExternalDataEngine(userId, externalSourceName);
        dataFileHandler.removeDataFile(userId, dataFileGUID, externalSourceName, externalSourceGuid, deleteSemantic);
        log.debug(DEBUG_DELETE_MESSAGE, (Object)dataFileGUID, (Object)"DataFile");
    }

    public VoidResponse deleteFolder(String userId, String serverName, DeleteRequestBody requestBody) {
        String methodName = "deleteFolder";
        VoidResponse response = new VoidResponse();
        try {
            this.validateRequestBody(userId, serverName, (DataEngineOMASAPIRequestBody)requestBody, "deleteFolder");
            this.deleteFolder(userId, serverName, requestBody.getExternalSourceName(), requestBody.getGuid(), requestBody.getQualifiedName(), requestBody.getDeleteSemantic());
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteFolder");
        }
        return response;
    }

    public void deleteFolder(String userId, String serverName, String externalSourceName, String guid, String qualifiedName, DeleteSemantic deleteSemantic) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, EntityNotDeletedException, FunctionNotSupportedException {
        String methodName = "deleteFolder";
        String folderGUID = this.getEntityGUID(userId, serverName, guid, qualifiedName, "FileFolder", "deleteFolder");
        DataEngineFolderHierarchyHandler folderHierarchyHandler = this.instanceHandler.getFolderHierarchyHandler(userId, serverName, "deleteFolder");
        folderHierarchyHandler.removeFolder(userId, folderGUID, deleteSemantic, externalSourceName);
        log.debug(DEBUG_DELETE_MESSAGE, (Object)folderGUID, (Object)"FileFolder");
    }

    public VoidResponse deleteConnection(String userId, String serverName, DeleteRequestBody requestBody) {
        String methodName = "deleteConnection";
        VoidResponse response = new VoidResponse();
        try {
            this.validateRequestBody(userId, serverName, (DataEngineOMASAPIRequestBody)requestBody, "deleteConnection");
            this.deleteConnection(userId, serverName, requestBody.getExternalSourceName(), requestBody.getGuid(), requestBody.getQualifiedName(), requestBody.getDeleteSemantic());
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteConnection");
        }
        return response;
    }

    public void deleteConnection(String userId, String serverName, String externalSourceName, String guid, String qualifiedName, DeleteSemantic deleteSemantic) throws InvalidParameterException, PropertyServerException, EntityNotDeletedException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "deleteConnection";
        String connectionGUID = this.getEntityGUID(userId, serverName, guid, qualifiedName, "Connection", "deleteConnection");
        DataEngineConnectionAndEndpointHandler connectionAndEndpointHandler = this.instanceHandler.getConnectionAndEndpointHandler(userId, serverName, "deleteConnection");
        DataEngineRegistrationHandler registrationHandler = this.instanceHandler.getRegistrationHandler(userId, serverName, "deleteConnection");
        String externalSourceGuid = registrationHandler.getExternalDataEngine(userId, externalSourceName);
        connectionAndEndpointHandler.removeConnection(userId, connectionGUID, deleteSemantic, externalSourceName, externalSourceGuid);
        log.debug(DEBUG_DELETE_MESSAGE, (Object)connectionGUID, (Object)"Connection");
    }

    public VoidResponse deleteEndpoint(String userId, String serverName, DeleteRequestBody requestBody) {
        String methodName = "deleteEndpoint";
        VoidResponse response = new VoidResponse();
        try {
            this.validateRequestBody(userId, serverName, (DataEngineOMASAPIRequestBody)requestBody, "deleteEndpoint");
            this.deleteEndpoint(userId, serverName, requestBody.getExternalSourceName(), requestBody.getGuid(), requestBody.getQualifiedName(), requestBody.getDeleteSemantic());
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteEndpoint");
        }
        return response;
    }

    public void deleteEndpoint(String userId, String serverName, String externalSourceName, String guid, String qualifiedName, DeleteSemantic deleteSemantic) throws InvalidParameterException, PropertyServerException, EntityNotDeletedException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "deleteEndpoint";
        String endpointGUID = this.getEntityGUID(userId, serverName, guid, qualifiedName, "Endpoint", "deleteEndpoint");
        DataEngineConnectionAndEndpointHandler connectionAndEndpointHandler = this.instanceHandler.getConnectionAndEndpointHandler(userId, serverName, "deleteEndpoint");
        DataEngineRegistrationHandler registrationHandler = this.instanceHandler.getRegistrationHandler(userId, serverName, "deleteEndpoint");
        String externalSourceGuid = registrationHandler.getExternalDataEngine(userId, externalSourceName);
        connectionAndEndpointHandler.removeEndpoint(userId, endpointGUID, deleteSemantic, externalSourceName, externalSourceGuid);
        log.debug(DEBUG_DELETE_MESSAGE, (Object)endpointGUID, (Object)"Endpoint");
    }

    private String getEntityGUID(String userId, String serverName, String guid, String qualifiedName, String entityTypeName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, EntityNotDeletedException {
        Optional<String> entityGUIDOptional = Optional.ofNullable(guid);
        if (entityGUIDOptional.isEmpty()) {
            entityGUIDOptional = this.getEntityGUID(serverName, userId, qualifiedName, entityTypeName);
        }
        if (entityGUIDOptional.isPresent()) {
            return entityGUIDOptional.get();
        }
        this.throwEntityNotDeletedException(userId, serverName, methodName, qualifiedName);
        return null;
    }

    private void deleteObsoleteSchemaType(String userId, String serverName, String schemaTypeQualifiedName, String oldSchemaTypeQualifiedName, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, FunctionNotSupportedException {
        String methodName = "deleteObsoleteSchemaType";
        if (oldSchemaTypeQualifiedName.equalsIgnoreCase(schemaTypeQualifiedName)) {
            return;
        }
        Optional<String> schemaTypeGUID = this.getEntityGUID(serverName, userId, oldSchemaTypeQualifiedName, "SchemaType");
        if (schemaTypeGUID.isEmpty()) {
            return;
        }
        DataEngineSchemaTypeHandler dataEngineSchemaTypeHandler = this.instanceHandler.getDataEngineSchemaTypeHandler(userId, serverName, "deleteObsoleteSchemaType");
        dataEngineSchemaTypeHandler.removeSchemaType(userId, schemaTypeGUID.get(), externalSourceName, DeleteSemantic.SOFT);
    }

    public VoidResponse updateProcessStatus(String userId, String serverName, String processGUID, InstanceStatus instanceStatus, String externalSourceName) {
        String methodName = "updateProcessStatus";
        log.trace(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"updateProcessStatus", (Object)processGUID);
        VoidResponse response = new VoidResponse();
        try {
            DataEngineProcessHandler processHandler = this.instanceHandler.getProcessHandler(userId, serverName, "updateProcessStatus");
            processHandler.updateProcessStatus(userId, processGUID, instanceStatus, externalSourceName);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateProcessStatus");
        }
        log.trace(DEBUG_MESSAGE_METHOD_RETURN, (Object)"updateProcessStatus", (Object)response);
        return response;
    }

    public GUIDResponse upsertProcess(String userId, String serverName, Process process, String externalSourceName) {
        String methodName = "upsertProcess";
        log.debug(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"upsertProcess", (Object)process);
        String qualifiedName = process.getQualifiedName();
        List portImplementations = process.getPortImplementations();
        List portAliases = process.getPortAliases();
        UpdateSemantic updateSemantic = process.getUpdateSemantic();
        GUIDResponse response = new GUIDResponse();
        try {
            String processGUID;
            DataEngineProcessHandler processHandler = this.instanceHandler.getProcessHandler(userId, serverName, "upsertProcess");
            Optional<EntityDetail> processEntity = processHandler.findProcessEntity(userId, qualifiedName);
            if (processEntity.isEmpty()) {
                processGUID = processHandler.createProcess(userId, process, externalSourceName);
            } else {
                processGUID = processEntity.get().getGUID();
                processHandler.updateProcess(userId, processEntity.get(), process, externalSourceName);
                processHandler.updateProcessStatus(userId, processGUID, InstanceStatus.DRAFT, externalSourceName);
                if (updateSemantic == UpdateSemantic.REPLACE) {
                    this.deleteObsoletePorts(userId, serverName, portImplementations, processGUID, "PortImplementation", response, externalSourceName);
                    this.deleteObsoletePorts(userId, serverName, portAliases, processGUID, "PortAlias", response, externalSourceName);
                }
            }
            String collectionGUID = this.createCollection(userId, serverName, process.getCollection(), externalSourceName);
            if (collectionGUID != null) {
                this.addProcessCollectionRelationship(userId, serverName, processGUID, collectionGUID, externalSourceName);
            }
            this.upsertPortImplementations(userId, serverName, portImplementations, processGUID, response, externalSourceName);
            this.upsertPortAliases(userId, serverName, portAliases, processGUID, response, externalSourceName);
            if (response.getRelatedHTTPCode() == HttpStatus.OK.value()) {
                processHandler.updateProcessStatus(userId, processGUID, InstanceStatus.ACTIVE, externalSourceName);
                this.addProcessHierarchyRelationships(userId, serverName, process, processGUID, response, externalSourceName);
            }
            log.info(PROCESS_UPSERT, (Object)qualifiedName, (Object)processGUID);
            response.setGUID(processGUID);
        }
        catch (Exception error) {
            log.error(EXCEPTION_WHILE_CREATING_PROCESS, (Object)qualifiedName, (Object)error.toString());
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "upsertProcess");
        }
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"upsertProcess", (Object)response);
        return response;
    }

    private String createCollection(String userId, String serverName, org.odpi.openmetadata.accessservices.dataengine.model.Collection collection, String externalSourceName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        String methodName = "createCollection";
        DataEngineCollectionHandler dataEngineCollectionHandler = this.instanceHandler.getCollectionHandler(userId, serverName, "createCollection");
        if (collection == null) {
            return null;
        }
        String collectionQualifiedName = collection.getQualifiedName();
        Optional<EntityDetail> collectionEntity = dataEngineCollectionHandler.findCollectionEntity(userId, collectionQualifiedName);
        String collectionGUID = collectionEntity.isEmpty() ? dataEngineCollectionHandler.createCollection(userId, collection, externalSourceName) : collectionEntity.get().getGUID();
        return collectionGUID;
    }

    private void addProcessHierarchyRelationships(String userId, String serverName, Process process, String processGUID, GUIDResponse response, String externalSourceName) {
        String methodName = "addProcessHierarchyRelationships";
        List parentProcesses = process.getParentProcesses();
        if (CollectionUtils.isNotEmpty((Collection)parentProcesses)) {
            try {
                DataEngineProcessHandler processHandler = this.instanceHandler.getProcessHandler(userId, serverName, "addProcessHierarchyRelationships");
                for (ParentProcess parentProcess : parentProcesses) {
                    processHandler.upsertProcessHierarchyRelationship(userId, parentProcess, processGUID, externalSourceName);
                }
            }
            catch (Exception error) {
                log.error(EXCEPTION_WHILE_CREATING_PROCESS_HIERARCHY, (Object)process.getQualifiedName(), (Object)error.toString());
                this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addProcessHierarchyRelationships");
            }
        }
    }

    private void addProcessCollectionRelationship(String userId, String serverName, String processGUID, String collectionGUID, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addProcessCollectionRelationship";
        DataEngineCollectionHandler dataEngineCollectionHandler = this.instanceHandler.getCollectionHandler(userId, serverName, "addProcessCollectionRelationship");
        dataEngineCollectionHandler.addCollectionMembershipRelationship(userId, collectionGUID, processGUID, externalSourceName);
    }

    private void deleteObsoletePorts(String userId, String serverName, List<? extends Port> ports, String processGUID, String portTypeName, GUIDResponse response, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deleteObsoletePorts";
        if (CollectionUtils.isEmpty(ports)) {
            return;
        }
        DataEngineProcessHandler processHandler = this.instanceHandler.getProcessHandler(userId, serverName, "deleteObsoletePorts");
        DataEnginePortHandler dataEnginePortHandler = this.instanceHandler.getPortHandler(userId, serverName, "deleteObsoletePorts");
        Set<EntityDetail> existingPorts = processHandler.getPortsForProcess(userId, processGUID, portTypeName);
        Set portQualifiedNames = existingPorts.stream().map(entityDetail -> entityDetail.getProperties().getPropertyValue("qualifiedName").valueAsString()).collect(Collectors.toSet());
        Set newPortQualifiedNames = ports.stream().map(Referenceable::getQualifiedName).collect(Collectors.toSet());
        List<String> obsoletePortQualifiedNames = portQualifiedNames.stream().collect(Collectors.partitioningBy(newPortQualifiedNames::contains)).get(Boolean.FALSE);
        obsoletePortQualifiedNames.forEach(portQualifiedName -> {
            try {
                Optional<String> portGUID = this.getEntityGUID(serverName, userId, (String)portQualifiedName, "Port");
                if (portGUID.isPresent()) {
                    dataEnginePortHandler.removePort(userId, portGUID.get(), externalSourceName, DeleteSemantic.SOFT);
                }
            }
            catch (Exception error) {
                this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteObsoletePorts");
            }
        });
    }

    private void upsertPortImplementations(String userId, String serverName, List<PortImplementation> portImplementations, String processGUID, GUIDResponse response, String externalSourceName) {
        String methodName = "upsertPortImplementations";
        if (CollectionUtils.isEmpty(portImplementations)) {
            return;
        }
        HashMap<String, SchemaType> schemaTypeMap = new HashMap<String, SchemaType>();
        try {
            for (PortImplementation portImplementation : portImplementations) {
                String portGUID2 = this.upsertPortImplementation(userId, serverName, portImplementation, processGUID, externalSourceName);
                schemaTypeMap.put(portGUID2, portImplementation.getSchemaType());
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "upsertPortImplementations");
        }
        schemaTypeMap.keySet().parallelStream().forEach(portGUID -> {
            try {
                this.upsertSchemaType(userId, serverName, (String)portGUID, (SchemaType)schemaTypeMap.get(portGUID), externalSourceName);
            }
            catch (Exception error) {
                this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "upsertPortImplementations");
            }
        });
    }

    private void upsertPortAliases(String userId, String serverName, List<PortAlias> portAliases, String processGUID, GUIDResponse response, String externalSourceName) {
        String methodName = "upsertPortAliases";
        if (CollectionUtils.isNotEmpty(portAliases)) {
            portAliases.forEach(portAlias -> {
                try {
                    this.upsertPortAliasWithDelegation(userId, serverName, (PortAlias)portAlias, processGUID, externalSourceName);
                }
                catch (Exception error) {
                    this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "upsertPortAliases");
                }
            });
        }
    }

    private void validateDatabaseRequestBody(String userId, String serverName, DatabaseRequestBody databaseRequestBody, String methodName) throws InvalidParameterException {
        this.validateRequestBody(userId, serverName, (DataEngineOMASAPIRequestBody)databaseRequestBody, methodName);
        if (databaseRequestBody.getDatabase() == null) {
            this.restExceptionHandler.handleMissingValue(DATABASE_PARAMETER_NAME, methodName);
        }
    }

    private void validateDatabaseSchemaRequestBody(String userId, String serverName, DatabaseSchemaRequestBody databaseSchemaRequestBody, String methodName) throws InvalidParameterException {
        this.validateRequestBody(userId, serverName, (DataEngineOMASAPIRequestBody)databaseSchemaRequestBody, methodName);
        if (databaseSchemaRequestBody.getDatabaseSchema() == null) {
            this.restExceptionHandler.handleMissingValue(DATABASE_SCHEMA_PARAMETER_NAME, methodName);
        }
    }

    private void validateRelationalTableRequestBody(String userId, String serverName, RelationalTableRequestBody relationalTableRequestBody, String methodName) throws InvalidParameterException {
        this.validateRequestBody(userId, serverName, (DataEngineOMASAPIRequestBody)relationalTableRequestBody, methodName);
        if (relationalTableRequestBody.getRelationalTable() == null) {
            this.restExceptionHandler.handleMissingValue(RELATIONAL_TABLE_PARAMETER_NAME, methodName);
        }
    }

    private void validateRequestBody(String userId, String serverName, DataEngineOMASAPIRequestBody requestBody, String methodName) throws InvalidParameterException {
        if (requestBody == null) {
            this.restExceptionHandler.handleNoRequestBody(userId, methodName, serverName);
        }
        if (StringUtils.isEmpty((CharSequence)requestBody.getExternalSourceName())) {
            this.restExceptionHandler.handleMissingValue(EXTERNAL_SOURCE_NAME_PARAMETER_NAME, methodName);
        }
    }

    private SchemaType getDefaultSchemaTypeIfAbsentAndAddAttributes(DataFile file, SchemaType schemaType, List<Attribute> attributes) {
        if (schemaType == null) {
            schemaType = new SchemaType();
            schemaType.setQualifiedName(file.getQualifiedName() + SCHEMA_SUFFIX);
            schemaType.setDisplayName(SCHEMA);
        }
        schemaType.setAttributeList(attributes);
        return schemaType;
    }

    private HashMap<String, Object> getExtendedProperties(DataFile file) {
        HashMap<String, Object> extendedProperties = new HashMap<String, Object>();
        if (file instanceof CSVFile) {
            CSVFile csvFile = (CSVFile)file;
            extendedProperties.put("fileType", csvFile.getFileType());
            extendedProperties.put("delimiterCharacter", csvFile.getDelimiterCharacter());
            extendedProperties.put("quoteCharacter", csvFile.getQuoteCharacter());
        } else {
            extendedProperties.put("fileType", file.getFileType());
        }
        return extendedProperties;
    }

    private void throwEntityNotDeletedException(String userId, String serverName, String methodName, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, EntityNotDeletedException {
        DataEngineCommonHandler dataEngineCommonHandler = this.instanceHandler.getCommonHandler(userId, serverName, methodName);
        dataEngineCommonHandler.throwEntityNotDeletedException(DataEngineErrorCode.ENTITY_NOT_DELETED, methodName, qualifiedName);
    }

    public GUIDListResponse find(String userId, String serverName, FindRequestBody findRequestBody) {
        String methodName = "find";
        log.debug(DEBUG_MESSAGE_METHOD_DETAILS, (Object)methodName, (Object)findRequestBody);
        GUIDListResponse findResponse = new GUIDListResponse();
        try {
            DataEngineFindHandler findHandler = this.instanceHandler.getFindHandler(userId, serverName, methodName);
            findResponse = findHandler.find(findRequestBody, userId, methodName);
        }
        catch (Exception e) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)findResponse, e, methodName);
        }
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)methodName, (Object)findResponse);
        return findResponse;
    }

    public GUIDResponse upsertTopic(String userId, String serverName, TopicRequestBody topicRequestBody) {
        String methodName = "upsertTopic";
        GUIDResponse response = new GUIDResponse();
        try {
            if (!this.isTopicRequestBodyValid(userId, serverName, topicRequestBody, "upsertTopic")) {
                return response;
            }
            String topicGUID = this.upsertTopic(userId, serverName, topicRequestBody.getTopic(), topicRequestBody.getExternalSourceName());
            response.setGUID(topicGUID);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "upsertTopic");
        }
        return response;
    }

    public String upsertTopic(String userId, String serverName, Topic topic, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "upsertTopic";
        log.debug(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"upsertTopic", (Object)topic);
        DataEngineTopicHandler dataEngineTopicHandler = this.instanceHandler.getTopicHandler(userId, serverName, "upsertTopic");
        String topicGUID = dataEngineTopicHandler.upsertTopic(userId, topic, externalSourceName);
        this.upsertEventTypes(userId, serverName, topic.getEventTypes(), topicGUID, externalSourceName);
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"upsertTopic", (Object)topicGUID);
        return topicGUID;
    }

    private void upsertEventTypes(String userId, String serverName, List<EventType> eventTypes, String topicGUID, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (CollectionUtils.isEmpty(eventTypes)) {
            return;
        }
        for (EventType eventType : eventTypes) {
            this.upsertEventType(userId, serverName, eventType, topicGUID, externalSourceName);
        }
    }

    public VoidResponse deleteTopic(String userId, String serverName, DeleteRequestBody requestBody) {
        String methodName = "deleteTopic";
        VoidResponse response = new VoidResponse();
        try {
            this.validateRequestBody(userId, serverName, (DataEngineOMASAPIRequestBody)requestBody, "deleteTopic");
            this.deleteTopic(userId, serverName, requestBody.getExternalSourceName(), requestBody.getGuid(), requestBody.getQualifiedName(), requestBody.getDeleteSemantic());
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteTopic");
        }
        return response;
    }

    public void deleteTopic(String userId, String serverName, String externalSourceName, String guid, String qualifiedName, DeleteSemantic deleteSemantic) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, EntityNotDeletedException, FunctionNotSupportedException {
        String methodName = "deleteTopic";
        DataEngineTopicHandler dataEngineTopicHandler = this.instanceHandler.getTopicHandler(userId, serverName, "deleteTopic");
        String topicGUID = this.getEntityGUID(userId, serverName, guid, qualifiedName, "Topic", "deleteTopic");
        dataEngineTopicHandler.removeTopic(userId, topicGUID, externalSourceName, deleteSemantic);
        log.debug(DEBUG_DELETE_MESSAGE, (Object)topicGUID, (Object)"Topic");
    }

    public GUIDResponse upsertEventType(String userId, String serverName, EventTypeRequestBody eventTypeRequestBody) {
        String methodName = "upsertEventType";
        GUIDResponse response = new GUIDResponse();
        try {
            if (!this.isEventTypeRequestBodyValid(userId, serverName, eventTypeRequestBody, "upsertEventType")) {
                return response;
            }
            String topicGUID = this.getTopicGUID(userId, serverName, eventTypeRequestBody.getTopicQualifiedName(), "upsertEventType");
            String eventTypeGUID = this.upsertEventType(userId, serverName, eventTypeRequestBody.getEventType(), topicGUID, eventTypeRequestBody.getExternalSourceName());
            response.setGUID(eventTypeGUID);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "upsertEventType");
        }
        return response;
    }

    public String getTopicGUID(String userId, String serverName, String topicQualifiedName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        DataEngineTopicHandler dataEngineTopicHandler = this.instanceHandler.getTopicHandler(userId, serverName, methodName);
        DataEngineCommonHandler dataEngineCommonHandler = this.instanceHandler.getCommonHandler(userId, serverName, methodName);
        Optional<EntityDetail> topicEntity = dataEngineTopicHandler.findTopicEntity(userId, topicQualifiedName);
        if (topicEntity.isEmpty()) {
            dataEngineCommonHandler.throwInvalidParameterException(DataEngineErrorCode.TOPIC_NOT_FOUND, methodName, topicQualifiedName);
        }
        return topicEntity.get().getGUID();
    }

    public String upsertEventType(String userId, String serverName, EventType eventType, String topicGUID, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "upsertEventType";
        log.debug(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"upsertEventType", (Object)eventType);
        DataEngineEventTypeHandler dataEngineEventTypeHandler = this.instanceHandler.getEventTypeHandler(userId, serverName, "upsertEventType");
        String eventTypeGUID = dataEngineEventTypeHandler.upsertEventType(userId, eventType, topicGUID, externalSourceName);
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"upsertEventType", (Object)eventTypeGUID);
        return eventTypeGUID;
    }

    public VoidResponse deleteEventType(String userId, String serverName, DeleteRequestBody requestBody) {
        String methodName = "deleteEventType";
        VoidResponse response = new VoidResponse();
        try {
            this.validateRequestBody(userId, serverName, (DataEngineOMASAPIRequestBody)requestBody, "deleteEventType");
            this.deleteEventType(userId, serverName, requestBody.getExternalSourceName(), requestBody.getGuid(), requestBody.getQualifiedName(), requestBody.getDeleteSemantic());
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteEventType");
        }
        return response;
    }

    public void deleteEventType(String userId, String serverName, String externalSourceName, String guid, String qualifiedName, DeleteSemantic deleteSemantic) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, EntityNotDeletedException, FunctionNotSupportedException {
        String methodName = "deleteEventType";
        DataEngineEventTypeHandler dataEngineEventTypeHandler = this.instanceHandler.getEventTypeHandler(userId, serverName, "deleteEventType");
        String eventTypeGUID = this.getEntityGUID(userId, serverName, guid, qualifiedName, "EventType", "deleteEventType");
        dataEngineEventTypeHandler.removeEventType(userId, eventTypeGUID, qualifiedName, externalSourceName, deleteSemantic);
        log.debug(DEBUG_DELETE_MESSAGE, (Object)eventTypeGUID, (Object)"Topic");
    }

    private boolean isTopicRequestBodyValid(String userId, String serverName, TopicRequestBody topicRequestBody, String methodName) throws InvalidParameterException {
        this.validateRequestBody(userId, serverName, (DataEngineOMASAPIRequestBody)topicRequestBody, methodName);
        if (topicRequestBody.getTopic() == null) {
            this.restExceptionHandler.handleMissingValue(TOPIC_PARAMETER_NAME, methodName);
            return false;
        }
        return true;
    }

    private boolean isEventTypeRequestBodyValid(String userId, String serverName, EventTypeRequestBody eventTypeRequestBody, String methodName) throws InvalidParameterException {
        this.validateRequestBody(userId, serverName, (DataEngineOMASAPIRequestBody)eventTypeRequestBody, methodName);
        if (eventTypeRequestBody.getTopicQualifiedName() == null) {
            this.restExceptionHandler.handleMissingValue(TOPIC_QUALIFIED_NAME_PARAMETER_NAME, methodName);
            return false;
        }
        if (eventTypeRequestBody.getEventType() == null) {
            this.restExceptionHandler.handleMissingValue(EVENT_TYPE_PARAMETER_NAME, methodName);
            return false;
        }
        return true;
    }
}

