/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.builders;

import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.AssetBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ProcessPropertiesBuilder
extends AssetBuilder {
    private final String processDisplayName;
    private final String formula;
    private final String implementationLanguage;

    public ProcessPropertiesBuilder(String qualifiedName, String processDisplayName, String technicalName, String technicalDescription, String typeGUID, String typeName, String formula, String implementationLanguage, Map<String, String> additionalProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, technicalName, null, technicalDescription, additionalProperties, typeGUID, typeName, null, repositoryHelper, serviceName, serverName);
        this.processDisplayName = processDisplayName;
        this.formula = formula;
        this.implementationLanguage = implementationLanguage;
    }

    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.processDisplayName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", this.processDisplayName, methodName);
        }
        if (this.formula != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "formula", this.formula, methodName);
        }
        if (this.implementationLanguage != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "implementationLanguage", this.formula, methodName);
        }
        return properties;
    }
}

