/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.listeners;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.odpi.openmetadata.accessservices.dataengine.event.DataEngineEventHeader;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineAuditCode;
import org.odpi.openmetadata.accessservices.dataengine.server.processors.DataEngineEventProcessor;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataEngineInTopicListener
implements OpenMetadataTopicListener {
    private static final Logger log = LoggerFactory.getLogger(DataEngineInTopicListener.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final AuditLog auditLog;
    private final DataEngineEventProcessor dataEngineEventProcessor;

    public DataEngineInTopicListener(AuditLog auditLog, DataEngineEventProcessor dataEngineEventProcessor) {
        this.auditLog = auditLog;
        this.dataEngineEventProcessor = dataEngineEventProcessor;
    }

    public void processEvent(String dataEngineEvent) {
        log.debug("Processing instance event {}", (Object)dataEngineEvent);
        if (dataEngineEvent == null) {
            log.debug("Null instance event - ignoring event");
        } else {
            try {
                DataEngineEventHeader dataEngineEventHeader = (DataEngineEventHeader)OBJECT_MAPPER.readValue(dataEngineEvent, DataEngineEventHeader.class);
                if (dataEngineEventHeader != null) {
                    switch (dataEngineEventHeader.getDataEngineEventType()) {
                        case DATA_ENGINE_REGISTRATION_EVENT: {
                            this.dataEngineEventProcessor.processDataEngineRegistrationEvent(dataEngineEvent);
                            break;
                        }
                        case LINEAGE_MAPPINGS_EVENT: {
                            this.dataEngineEventProcessor.processLineageMappingsEvent(dataEngineEvent);
                            break;
                        }
                        case PORT_ALIAS_EVENT: {
                            this.dataEngineEventProcessor.processPortAliasEvent(dataEngineEvent);
                            break;
                        }
                        case PORT_IMPLEMENTATION_EVENT: {
                            this.dataEngineEventProcessor.processPortImplementationEvent(dataEngineEvent);
                            break;
                        }
                        case PROCESS_EVENT: {
                            this.dataEngineEventProcessor.processProcessEvent(dataEngineEvent);
                            break;
                        }
                        case SCHEMA_TYPE_EVENT: {
                            this.dataEngineEventProcessor.processSchemaTypeEvent(dataEngineEvent);
                            break;
                        }
                        case PROCESS_HIERARCHY_EVENT: {
                            this.dataEngineEventProcessor.processProcessHierarchyEvent(dataEngineEvent);
                            break;
                        }
                        case DELETE_PROCESS_EVENT: {
                            this.dataEngineEventProcessor.processDeleteProcessEvent(dataEngineEvent);
                            break;
                        }
                        case DELETE_PORT_IMPLEMENTATION_EVENT: {
                            this.dataEngineEventProcessor.processDeletePortImplementationEvent(dataEngineEvent);
                            break;
                        }
                        case DELETE_PORT_ALIAS_EVENT: {
                            this.dataEngineEventProcessor.processDeletePortAliasEvent(dataEngineEvent);
                            break;
                        }
                        case DELETE_SCHEMA_TYPE_EVENT: {
                            this.dataEngineEventProcessor.processDeleteSchemaTypeEvent(dataEngineEvent);
                            break;
                        }
                        case DELETE_DATA_ENGINE_EVENT: {
                            this.dataEngineEventProcessor.processDeleteDataEngineEvent(dataEngineEvent);
                            break;
                        }
                        case DATABASE_EVENT: {
                            this.dataEngineEventProcessor.processDatabaseEvent(dataEngineEvent);
                            break;
                        }
                        case DATABASE_SCHEMA_EVENT: {
                            this.dataEngineEventProcessor.processDatabaseSchemaEvent(dataEngineEvent);
                            break;
                        }
                        case RELATIONAL_TABLE_EVENT: {
                            this.dataEngineEventProcessor.processRelationalTableEvent(dataEngineEvent);
                            break;
                        }
                        case DATA_FILE_EVENT: {
                            this.dataEngineEventProcessor.processDataFileEvent(dataEngineEvent);
                            break;
                        }
                        case DELETE_DATABASE_EVENT: {
                            this.dataEngineEventProcessor.processDeleteDatabaseEvent(dataEngineEvent);
                            break;
                        }
                        case DELETE_DATABASE_SCHEMA_EVENT: {
                            this.dataEngineEventProcessor.processDeleteDatabaseSchemaEvent(dataEngineEvent);
                            break;
                        }
                        case DELETE_RELATIONAL_TABLE_EVENT: {
                            this.dataEngineEventProcessor.processDeleteRelationalTableEvent(dataEngineEvent);
                            break;
                        }
                        case DELETE_DATA_FILE_EVENT: {
                            this.dataEngineEventProcessor.processDeleteDataFileEvent(dataEngineEvent);
                            break;
                        }
                        case DELETE_FOLDER_EVENT: {
                            this.dataEngineEventProcessor.processDeleteFolderEvent(dataEngineEvent);
                            break;
                        }
                        case DELETE_CONNECTION_EVENT: {
                            this.dataEngineEventProcessor.processDeleteConnectionEvent(dataEngineEvent);
                            break;
                        }
                        case DELETE_ENDPOINT_EVENT: {
                            this.dataEngineEventProcessor.processDeleteEndpointEvent(dataEngineEvent);
                            break;
                        }
                        case TOPIC_EVENT: {
                            this.dataEngineEventProcessor.processTopicEvent(dataEngineEvent);
                            break;
                        }
                        case EVENT_TYPE_EVENT: {
                            this.dataEngineEventProcessor.processEventTypeEvent(dataEngineEvent);
                            break;
                        }
                        case DELETE_TOPIC_EVENT: {
                            this.dataEngineEventProcessor.processDeleteTopicEvent(dataEngineEvent);
                            break;
                        }
                        case DELETE_EVENT_TYPE_EVENT: {
                            this.dataEngineEventProcessor.processDeleteEventTypeEvent(dataEngineEvent);
                            break;
                        }
                        case PROCESSING_STATE_TYPE_EVENT: {
                            this.dataEngineEventProcessor.processProcessingStateEvent(dataEngineEvent);
                            break;
                        }
                        default: {
                            log.debug("Ignored instance event - unknown event type");
                            break;
                        }
                    }
                } else {
                    log.debug("Ignored instance event - null Data Engine event type");
                }
            }
            catch (JsonProcessingException e) {
                log.debug("Exception processing event from in Data Engine In Topic", (Throwable)e);
                this.auditLog.logException("process Data Engine inTopic Event", DataEngineAuditCode.PROCESS_EVENT_EXCEPTION.getMessageDefinition(new String[]{e.getMessage()}), (Throwable)e);
            }
        }
    }
}

