/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.handlers;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineErrorCode;
import org.odpi.openmetadata.accessservices.dataengine.model.DeleteSemantic;
import org.odpi.openmetadata.accessservices.dataengine.model.ParentProcess;
import org.odpi.openmetadata.accessservices.dataengine.model.Process;
import org.odpi.openmetadata.accessservices.dataengine.model.ProcessContainmentType;
import org.odpi.openmetadata.accessservices.dataengine.server.builders.ProcessPropertiesBuilder;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineCommonHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineRegistrationHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetailDifferences;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;

public class DataEngineProcessHandler {
    private final String serviceName;
    private final String serverName;
    private final OMRSRepositoryHelper repositoryHelper;
    private final InvalidParameterHandler invalidParameterHandler;
    private final AssetHandler<Process> assetHandler;
    private final DataEngineCommonHandler dataEngineCommonHandler;
    private final DataEngineRegistrationHandler registrationHandler;
    public static final String PROCESS_GUID_PARAMETER_NAME = "processGUID";

    public DataEngineProcessHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, AssetHandler<Process> assetHandler, DataEngineRegistrationHandler registrationHandler, DataEngineCommonHandler dataEngineCommonHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.assetHandler = assetHandler;
        this.registrationHandler = registrationHandler;
        this.dataEngineCommonHandler = dataEngineCommonHandler;
    }

    public String createProcess(String userId, Process process, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createProcess";
        this.validateProcessParameters(userId, process.getQualifiedName(), "createProcess");
        String externalSourceGUID = this.registrationHandler.getExternalDataEngine(userId, externalSourceName);
        return this.assetHandler.createAssetInRepository(userId, externalSourceGUID, externalSourceName, process.getQualifiedName(), process.getName(), process.getDescription(), process.getZoneMembership(), process.getOwner(), this.dataEngineCommonHandler.getOwnerTypeOrdinal(process.getOwnerType()), process.getOriginBusinessCapabilityGUID(), process.getOriginBusinessCapabilityGUID(), process.getOtherOriginValues(), process.getAdditionalProperties(), "d8f33bd7-afa9-4a11-a8c7-07dcec83c050", "Process", this.buildProcessExtendedProperties(process), InstanceStatus.DRAFT, "createProcess");
    }

    public void updateProcess(String userId, EntityDetail originalProcessEntity, Process updatedProcess, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateProcess";
        this.validateProcessParameters(userId, updatedProcess.getQualifiedName(), "updateProcess");
        String processGUID = originalProcessEntity.getGUID();
        ProcessPropertiesBuilder updatedProcessBuilder = this.getProcessPropertiesBuilder(updatedProcess);
        InstanceProperties updatedProcessProperties = updatedProcessBuilder.getInstanceProperties("updateProcess");
        EntityDetail updatedProcessEntity = this.dataEngineCommonHandler.buildEntityDetail(processGUID, updatedProcessProperties);
        EntityDetailDifferences entityDetailDifferences = this.repositoryHelper.getEntityDetailDifferences(originalProcessEntity, updatedProcessEntity, true);
        if (!entityDetailDifferences.hasInstancePropertiesDifferences()) {
            return;
        }
        String externalSourceGUID = this.registrationHandler.getExternalDataEngine(userId, externalSourceName);
        this.assetHandler.updateAsset(userId, externalSourceGUID, externalSourceName, processGUID, PROCESS_GUID_PARAMETER_NAME, updatedProcess.getQualifiedName(), updatedProcess.getName(), updatedProcess.getDescription(), updatedProcess.getAdditionalProperties(), "d8f33bd7-afa9-4a11-a8c7-07dcec83c050", "Process", this.buildProcessExtendedProperties(updatedProcess), "updateProcess");
    }

    public Optional<EntityDetail> findProcessEntity(String userId, String qualifiedName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        return this.dataEngineCommonHandler.findEntity(userId, qualifiedName, "Process");
    }

    public void updateProcessStatus(String userId, String processGUID, InstanceStatus instanceStatus, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateProcessStatus";
        String processStatusParameterName = "processStatus";
        this.invalidParameterHandler.validateUserId(userId, "updateProcessStatus");
        this.invalidParameterHandler.validateGUID(processGUID, "guid", "updateProcessStatus");
        TypeDef entityTypeDef = this.repositoryHelper.getTypeDefByName(userId, "Process");
        String externalSourceGUID = this.registrationHandler.getExternalDataEngine(userId, externalSourceName);
        this.assetHandler.updateBeanStatusInRepository(userId, externalSourceGUID, externalSourceName, processGUID, PROCESS_GUID_PARAMETER_NAME, entityTypeDef.getGUID(), entityTypeDef.getName(), instanceStatus, "processStatus", "updateProcessStatus");
    }

    public Set<EntityDetail> getPortsForProcess(String userId, String processGUID, String portTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        Set<EntityDetail> entities = this.dataEngineCommonHandler.getEntitiesForRelationship(userId, processGUID, "ProcessPort", "Process");
        return entities.parallelStream().filter(entityDetail -> entityDetail.getType().getTypeDefName().equalsIgnoreCase(portTypeName)).collect(Collectors.toSet());
    }

    private void validateProcessParameters(String userId, String qualifiedName, String methodName) throws InvalidParameterException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
    }

    ProcessPropertiesBuilder getProcessPropertiesBuilder(Process process) {
        return new ProcessPropertiesBuilder(process.getQualifiedName(), process.getDisplayName(), process.getName(), process.getDescription(), "d8f33bd7-afa9-4a11-a8c7-07dcec83c050", "Process", process.getFormula(), process.getImplementationLanguage(), process.getAdditionalProperties(), this.repositoryHelper, this.serverName, this.serviceName);
    }

    public void upsertProcessHierarchyRelationship(String userId, ParentProcess parentProcess, String processGUID, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "upsertProcessHierarchyRelationship";
        ProcessContainmentType processContainmentType = parentProcess.getProcessContainmentType();
        InstanceProperties relationshipProperties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, null, "containmentType", processContainmentType.getOrdinal(), processContainmentType.getName(), processContainmentType.getDescription(), "upsertProcessHierarchyRelationship");
        Optional<EntityDetail> parentProcessEntity = this.findProcessEntity(userId, parentProcess.getQualifiedName());
        if (parentProcessEntity.isPresent()) {
            this.dataEngineCommonHandler.upsertExternalRelationship(userId, parentProcessEntity.get().getGUID(), processGUID, "ProcessHierarchy", "Process", externalSourceName, relationshipProperties);
        } else {
            this.dataEngineCommonHandler.throwInvalidParameterException(DataEngineErrorCode.PROCESS_NOT_FOUND, "upsertProcessHierarchyRelationship", parentProcess.getQualifiedName());
        }
    }

    private Map<String, Object> buildProcessExtendedProperties(Process process) {
        HashMap<String, Object> extendedProperties = new HashMap<String, Object>();
        String formula = process.getFormula();
        String implementationLanguage = process.getImplementationLanguage();
        String displayName = process.getDisplayName();
        if (formula != null) {
            extendedProperties.put("formula", formula);
        }
        if (implementationLanguage != null) {
            extendedProperties.put("implementationLanguage", implementationLanguage);
        }
        if (displayName != null) {
            extendedProperties.put("displayName", displayName);
        }
        return extendedProperties;
    }

    public void removeProcess(String userId, String processGUID, String externalSourceName, DeleteSemantic deleteSemantic) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "removeProcess";
        this.dataEngineCommonHandler.validateDeleteSemantic(deleteSemantic, "removeProcess");
        String externalSourceGUID = this.registrationHandler.getExternalDataEngine(userId, externalSourceName);
        this.assetHandler.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, processGUID, PROCESS_GUID_PARAMETER_NAME, "d8f33bd7-afa9-4a11-a8c7-07dcec83c050", "Process", null, null, "removeProcess");
    }
}

