/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.handlers;

import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineErrorCode;
import org.odpi.openmetadata.accessservices.dataengine.model.Attribute;
import org.odpi.openmetadata.accessservices.dataengine.model.Database;
import org.odpi.openmetadata.accessservices.dataengine.model.DatabaseSchema;
import org.odpi.openmetadata.accessservices.dataengine.model.DeleteSemantic;
import org.odpi.openmetadata.accessservices.dataengine.model.OwnerType;
import org.odpi.openmetadata.accessservices.dataengine.model.RelationalColumn;
import org.odpi.openmetadata.accessservices.dataengine.model.RelationalTable;
import org.odpi.openmetadata.accessservices.dataengine.model.SchemaType;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineCommonHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineConnectionAndEndpointHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineRegistrationHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.RelationalDataHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;

public class DataEngineRelationalDataHandler {
    private final String serviceName;
    private final String serverName;
    private final InvalidParameterHandler invalidParameterHandler;
    private final RelationalDataHandler<Database, DatabaseSchema, RelationalTable, RelationalTable, RelationalColumn, SchemaType> relationalDataHandler;
    private final DataEngineCommonHandler dataEngineCommonHandler;
    private final DataEngineRegistrationHandler registrationHandler;
    private final DataEngineConnectionAndEndpointHandler dataEngineConnectionAndEndpointHandler;

    public DataEngineRelationalDataHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RelationalDataHandler<Database, DatabaseSchema, RelationalTable, RelationalTable, RelationalColumn, SchemaType> relationalDataHandler, DataEngineRegistrationHandler registrationHandler, DataEngineCommonHandler dataEngineCommonHandler, DataEngineConnectionAndEndpointHandler dataEngineConnectionAndEndpointHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.relationalDataHandler = relationalDataHandler;
        this.registrationHandler = registrationHandler;
        this.dataEngineCommonHandler = dataEngineCommonHandler;
        this.dataEngineConnectionAndEndpointHandler = dataEngineConnectionAndEndpointHandler;
    }

    public String upsertDatabase(String userId, Database database, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String databaseGUID;
        String methodName = "upsertDatabase";
        this.validateParameters(userId, "upsertDatabase", database.getQualifiedName(), database.getDisplayName());
        String externalSourceGUID = this.registrationHandler.getExternalDataEngine(userId, externalSourceName);
        Optional<EntityDetail> originalDatabaseEntity = this.findDatabaseEntity(userId, database.getQualifiedName());
        int ownerTypeOrdinal = this.dataEngineCommonHandler.getOwnerTypeOrdinal(database.getOwnerType());
        if (!originalDatabaseEntity.isPresent()) {
            databaseGUID = this.relationalDataHandler.createDatabase(userId, externalSourceGUID, externalSourceName, database.getQualifiedName(), database.getDisplayName(), database.getDescription(), database.getOwner(), ownerTypeOrdinal, database.getZoneMembership(), database.getOriginOrganizationGUID(), database.getOriginBusinessCapabilityGUID(), database.getOtherOriginValues(), database.getPathName(), database.getCreateTime(), database.getModifiedTime(), database.getEncodingType(), database.getEncodingLanguage(), database.getEncodingDescription(), database.getEncodingProperties(), database.getDatabaseType(), database.getDatabaseVersion(), database.getDatabaseInstance(), database.getDatabaseImportedFrom(), database.getAdditionalProperties(), "Database", null, null, "upsertDatabase");
        } else {
            databaseGUID = originalDatabaseEntity.get().getGUID();
            this.relationalDataHandler.updateDatabase(userId, externalSourceGUID, externalSourceName, databaseGUID, database.getQualifiedName(), database.getDisplayName(), database.getDescription(), database.getOwner(), ownerTypeOrdinal, database.getZoneMembership(), database.getOriginOrganizationGUID(), database.getOriginBusinessCapabilityGUID(), database.getOtherOriginValues(), database.getCreateTime(), database.getModifiedTime(), database.getEncodingType(), database.getEncodingLanguage(), database.getEncodingDescription(), database.getEncodingProperties(), database.getDatabaseType(), database.getDatabaseVersion(), database.getDatabaseInstance(), database.getDatabaseImportedFrom(), database.getAdditionalProperties(), "Database", null, null, "upsertDatabase");
        }
        DatabaseSchema databaseSchema = database.getDatabaseSchema();
        if (databaseSchema == null) {
            databaseSchema = this.createDefaultDatabaseSchema(database.getQualifiedName());
        }
        this.addAssetProperties(databaseSchema, database.getOwner(), database.getOwnerType(), database.getZoneMembership());
        this.upsertDatabaseSchema(userId, databaseGUID, databaseSchema, externalSourceName);
        if (database.getProtocol() != null && database.getNetworkAddress() != null) {
            this.dataEngineConnectionAndEndpointHandler.upsertConnectionAndEndpoint(database.getQualifiedName(), "Database", database.getProtocol(), database.getNetworkAddress(), externalSourceGUID, externalSourceName, userId, "upsertDatabase");
        }
        return databaseGUID;
    }

    private Optional<EntityDetail> findDatabaseEntity(String userId, String qualifiedName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.dataEngineCommonHandler.findEntity(userId, qualifiedName, "Database");
    }

    private void upsertDatabaseSchema(String userId, String databaseGUID, DatabaseSchema databaseSchema, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "upsertDatabaseSchema";
        this.invalidParameterHandler.validateUserId(userId, "upsertDatabaseSchema");
        this.invalidParameterHandler.validateName(databaseSchema.getQualifiedName(), "qualifiedName", "upsertDatabaseSchema");
        String externalSourceGUID = this.registrationHandler.getExternalDataEngine(userId, externalSourceName);
        Optional<EntityDetail> originalDatabaseSchemaEntity = this.dataEngineCommonHandler.findEntity(userId, databaseSchema.getQualifiedName(), "DeployedDatabaseSchema");
        int ownerTypeOrdinal = this.dataEngineCommonHandler.getOwnerTypeOrdinal(databaseSchema.getOwnerType());
        if (!originalDatabaseSchemaEntity.isPresent()) {
            this.relationalDataHandler.createDatabaseSchema(userId, externalSourceGUID, externalSourceName, databaseGUID, databaseSchema.getQualifiedName(), databaseSchema.getDisplayName(), databaseSchema.getDescription(), databaseSchema.getOwner(), ownerTypeOrdinal, databaseSchema.getZoneMembership(), databaseSchema.getOriginOrganizationGUID(), databaseSchema.getOriginBusinessCapabilityGUID(), databaseSchema.getOtherOriginValues(), databaseSchema.getAdditionalProperties(), "DeployedDatabaseSchema", null, null, "upsertDatabaseSchema");
        } else {
            String databaseSchemaGUID = originalDatabaseSchemaEntity.get().getGUID();
            this.relationalDataHandler.updateDatabaseSchema(userId, externalSourceGUID, externalSourceName, databaseSchemaGUID, databaseSchema.getQualifiedName(), databaseSchema.getDisplayName(), databaseSchema.getDescription(), databaseSchema.getOwner(), ownerTypeOrdinal, databaseSchema.getZoneMembership(), databaseSchema.getOriginOrganizationGUID(), databaseSchema.getOriginBusinessCapabilityGUID(), databaseSchema.getOtherOriginValues(), databaseSchema.getAdditionalProperties(), "DeployedDatabaseSchema", null, null, "upsertDatabaseSchema");
        }
    }

    private Optional<EntityDetail> findSchemaForDatabase(String userId, String databaseGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataEngineCommonHandler.getEntityForRelationship(userId, databaseGUID, "DataContentForDataSet", "Database");
    }

    public String upsertRelationalTable(String userId, String databaseQualifiedName, RelationalTable relationalTable, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String relationalTableGUID;
        String methodName = "upsertRelationalTable";
        this.validateParameters(userId, "upsertRelationalTable", relationalTable.getQualifiedName(), relationalTable.getDisplayName());
        String externalSourceGUID = this.registrationHandler.getExternalDataEngine(userId, externalSourceName);
        Optional<EntityDetail> originalRelationalTableEntity = this.dataEngineCommonHandler.findEntity(userId, relationalTable.getQualifiedName(), "RelationalTable");
        if (!originalRelationalTableEntity.isPresent()) {
            Optional<EntityDetail> databaseOptional = this.findDatabaseEntity(userId, databaseQualifiedName);
            Optional<Object> databaseSchema = Optional.empty();
            if (!databaseOptional.isPresent()) {
                this.dataEngineCommonHandler.throwInvalidParameterException(DataEngineErrorCode.DATABASE_NOT_FOUND, "upsertRelationalTable", databaseQualifiedName);
            } else {
                databaseSchema = this.findSchemaForDatabase(userId, databaseOptional.get().getGUID());
                if (!databaseSchema.isPresent()) {
                    this.dataEngineCommonHandler.throwInvalidParameterException(DataEngineErrorCode.DATABASE_NOT_FOUND, "upsertRelationalTable", databaseQualifiedName);
                }
            }
            String databaseSchemaGUID = ((EntityDetail)databaseSchema.get()).getGUID();
            relationalTableGUID = this.relationalDataHandler.createDatabaseTable(userId, externalSourceGUID, externalSourceName, databaseSchemaGUID, relationalTable.getQualifiedName(), relationalTable.getDisplayName(), relationalTable.getDescription(), relationalTable.getIsDeprecated(), relationalTable.getAliases(), relationalTable.getAdditionalProperties(), "RelationalTable", null, null, "upsertRelationalTable");
        } else {
            relationalTableGUID = originalRelationalTableEntity.get().getGUID();
            this.relationalDataHandler.updateDatabaseTable(userId, externalSourceGUID, externalSourceName, relationalTableGUID, relationalTable.getQualifiedName(), relationalTable.getDisplayName(), relationalTable.getDescription(), relationalTable.getIsDeprecated(), relationalTable.getAliases(), relationalTable.getAdditionalProperties(), "RelationalTable", null, null, "upsertRelationalTable");
        }
        this.upsertRelationalColumns(userId, externalSourceGUID, externalSourceName, relationalTableGUID, relationalTable.getColumns());
        return relationalTableGUID;
    }

    private void upsertRelationalColumns(String userId, String externalSourceGUID, String externalSourceName, String relationalTableGUID, List<RelationalColumn> columns) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "upsertRelationalColumns";
        if (CollectionUtils.isEmpty(columns)) {
            return;
        }
        for (RelationalColumn column : columns) {
            int sortOrder = this.dataEngineCommonHandler.getSortOrder((Attribute)column);
            Optional<EntityDetail> originalRelationalColumnEntity = this.dataEngineCommonHandler.findEntity(userId, column.getQualifiedName(), "RelationalColumn");
            if (!originalRelationalColumnEntity.isPresent()) {
                this.relationalDataHandler.createDatabaseColumn(userId, externalSourceGUID, externalSourceName, relationalTableGUID, column.getQualifiedName(), column.getDisplayName(), column.getDescription(), column.getExternalTypeGUID(), column.getDataType(), column.getDefaultValue(), column.getFixedValue(), column.getValidValuesSetGUID(), column.getFormula(), column.getIsDeprecated(), column.getPosition(), column.getMinCardinality(), column.getMaxCardinality(), column.getAllowsDuplicateValues(), column.getOrderedValues(), column.getDefaultValueOverride(), sortOrder, column.getMinimumLength(), column.getLength(), column.getPrecision(), column.getIsNullable(), column.getNativeClass(), column.getAliases(), column.getAdditionalProperties(), "RelationalColumn", null, null, "upsertRelationalColumns");
                continue;
            }
            this.relationalDataHandler.updateDatabaseColumn(userId, externalSourceGUID, externalSourceName, originalRelationalColumnEntity.get().getGUID(), column.getQualifiedName(), column.getDisplayName(), column.getDescription(), column.getDataType(), column.getDefaultValue(), column.getFixedValue(), column.getFormula(), column.getIsDeprecated(), column.getPosition(), column.getMinCardinality(), column.getMaxCardinality(), column.getAllowsDuplicateValues(), column.getOrderedValues(), column.getDefaultValueOverride(), sortOrder, column.getMinimumLength(), column.getLength(), column.getPrecision(), column.getIsNullable(), column.getNativeClass(), column.getAliases(), column.getAdditionalProperties(), "RelationalColumn", null, null, "upsertRelationalColumns");
        }
    }

    private void addAssetProperties(DatabaseSchema databaseSchema, String owner, OwnerType ownerType, List<String> zoneMembership) {
        databaseSchema.setOwner(owner);
        databaseSchema.setOwnerType(ownerType);
        databaseSchema.setZoneMembership(zoneMembership);
    }

    private DatabaseSchema createDefaultDatabaseSchema(String databaseQualifiedName) {
        String postfix = ":schema";
        DatabaseSchema databaseSchema = new DatabaseSchema();
        databaseSchema.setQualifiedName(databaseQualifiedName + postfix);
        return databaseSchema;
    }

    private void validateParameters(String userId, String methodName, String qualifiedName, String displayName) throws InvalidParameterException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.validateName(displayName, "displayName", methodName);
    }

    public void removeDatabase(String userId, String databaseGUID, String externalSourceName, DeleteSemantic deleteSemantic) throws FunctionNotSupportedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeDatabase";
        this.dataEngineCommonHandler.validateDeleteSemantic(deleteSemantic, "removeDatabase");
        this.invalidParameterHandler.validateUserId(userId, "removeDatabase");
        this.invalidParameterHandler.validateGUID(databaseGUID, "qualifiedName", "removeDatabase");
        Optional<EntityDetail> databaseOptional = this.dataEngineCommonHandler.getEntityDetails(userId, databaseGUID, "Database");
        if (databaseOptional.isPresent()) {
            EntityDetail databaseEntity = databaseOptional.get();
            String databaseQualifiedName = databaseEntity.getProperties().getPropertyValue("qualifiedName").valueAsString();
            Optional<EntityDetail> databaseSchemaOptional = this.findSchemaForDatabase(userId, databaseEntity.getGUID());
            if (databaseSchemaOptional.isPresent()) {
                String externalSourceGUID = this.registrationHandler.getExternalDataEngine(userId, externalSourceName);
                this.removeDatabaseSchema(userId, databaseSchemaOptional.get(), externalSourceName, externalSourceGUID);
                this.relationalDataHandler.removeDatabase(userId, externalSourceGUID, externalSourceName, databaseGUID, databaseQualifiedName, "removeDatabase");
            } else {
                this.dataEngineCommonHandler.throwInvalidParameterException(DataEngineErrorCode.ENTITY_NOT_DELETED, "removeDatabase", databaseGUID);
            }
        } else {
            this.dataEngineCommonHandler.throwInvalidParameterException(DataEngineErrorCode.ENTITY_NOT_DELETED, "removeDatabase", databaseGUID);
        }
    }

    public void removeRelationalTable(String userId, String relationalTableGUID, String externalSourceName, DeleteSemantic deleteSemantic) throws FunctionNotSupportedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeRelationalTable";
        this.dataEngineCommonHandler.validateDeleteSemantic(deleteSemantic, "removeRelationalTable");
        this.invalidParameterHandler.validateUserId(userId, "removeRelationalTable");
        this.invalidParameterHandler.validateGUID(relationalTableGUID, "qualifiedName", "removeRelationalTable");
        Optional<EntityDetail> tableEntity = this.dataEngineCommonHandler.getEntityDetails(userId, relationalTableGUID, "RelationalTable");
        if (!tableEntity.isPresent()) {
            this.dataEngineCommonHandler.throwInvalidParameterException(DataEngineErrorCode.ENTITY_NOT_DELETED, "removeRelationalTable", relationalTableGUID);
        }
        String tableQualifiedName = tableEntity.get().getProperties().getPropertyValue("qualifiedName").valueAsString();
        String externalSourceGUID = this.registrationHandler.getExternalDataEngine(userId, externalSourceName);
        this.relationalDataHandler.removeDatabaseTable(userId, externalSourceGUID, externalSourceName, relationalTableGUID, "guid", tableQualifiedName, "removeRelationalTable");
    }

    private void removeDatabaseSchema(String userId, EntityDetail databaseSchema, String externalSourceName, String externalSourceGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeDatabaseSchema";
        String databaseSchemaGUID = databaseSchema.getGUID();
        this.relationalDataHandler.removeDatabaseSchema(userId, externalSourceGUID, externalSourceName, databaseSchemaGUID, databaseSchema.getProperties().getPropertyValue("qualifiedName").valueAsString(), "removeDatabaseSchema");
    }
}

