/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.processors;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.odpi.openmetadata.accessservices.dataengine.event.DataEngineRegistrationEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.DataFileEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.DatabaseEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.DeleteEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.LineageMappingsEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.PortAliasEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.PortImplementationEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.ProcessEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.ProcessHierarchyEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.RelationalTableEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.SchemaTypeEvent;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineAuditCode;
import org.odpi.openmetadata.accessservices.dataengine.model.PortImplementation;
import org.odpi.openmetadata.accessservices.dataengine.server.admin.DataEngineServicesInstance;
import org.odpi.openmetadata.accessservices.dataengine.server.service.DataEngineRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataEngineEventProcessor {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger log = LoggerFactory.getLogger(DataEngineEventProcessor.class);
    private static final String DEBUG_MESSAGE_METHOD = "Calling method: {}";
    private final AuditLog auditLog;
    private final String serverName;
    private DataEngineRESTServices dataEngineRESTServices = new DataEngineRESTServices();

    public DataEngineEventProcessor(DataEngineServicesInstance instance, AuditLog auditLog) throws NewInstanceException {
        this.auditLog = auditLog;
        this.serverName = instance.getServerName();
    }

    public void processDataEngineRegistrationEvent(String dataEngineEvent) {
        String methodName = "processDataEngineRegistrationEvent";
        log.trace(DEBUG_MESSAGE_METHOD, (Object)"processDataEngineRegistrationEvent");
        try {
            DataEngineRegistrationEvent dataEngineRegistrationEvent = (DataEngineRegistrationEvent)OBJECT_MAPPER.readValue(dataEngineEvent, DataEngineRegistrationEvent.class);
            this.dataEngineRESTServices.createExternalDataEngine(dataEngineRegistrationEvent.getUserId(), this.serverName, dataEngineRegistrationEvent.getSoftwareServerCapability());
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            this.logException(dataEngineEvent, "processDataEngineRegistrationEvent", (Exception)e);
        }
    }

    public void processPortAliasEvent(String dataEngineEvent) {
        String methodName = "processPortAliasEvent";
        log.trace(DEBUG_MESSAGE_METHOD, (Object)"processPortAliasEvent");
        try {
            PortAliasEvent portAliasEvent = (PortAliasEvent)OBJECT_MAPPER.readValue(dataEngineEvent, PortAliasEvent.class);
            String userId = portAliasEvent.getUserId();
            String externalSourceName = portAliasEvent.getExternalSourceName();
            String processGUID = this.dataEngineRESTServices.getEntityGUID(this.serverName, userId, portAliasEvent.getProcessQualifiedName(), "Process").orElse(null);
            this.dataEngineRESTServices.updateProcessStatus(userId, this.serverName, processGUID, InstanceStatus.DRAFT, externalSourceName);
            this.dataEngineRESTServices.upsertPortAliasWithDelegation(userId, this.serverName, portAliasEvent.getPortAlias(), processGUID, externalSourceName);
            this.dataEngineRESTServices.updateProcessStatus(userId, this.serverName, processGUID, InstanceStatus.ACTIVE, externalSourceName);
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            this.logException(dataEngineEvent, "processPortAliasEvent", (Exception)e);
        }
    }

    public void processProcessHierarchyEvent(String dataEngineEvent) {
        String methodName = "processProcessHierarchyEvent";
        log.trace(DEBUG_MESSAGE_METHOD, (Object)"processProcessHierarchyEvent");
        try {
            ProcessHierarchyEvent processHierarchyEvent = (ProcessHierarchyEvent)OBJECT_MAPPER.readValue(dataEngineEvent, ProcessHierarchyEvent.class);
            this.dataEngineRESTServices.addProcessHierarchyToProcess(processHierarchyEvent.getUserId(), this.serverName, processHierarchyEvent.getProcessHierarchy(), processHierarchyEvent.getExternalSourceName());
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            this.logException(dataEngineEvent, "processProcessHierarchyEvent", (Exception)e);
        }
    }

    public void processPortImplementationEvent(String dataEngineEvent) {
        String methodName = "processPortImplementationEvent";
        log.trace(DEBUG_MESSAGE_METHOD, (Object)"processPortImplementationEvent");
        try {
            PortImplementationEvent portImplementationEvent = (PortImplementationEvent)OBJECT_MAPPER.readValue(dataEngineEvent, PortImplementationEvent.class);
            String externalSourceName = portImplementationEvent.getExternalSourceName();
            String userId = portImplementationEvent.getUserId();
            PortImplementation portImplementation = portImplementationEvent.getPortImplementation();
            String processGUID = this.dataEngineRESTServices.getEntityGUID(this.serverName, userId, portImplementationEvent.getProcessQualifiedName(), "Process").orElse(null);
            this.dataEngineRESTServices.updateProcessStatus(userId, this.serverName, processGUID, InstanceStatus.DRAFT, externalSourceName);
            String portImplementationGUID = this.dataEngineRESTServices.upsertPortImplementation(userId, this.serverName, portImplementation, processGUID, externalSourceName);
            this.dataEngineRESTServices.upsertSchemaType(userId, this.serverName, portImplementationGUID, portImplementation.getSchemaType(), externalSourceName);
            this.dataEngineRESTServices.updateProcessStatus(userId, this.serverName, processGUID, InstanceStatus.ACTIVE, externalSourceName);
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException | FunctionNotSupportedException e) {
            this.logException(dataEngineEvent, "processPortImplementationEvent", (Exception)e);
        }
    }

    public void processLineageMappingsEvent(String dataEngineEvent) {
        String methodName = "processLineageMappingsEvent";
        log.trace(DEBUG_MESSAGE_METHOD, (Object)"processLineageMappingsEvent");
        try {
            LineageMappingsEvent lineageMappingsEvent = (LineageMappingsEvent)OBJECT_MAPPER.readValue(dataEngineEvent, LineageMappingsEvent.class);
            if (CollectionUtils.isEmpty((Collection)lineageMappingsEvent.getLineageMappings())) {
                return;
            }
            FFDCResponseBase response = new FFDCResponseBase();
            this.dataEngineRESTServices.addLineageMappings(lineageMappingsEvent.getUserId(), this.serverName, lineageMappingsEvent.getLineageMappings(), response, lineageMappingsEvent.getExternalSourceName());
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            this.logException(dataEngineEvent, "processLineageMappingsEvent", (Exception)e);
        }
    }

    public void processProcessEvent(String dataEngineEvent) {
        String methodName = "processProcessEvent";
        log.trace(DEBUG_MESSAGE_METHOD, (Object)"processProcessEvent");
        try {
            ProcessEvent processesEvent = (ProcessEvent)OBJECT_MAPPER.readValue(dataEngineEvent, ProcessEvent.class);
            this.dataEngineRESTServices.upsertProcess(processesEvent.getUserId(), this.serverName, processesEvent.getProcess(), processesEvent.getExternalSourceName());
        }
        catch (JsonProcessingException e) {
            log.debug("Exception in parsing event from in Data Engine In Topic", (Throwable)e);
            this.logException(dataEngineEvent, "processProcessEvent", (Exception)((Object)e));
        }
    }

    public void processSchemaTypeEvent(String schemaTypeEvent) {
        String methodName = "processSchemaTypeEvent";
        log.trace(DEBUG_MESSAGE_METHOD, (Object)"processSchemaTypeEvent");
        try {
            SchemaTypeEvent schemaEvent = (SchemaTypeEvent)OBJECT_MAPPER.readValue(schemaTypeEvent, SchemaTypeEvent.class);
            String portGUID = null;
            if (StringUtils.isNotEmpty((CharSequence)schemaEvent.getPortQualifiedName())) {
                portGUID = this.dataEngineRESTServices.getEntityGUID(this.serverName, schemaEvent.getUserId(), schemaEvent.getPortQualifiedName(), "Port").orElse(null);
            }
            this.dataEngineRESTServices.upsertSchemaType(schemaEvent.getUserId(), this.serverName, portGUID, schemaEvent.getSchemaType(), schemaEvent.getExternalSourceName());
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            this.logException(schemaTypeEvent, "processSchemaTypeEvent", (Exception)e);
        }
    }

    public void processDeleteSchemaTypeEvent(String dataEngineEvent) {
        String methodName = "processDeleteSchemaTypeEvent";
        log.trace(DEBUG_MESSAGE_METHOD, (Object)"processDeleteSchemaTypeEvent");
        try {
            DeleteEvent deleteEvent = (DeleteEvent)OBJECT_MAPPER.readValue(dataEngineEvent, DeleteEvent.class);
            this.dataEngineRESTServices.deleteSchemaType(deleteEvent.getUserId(), this.serverName, deleteEvent.getExternalSourceName(), deleteEvent.getGuid(), deleteEvent.getQualifiedName(), deleteEvent.getDeleteSemantic());
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException | EntityNotDeletedException | FunctionNotSupportedException e) {
            this.logException(dataEngineEvent, "processDeleteSchemaTypeEvent", (Exception)e);
        }
    }

    public void processDeleteDataEngineEvent(String dataEngineEvent) {
        String methodName = "processDeleteDataEngineEvent";
        log.trace(DEBUG_MESSAGE_METHOD, (Object)"processDeleteDataEngineEvent");
        try {
            DeleteEvent deleteEvent = (DeleteEvent)OBJECT_MAPPER.readValue(dataEngineEvent, DeleteEvent.class);
            this.dataEngineRESTServices.deleteExternalDataEngine(deleteEvent.getUserId(), this.serverName, deleteEvent.getExternalSourceName(), deleteEvent.getGuid(), deleteEvent.getQualifiedName(), deleteEvent.getDeleteSemantic());
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException | FunctionNotSupportedException e) {
            this.logException(dataEngineEvent, "processDeleteDataEngineEvent", (Exception)e);
        }
    }

    public void processDeleteProcessEvent(String dataEngineEvent) {
        String methodName = "processDeleteProcessEvent";
        log.trace(DEBUG_MESSAGE_METHOD, (Object)"processDeleteProcessEvent");
        try {
            DeleteEvent deleteEvent = (DeleteEvent)OBJECT_MAPPER.readValue(dataEngineEvent, DeleteEvent.class);
            this.dataEngineRESTServices.deleteProcess(deleteEvent.getUserId(), this.serverName, deleteEvent.getExternalSourceName(), deleteEvent.getGuid(), deleteEvent.getQualifiedName(), deleteEvent.getDeleteSemantic());
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException | EntityNotDeletedException | FunctionNotSupportedException e) {
            this.logException(dataEngineEvent, "processDeleteProcessEvent", (Exception)e);
        }
    }

    public void processDeletePortImplementationEvent(String dataEngineEvent) {
        String methodName = "processDeletePortImplementationEvent";
        this.deletePort(dataEngineEvent, "processDeletePortImplementationEvent", "PortImplementation");
    }

    public void processDeletePortAliasEvent(String dataEngineEvent) {
        String methodName = "processDeletePortAliasEvent";
        this.deletePort(dataEngineEvent, "processDeletePortAliasEvent", "PortAlias");
    }

    public void processDatabaseEvent(String dataEngineEvent) {
        String methodName = "processDatabaseEvent";
        log.trace(DEBUG_MESSAGE_METHOD, (Object)"processDatabaseEvent");
        try {
            DatabaseEvent databaseEvent = (DatabaseEvent)OBJECT_MAPPER.readValue(dataEngineEvent, DatabaseEvent.class);
            this.dataEngineRESTServices.upsertDatabase(databaseEvent.getUserId(), this.serverName, databaseEvent.getDatabase(), databaseEvent.getExternalSourceName());
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            this.logException(dataEngineEvent, "processDatabaseEvent", (Exception)e);
        }
    }

    public void processRelationalTableEvent(String dataEngineEvent) {
        String methodName = "processRelationalTableEvent";
        log.trace(DEBUG_MESSAGE_METHOD, (Object)"processRelationalTableEvent");
        try {
            RelationalTableEvent relationalTableEvent = (RelationalTableEvent)OBJECT_MAPPER.readValue(dataEngineEvent, RelationalTableEvent.class);
            this.dataEngineRESTServices.upsertRelationalTable(relationalTableEvent.getUserId(), this.serverName, relationalTableEvent.getDatabaseQualifiedName(), relationalTableEvent.getRelationalTable(), relationalTableEvent.getExternalSourceName());
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            this.logException(dataEngineEvent, "processRelationalTableEvent", (Exception)e);
        }
    }

    public void processDataFileEvent(String dataEngineEvent) {
        String methodName = "processDataFileEvent";
        log.trace(DEBUG_MESSAGE_METHOD, (Object)"processDataFileEvent");
        try {
            DataFileEvent dataFileEvent = (DataFileEvent)OBJECT_MAPPER.readValue(dataEngineEvent, DataFileEvent.class);
            this.dataEngineRESTServices.upsertDataFile(dataFileEvent.getUserId(), this.serverName, dataFileEvent.getDataFile(), dataFileEvent.getExternalSourceName());
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            this.logException(dataEngineEvent, "processDataFileEvent", (Exception)e);
        }
    }

    public void processDeleteDatabaseEvent(String dataEngineEvent) {
        String methodName = "processDeleteDatabaseEvent";
        log.trace(DEBUG_MESSAGE_METHOD, (Object)"processDeleteDatabaseEvent");
        try {
            DeleteEvent deleteEvent = (DeleteEvent)OBJECT_MAPPER.readValue(dataEngineEvent, DeleteEvent.class);
            this.dataEngineRESTServices.deleteDatabase(deleteEvent.getUserId(), this.serverName, deleteEvent.getExternalSourceName(), deleteEvent.getGuid(), deleteEvent.getQualifiedName(), deleteEvent.getDeleteSemantic());
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException | EntityNotDeletedException | FunctionNotSupportedException e) {
            this.logException(dataEngineEvent, "processDeleteDatabaseEvent", (Exception)e);
        }
    }

    public void processDeleteRelationalTableEvent(String dataEngineEvent) {
        String methodName = "processDeleteRelationalTableEvent";
        log.trace(DEBUG_MESSAGE_METHOD, (Object)"processDeleteRelationalTableEvent");
        try {
            DeleteEvent deleteEvent = (DeleteEvent)OBJECT_MAPPER.readValue(dataEngineEvent, DeleteEvent.class);
            this.dataEngineRESTServices.deleteRelationalTable(deleteEvent.getUserId(), this.serverName, deleteEvent.getExternalSourceName(), deleteEvent.getGuid(), deleteEvent.getQualifiedName(), deleteEvent.getDeleteSemantic());
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException | EntityNotDeletedException | FunctionNotSupportedException e) {
            this.logException(dataEngineEvent, "processDeleteRelationalTableEvent", (Exception)e);
        }
    }

    public void processDeleteDataFileEvent(String dataEngineEvent) {
        String methodName = "processDeleteDataFileEvent";
        log.trace(DEBUG_MESSAGE_METHOD, (Object)"processDeleteDataFileEvent");
        try {
            DeleteEvent deleteEvent = (DeleteEvent)OBJECT_MAPPER.readValue(dataEngineEvent, DeleteEvent.class);
            this.dataEngineRESTServices.deleteDataFile(deleteEvent.getUserId(), this.serverName, deleteEvent.getExternalSourceName(), deleteEvent.getGuid(), deleteEvent.getQualifiedName(), deleteEvent.getDeleteSemantic());
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException | EntityNotDeletedException | FunctionNotSupportedException e) {
            this.logException(dataEngineEvent, "processDeleteDataFileEvent", (Exception)e);
        }
    }

    public void processDeleteFolderEvent(String dataEngineEvent) {
        String methodName = "processDeleteFolderEvent";
        log.trace(DEBUG_MESSAGE_METHOD, (Object)"processDeleteFolderEvent");
        try {
            DeleteEvent deleteEvent = (DeleteEvent)OBJECT_MAPPER.readValue(dataEngineEvent, DeleteEvent.class);
            this.dataEngineRESTServices.deleteFolder(deleteEvent.getUserId(), this.serverName, deleteEvent.getExternalSourceName(), deleteEvent.getGuid(), deleteEvent.getQualifiedName(), deleteEvent.getDeleteSemantic());
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException | EntityNotDeletedException | FunctionNotSupportedException e) {
            this.logException(dataEngineEvent, "processDeleteFolderEvent", (Exception)e);
        }
    }

    public void processDeleteConnectionEvent(String dataEngineEvent) {
        String methodName = "processDeleteConnectionEvent";
        log.trace(DEBUG_MESSAGE_METHOD, (Object)"processDeleteConnectionEvent");
        try {
            DeleteEvent deleteEvent = (DeleteEvent)OBJECT_MAPPER.readValue(dataEngineEvent, DeleteEvent.class);
            this.dataEngineRESTServices.deleteConnection(deleteEvent.getUserId(), this.serverName, deleteEvent.getExternalSourceName(), deleteEvent.getGuid(), deleteEvent.getQualifiedName(), deleteEvent.getDeleteSemantic());
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException | EntityNotDeletedException | FunctionNotSupportedException e) {
            this.logException(dataEngineEvent, "processDeleteConnectionEvent", (Exception)e);
        }
    }

    public void processDeleteEndpointEvent(String dataEngineEvent) {
        String methodName = "processDeleteEndpointEvent";
        log.trace(DEBUG_MESSAGE_METHOD, (Object)"processDeleteEndpointEvent");
        try {
            DeleteEvent deleteEvent = (DeleteEvent)OBJECT_MAPPER.readValue(dataEngineEvent, DeleteEvent.class);
            this.dataEngineRESTServices.deleteEndpoint(deleteEvent.getUserId(), this.serverName, deleteEvent.getExternalSourceName(), deleteEvent.getGuid(), deleteEvent.getQualifiedName(), deleteEvent.getDeleteSemantic());
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException | EntityNotDeletedException | FunctionNotSupportedException e) {
            this.logException(dataEngineEvent, "processDeleteEndpointEvent", (Exception)e);
        }
    }

    private void deletePort(String dataEngineEvent, String methodName, String portType) {
        log.trace(DEBUG_MESSAGE_METHOD, (Object)methodName);
        try {
            DeleteEvent deleteEvent = (DeleteEvent)OBJECT_MAPPER.readValue(dataEngineEvent, DeleteEvent.class);
            this.dataEngineRESTServices.deletePort(deleteEvent.getUserId(), this.serverName, deleteEvent.getExternalSourceName(), deleteEvent.getGuid(), deleteEvent.getQualifiedName(), portType, deleteEvent.getDeleteSemantic());
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException | EntityNotDeletedException | FunctionNotSupportedException e) {
            this.logException(dataEngineEvent, methodName, (Exception)e);
        }
    }

    private void logException(String dataEngineEvent, String methodName, Exception e) {
        log.debug("Exception in processing {} from in Data Engine In Topic: {}", (Object)dataEngineEvent, (Object)e);
        this.auditLog.logException(methodName, DataEngineAuditCode.PARSE_EVENT_EXCEPTION.getMessageDefinition(new String[]{dataEngineEvent, e.toString()}), (Throwable)e);
    }
}

