/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.builders;

import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ExternalDataEnginePropertiesBuilder
extends ReferenceableBuilder {
    private final String name;
    private final String description;
    private final String deployedImplementationType;
    private final String capabilityVersion;
    private final String source;
    private final String patchLevel;

    public ExternalDataEnginePropertiesBuilder(String qualifiedName, String name, String description, String deployedImplementationType, String capabilityVersion, String patchLevel, String source, Map<String, String> additionalProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, repositoryHelper, serviceName, serverName);
        this.name = name;
        this.description = description;
        this.deployedImplementationType = deployedImplementationType;
        this.capabilityVersion = capabilityVersion;
        this.patchLevel = patchLevel;
        this.source = source;
    }

    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.name != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "name", this.name, methodName);
        }
        if (this.description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", this.description, methodName);
        }
        if (this.deployedImplementationType != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "deployedImplementationType", this.deployedImplementationType, methodName);
        }
        if (this.capabilityVersion != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "capabilityVersion", this.capabilityVersion, methodName);
        }
        if (this.patchLevel != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "patchLevel", this.patchLevel, methodName);
        }
        if (this.source != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "source", this.source, methodName);
        }
        if (MapUtils.isNotEmpty((Map)this.additionalProperties)) {
            properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, "additionalProperties", this.additionalProperties, methodName);
        }
        return properties;
    }

    public InstanceProperties getNameInstanceProperties(String methodName) {
        InstanceProperties properties = super.getNameInstanceProperties(methodName);
        if (this.name != null) {
            String literalName = this.repositoryHelper.getExactMatchRegex(this.name);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "name", literalName, methodName);
        }
        return properties;
    }
}

