/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.accessservices.dataengine.model.ConnectorType;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ConnectorTypeConverter<B>
extends OpenMetadataAPIGenericConverter<B> {
    public ConnectorTypeConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ConnectorType) {
                ConnectorType bean = (ConnectorType)returnBean;
                if (entity != null) {
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    bean.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    bean.setDisplayName(this.removeDisplayName(instanceProperties));
                    bean.setDescription(this.removeDescription(instanceProperties));
                    bean.setSupportedAssetTypeName(this.removeSupportedAssetTypeName(instanceProperties));
                    bean.setExpectedDataFormat(this.removeExpectedDataFormat(instanceProperties));
                    bean.setConnectorProviderClassName(this.removeConnectorProviderClassName(instanceProperties));
                    bean.setConnectorFrameworkName(this.removeConnectorFrameworkName(instanceProperties));
                    bean.setConnectorInterfaceLanguage(this.removeConnectorInterfaceLanguage(instanceProperties));
                    bean.setConnectorInterfaces(this.removeConnectorInterfaces(instanceProperties));
                    bean.setTargetTechnologySource(this.removeTargetTechnologySource(instanceProperties));
                    bean.setTargetTechnologyName(this.removeTargetTechnologyName(instanceProperties));
                    bean.setTargetTechnologyInterfaces(this.removeTargetTechnologyInterfaces(instanceProperties));
                    bean.setTargetTechnologyVersions(this.removeTargetTechnologyVersions(instanceProperties));
                    bean.setRecognizedAdditionalProperties(this.removeRecognizedAdditionalProperties(instanceProperties));
                    bean.setRecognizedSecuredProperties(this.removeRecognizedSecuredProperties(instanceProperties));
                    bean.setRecognizedConfigurationProperties(this.removeRecognizedConfigurationProperties(instanceProperties));
                    bean.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    bean.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }
}

