/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.handlers;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.dataengine.model.Connection;
import org.odpi.openmetadata.accessservices.dataengine.model.ConnectorType;
import org.odpi.openmetadata.accessservices.dataengine.model.DeleteSemantic;
import org.odpi.openmetadata.accessservices.dataengine.model.Endpoint;
import org.odpi.openmetadata.accessservices.dataengine.server.builders.EndpointBuilder;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineCommonHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectorTypeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.EndpointHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataEngineConnectionAndEndpointHandler {
    private static final Logger log = LoggerFactory.getLogger(DataEngineConnectionAndEndpointHandler.class);
    private static final int START_FROM = 0;
    private static final int PAGE_SIZE = 10;
    private static final String SEARCH_STRING_PARAMETER_NAME = "searchString";
    private static final String OCF = "Open Connector Framework (OCF)";
    private static final String COLON = ":";
    private static final String CONNECTION = " Connection";
    private static final String ENDPOINT = " Endpoint";
    private static final String CONNECTOR_TYPE = " ConnectorType";
    private static final String ASSET_GUID = "assetGUID";
    private static final String QUALIFIED_NAME = "qualifiedName";
    private static final String TYPE_NAME = "typeName";
    private static final String EXTERNAL_SOURCE_GUID = "externalSourceGuid";
    private static final String EXTERNAL_SOURCE_NAME = "externalSourceName";
    private static final String NETWORK_ADDRESS = "networkAddress";
    private static final String CONNECTOR_TYPE_GUID_PARAMETER_NAME = "connectorTypeGUID";
    private static final String ENDPOINT_GUID_PARAMETER_NAME = "endpointGUID";
    private static final String CONNECTION_CREATED = "A new Connection for asset [{}] was created. Connection qualified name is [{}] and GUID is [{}]. The Connection has relationships to an Endpoint [{}] and a ConnectorType [{}].";
    private static final String ENDPOINT_UPDATED = "The existing Endpoint for asset [{}] was updated. Endpoint qualified name is [{}].";
    private static final String ASSET_NOT_FOUND = "[{}] asset could not be found. Connection and Endpoint creation is aborted.";
    private static final String PROPER_CONNECTOR_TYPE_NOT_FOUND = "A proper ConnectorType for the asset type name [{}] could not be found. Connection and Endpoint creation is aborted for asset [{}].";
    private static final String PROPER_CONNECTOR_TYPE_FOUND = "A proper ConnectorType for the asset type name [{}] was found: [{}].";
    private static final String EXISTING_ENDPOINT_NOT_FOUND = "Existing Endpoint [{}] for asset [{}] was not found and could not be updated.";
    private static final String ACCESS_INFORMATION = "Access information to connect to the actual asset: ";
    public static final String CONNECTION_GUID_PARAMETER_NAME = "connectionGUID";
    private final InvalidParameterHandler invalidParameterHandler;
    private final OMRSRepositoryHelper repositoryHelper;
    private final String serviceName;
    private final String serverName;
    private final DataEngineCommonHandler dataEngineCommonHandler;
    private final ConnectionHandler<Connection> connectionHandler;
    private final EndpointHandler<Endpoint> endpointHandler;
    private final ConnectorTypeHandler<ConnectorType> connectorTypeHandler;

    public DataEngineConnectionAndEndpointHandler(InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName, DataEngineCommonHandler dataEngineCommonHandler, ConnectionHandler<Connection> connectionHandler, EndpointHandler<Endpoint> endpointHandler, ConnectorTypeHandler<ConnectorType> connectorTypeHandler) {
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.dataEngineCommonHandler = dataEngineCommonHandler;
        this.connectionHandler = connectionHandler;
        this.endpointHandler = endpointHandler;
        this.connectorTypeHandler = connectorTypeHandler;
    }

    public void upsertConnectionAndEndpoint(String assetQualifiedName, String assetGUID, String assetTypeName, String protocol, String networkAddress, String externalSourceGUID, String externalSourceName, String userID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "upsertConnectionAndEndpoint";
        this.validateParameters(assetQualifiedName, assetTypeName, networkAddress, externalSourceGUID, externalSourceName, userID, "upsertConnectionAndEndpoint");
        Optional<EntityDetail> existingAsset = this.dataEngineCommonHandler.findEntity(userID, assetQualifiedName, assetTypeName);
        if (existingAsset.isEmpty()) {
            log.debug(ASSET_NOT_FOUND, (Object)assetQualifiedName);
            return;
        }
        Optional<ConnectorType> optionalConnectorType = this.getProperConnectorType(assetTypeName, userID);
        if (optionalConnectorType.isEmpty()) {
            log.debug(PROPER_CONNECTOR_TYPE_NOT_FOUND, (Object)assetTypeName, (Object)assetQualifiedName);
            return;
        }
        ConnectorType connectorType = optionalConnectorType.get();
        log.debug(PROPER_CONNECTOR_TYPE_FOUND, (Object)assetTypeName, (Object)connectorType.getQualifiedName());
        String connectionQualifiedName = this.getConnectionQualifiedName(assetTypeName, assetQualifiedName);
        Optional<EntityDetail> existingConnection = this.dataEngineCommonHandler.findEntity(userID, connectionQualifiedName, "Connection");
        if (existingConnection.isEmpty()) {
            this.createConnectionAndRelatedEntities(assetQualifiedName, assetGUID, assetTypeName, protocol, networkAddress, externalSourceGUID, externalSourceName, userID, "upsertConnectionAndEndpoint", connectorType, connectionQualifiedName);
        } else {
            this.updateEndpoint(protocol, networkAddress, assetTypeName, assetQualifiedName, externalSourceGUID, externalSourceName, userID);
        }
    }

    private void createConnectionAndRelatedEntities(String assetQualifiedName, String assetGUID, String assetTypeName, String protocol, String networkAddress, String externalSourceGUID, String externalSourceName, String userID, String methodName, ConnectorType connectorType, String connectionQualifiedName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String connectorProviderClassName = connectorType.getClass().getSimpleName();
        String connectorTypeQualifiedName = this.getConnectorTypeQualifiedName(assetTypeName, assetQualifiedName);
        String connectorTypeGUID = this.connectorTypeHandler.getConnectorTypeForConnection(userID, externalSourceGUID, externalSourceName, null, connectorTypeQualifiedName, connectorTypeQualifiedName, null, assetTypeName, null, connectorProviderClassName, OCF, "Java", null, null, null, null, null, null, null, null, null, methodName);
        String endpointQualifiedName = this.getEndpointQualifiedName(assetTypeName, assetQualifiedName);
        String endpointGUID = this.endpointHandler.createEndpoint(userID, externalSourceGUID, externalSourceName, null, endpointQualifiedName, endpointQualifiedName, ACCESS_INFORMATION + networkAddress, networkAddress, protocol, null, null, null, null, methodName);
        String connectionGUID = this.connectionHandler.createConnection(userID, externalSourceGUID, externalSourceName, assetGUID, ASSET_GUID, null, connectionQualifiedName, connectionQualifiedName, null, null, null, null, null, null, null, "Connection", null, connectorTypeGUID, CONNECTOR_TYPE_GUID_PARAMETER_NAME, endpointGUID, ENDPOINT_GUID_PARAMETER_NAME, null, null, methodName);
        log.debug(CONNECTION_CREATED, new Object[]{assetQualifiedName, connectionQualifiedName, connectionGUID, endpointGUID, connectorTypeGUID});
    }

    private String getConnectorTypeQualifiedName(String assetTypeName, String assetQualifiedName) {
        return assetTypeName + COLON + assetQualifiedName + CONNECTOR_TYPE;
    }

    private String getConnectionQualifiedName(String assetTypeName, String assetQualifiedName) {
        return assetTypeName + COLON + assetQualifiedName + CONNECTION;
    }

    private Optional<ConnectorType> getProperConnectorType(String assetTypeName, String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProperConnectorType";
        List connectorTypes = this.connectorTypeHandler.findConnectorTypes(userId, assetTypeName, SEARCH_STRING_PARAMETER_NAME, 0, 10, "getProperConnectorType");
        if (CollectionUtils.isEmpty((Collection)connectorTypes)) {
            return Optional.empty();
        }
        return connectorTypes.stream().filter(connectorType -> OCF.equals(connectorType.getConnectorFrameworkName())).findAny();
    }

    public void removeConnection(String userId, String connectionGUID, DeleteSemantic deleteSemantic, String externalSourceName, String externalSourceGUID) throws FunctionNotSupportedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeConnection";
        this.dataEngineCommonHandler.validateDeleteSemantic(deleteSemantic, "removeConnection");
        this.invalidParameterHandler.validateUserId(userId, "removeConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "guid", "removeConnection");
        this.connectionHandler.removeConnection(userId, externalSourceGUID, externalSourceName, connectionGUID, CONNECTION_GUID_PARAMETER_NAME, "removeConnection");
    }

    public void removeEndpoint(String userId, String endpointGUID, DeleteSemantic deleteSemantic, String externalSourceName, String externalSourceGUID) throws FunctionNotSupportedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeEndpoint";
        this.dataEngineCommonHandler.validateDeleteSemantic(deleteSemantic, "removeEndpoint");
        this.invalidParameterHandler.validateUserId(userId, "removeEndpoint");
        this.invalidParameterHandler.validateGUID(endpointGUID, "guid", "removeEndpoint");
        this.endpointHandler.removeEndpoint(userId, externalSourceGUID, externalSourceName, endpointGUID, ENDPOINT_GUID_PARAMETER_NAME, "removeEndpoint");
    }

    private void updateEndpoint(String protocol, String networkAddress, String assetTypeName, String assetQualifiedName, String externalSourceGUID, String externalSourceName, String userID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateEndpoint";
        String endpointQualifiedName = this.getEndpointQualifiedName(assetTypeName, assetQualifiedName);
        Optional<EntityDetail> existingEndpoint = this.dataEngineCommonHandler.findEntity(userID, endpointQualifiedName, "Endpoint");
        if (existingEndpoint.isEmpty()) {
            log.debug(EXISTING_ENDPOINT_NOT_FOUND, (Object)endpointQualifiedName, (Object)assetQualifiedName);
            return;
        }
        String endpointGUID = existingEndpoint.get().getGUID();
        String description = ACCESS_INFORMATION + networkAddress;
        this.endpointHandler.updateEndpoint(userID, externalSourceGUID, externalSourceName, endpointGUID, ENDPOINT_GUID_PARAMETER_NAME, endpointQualifiedName, endpointQualifiedName, description, networkAddress, protocol, null, null, null, null, false, null, null, "updateEndpoint");
        log.debug(ENDPOINT_UPDATED, (Object)assetQualifiedName, (Object)endpointQualifiedName);
    }

    private String getEndpointQualifiedName(String assetTypeName, String assetQualifiedName) {
        return assetTypeName + COLON + assetQualifiedName + ENDPOINT;
    }

    EndpointBuilder getEndpointBuilder(String protocol, String networkAddress, String qualifiedName) {
        return new EndpointBuilder(protocol, networkAddress, qualifiedName, "dbc20663-d705-4ff0-8424-80c262c6b8e7", "Endpoint", this.repositoryHelper, this.serviceName, this.serverName);
    }

    private void validateParameters(String qualifiedName, String typeName, String networkAddress, String externalSourceGuid, String externalSourceName, String userId, String methodName) throws InvalidParameterException {
        this.invalidParameterHandler.validateName(qualifiedName, QUALIFIED_NAME, methodName);
        this.invalidParameterHandler.validateName(typeName, TYPE_NAME, methodName);
        this.invalidParameterHandler.validateName(networkAddress, NETWORK_ADDRESS, methodName);
        this.invalidParameterHandler.validateName(externalSourceGuid, EXTERNAL_SOURCE_GUID, methodName);
        this.invalidParameterHandler.validateName(externalSourceName, EXTERNAL_SOURCE_NAME, methodName);
        this.invalidParameterHandler.validateUserId(userId, methodName);
    }
}

