/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.handlers;

import org.odpi.openmetadata.accessservices.dataengine.model.DeleteSemantic;
import org.odpi.openmetadata.accessservices.dataengine.model.SoftwareServerCapability;
import org.odpi.openmetadata.accessservices.dataengine.server.builders.ExternalDataEnginePropertiesBuilder;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareServerCapabilityHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;

public class DataEngineRegistrationHandler {
    private final String serviceName;
    private final String serverName;
    private final RepositoryHandler repositoryHandler;
    private final OMRSRepositoryHelper repositoryHelper;
    private final SoftwareServerCapabilityHandler<SoftwareServerCapability> softwareServerCapabilityHandler;
    private final InvalidParameterHandler invalidParameterHandler;

    public DataEngineRegistrationHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, SoftwareServerCapabilityHandler<SoftwareServerCapability> softwareServerCapabilityHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.softwareServerCapabilityHandler = softwareServerCapabilityHandler;
    }

    public String upsertExternalDataEngine(String userId, SoftwareServerCapability softwareServerCapability) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "upsertExternalDataEngine";
        this.invalidParameterHandler.validateUserId(userId, "upsertExternalDataEngine");
        String externalEngineName = softwareServerCapability.getQualifiedName();
        this.invalidParameterHandler.validateName(externalEngineName, "qualifiedName", "upsertExternalDataEngine");
        TypeDef entityTypeDef = this.repositoryHelper.getTypeDefByName(userId, "SoftwareServerCapability");
        String externalEngineGUID = this.getExternalDataEngine(userId, externalEngineName);
        if (externalEngineGUID == null) {
            externalEngineGUID = this.softwareServerCapabilityHandler.createSoftwareServerCapability(userId, null, null, entityTypeDef.getGUID(), entityTypeDef.getName(), null, externalEngineName, softwareServerCapability.getName(), softwareServerCapability.getDescription(), softwareServerCapability.getEngineType(), softwareServerCapability.getEngineVersion(), softwareServerCapability.getPatchLevel(), softwareServerCapability.getSource(), softwareServerCapability.getAdditionalProperties(), null, "upsertExternalDataEngine");
        } else {
            ExternalDataEnginePropertiesBuilder builder = this.getExternalDataEnginePropertiesBuilder(softwareServerCapability);
            InstanceProperties properties = builder.getInstanceProperties("upsertExternalDataEngine");
            this.repositoryHandler.updateEntity(userId, externalEngineGUID, externalEngineName, externalEngineGUID, entityTypeDef.getGUID(), entityTypeDef.getName(), properties, null, "upsertExternalDataEngine");
        }
        return externalEngineGUID;
    }

    public String getExternalDataEngine(String userId, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getExternalDataEngineByQualifiedName";
        qualifiedName = this.repositoryHelper.getExactMatchRegex(qualifiedName);
        this.invalidParameterHandler.validateUserId(userId, "getExternalDataEngineByQualifiedName");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "getExternalDataEngineByQualifiedName");
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "qualifiedName", qualifiedName, "getExternalDataEngineByQualifiedName");
        TypeDef entityTypeDef = this.repositoryHelper.getTypeDefByName(userId, "SoftwareServerCapability");
        EntityDetail retrievedEntity = this.repositoryHandler.getUniqueEntityByName(userId, qualifiedName, "qualifiedName", properties, entityTypeDef.getGUID(), entityTypeDef.getName(), "getExternalDataEngineByQualifiedName");
        if (retrievedEntity == null) {
            return null;
        }
        return retrievedEntity.getGUID();
    }

    public void removeExternalDataEngine(String userId, String qualifiedName, String externalSourceName, DeleteSemantic deleteSemantic) throws FunctionNotSupportedException {
        String methodName = "removeExternalDataEngine";
        throw new FunctionNotSupportedException(OMRSErrorCode.METHOD_NOT_IMPLEMENTED.getMessageDefinition(new String[]{"removeExternalDataEngine", this.getClass().getName(), this.serverName}), this.getClass().getName(), "removeExternalDataEngine");
    }

    ExternalDataEnginePropertiesBuilder getExternalDataEnginePropertiesBuilder(SoftwareServerCapability softwareServerCapability) {
        return new ExternalDataEnginePropertiesBuilder(softwareServerCapability.getQualifiedName(), softwareServerCapability.getName(), softwareServerCapability.getDescription(), softwareServerCapability.getEngineType(), softwareServerCapability.getEngineVersion(), softwareServerCapability.getPatchLevel(), softwareServerCapability.getSource(), softwareServerCapability.getAdditionalProperties(), this.repositoryHelper, this.serviceName, this.serverName);
    }
}

