/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.handlers;

import java.util.Map;
import java.util.Optional;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineErrorCode;
import org.odpi.openmetadata.accessservices.dataengine.model.DataFile;
import org.odpi.openmetadata.accessservices.dataengine.model.DeleteSemantic;
import org.odpi.openmetadata.accessservices.dataengine.model.SchemaType;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineCommonHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineConnectionAndEndpointHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineFolderHierarchyHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineSchemaTypeHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;

public class DataEngineDataFileHandler {
    private static final String FILE_GUID_PARAMETER_NAME = "fileGUID";
    private final InvalidParameterHandler invalidParameterHandler;
    private final OMRSRepositoryHelper repositoryHelper;
    private final DataEngineCommonHandler dataEngineCommonHandler;
    private final AssetHandler<DataFile> fileHandler;
    private final DataEngineSchemaTypeHandler dataEngineSchemaTypeHandler;
    private final DataEngineFolderHierarchyHandler dataEngineFolderHierarchyHandler;
    private final DataEngineConnectionAndEndpointHandler dataEngineConnectionAndEndpointHandler;

    public DataEngineDataFileHandler(InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler, DataEngineCommonHandler dataEngineCommonHandler, AssetHandler<DataFile> fileHandler, DataEngineSchemaTypeHandler dataEngineSchemaTypeHandler, DataEngineFolderHierarchyHandler dataEngineFolderHierarchyHandler, DataEngineConnectionAndEndpointHandler dataEngineConnectionAndEndpointHandler) {
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.dataEngineCommonHandler = dataEngineCommonHandler;
        this.fileHandler = fileHandler;
        this.dataEngineSchemaTypeHandler = dataEngineSchemaTypeHandler;
        this.dataEngineFolderHierarchyHandler = dataEngineFolderHierarchyHandler;
        this.dataEngineConnectionAndEndpointHandler = dataEngineConnectionAndEndpointHandler;
    }

    public String upsertFileAssetIntoCatalog(String fileTypeName, String fileTypeGuid, DataFile file, boolean incomplete, SchemaType schemaType, Map<String, Object> extendedProperties, String externalSourceGuid, String externalSourceName, String userId, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.validateParameters(file, schemaType, externalSourceGuid, userId, methodName);
        Optional<EntityDetail> fileAsEntity = this.dataEngineCommonHandler.findEntity(userId, file.getQualifiedName(), fileTypeName);
        String fileGuid = fileAsEntity.isPresent() ? this.updateFileInRepository(userId, externalSourceGuid, externalSourceName, fileAsEntity.get(), file, extendedProperties, methodName) : this.createFileInRepository(fileTypeName, fileTypeGuid, file, extendedProperties, externalSourceGuid, externalSourceName, userId, methodName);
        String schemaTypeGuid = this.dataEngineSchemaTypeHandler.upsertSchemaType(userId, schemaType, externalSourceName);
        this.dataEngineCommonHandler.upsertExternalRelationship(userId, fileGuid, schemaTypeGuid, "AssetSchemaType", fileTypeName, externalSourceName, null);
        this.dataEngineFolderHierarchyHandler.upsertFolderHierarchy(fileGuid, file.getPathName(), externalSourceGuid, externalSourceName, userId, methodName);
        this.dataEngineConnectionAndEndpointHandler.upsertConnectionAndEndpoint(file.getQualifiedName(), fileGuid, fileTypeName, file.getProtocol(), file.getNetworkAddress(), externalSourceGuid, externalSourceName, userId);
        if (incomplete) {
            this.fileHandler.setClassificationInRepository(userId, fileGuid, FILE_GUID_PARAMETER_NAME, fileTypeName, "078432fb-a889-4a51-8ebe-9797becea9f1", "Incomplete", null, methodName);
        }
        return fileGuid;
    }

    public void removeDataFile(String userId, String dataFileGUID, String externalSourceName, String externalSourceGUID, DeleteSemantic deleteSemantic) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "removeDataFile";
        this.dataEngineCommonHandler.validateDeleteSemantic(deleteSemantic, "removeDataFile");
        Optional<EntityDetail> schemaType = this.dataEngineCommonHandler.getEntityForRelationship(userId, dataFileGUID, "AssetSchemaType", "DataFile");
        if (schemaType.isPresent()) {
            this.dataEngineSchemaTypeHandler.removeSchemaType(userId, schemaType.get().getGUID(), externalSourceName, deleteSemantic);
            this.fileHandler.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, dataFileGUID, "guid", "10752b4a-4b5d-4519-9eae-fdd6d162122f", "DataFile", null, null, "removeDataFile");
        } else {
            this.dataEngineCommonHandler.throwInvalidParameterException(DataEngineErrorCode.ENTITY_NOT_DELETED, "removeDataFile", dataFileGUID);
        }
    }

    private String updateFileInRepository(String userId, String externalSourceGuid, String externalSourceName, EntityDetail fileAsEntity, DataFile file, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        TypeDef entityTypeDef = this.repositoryHelper.getTypeDefByName(userId, "DataFile");
        this.fileHandler.updateAsset(userId, externalSourceGuid, externalSourceName, fileAsEntity.getGUID(), "guid", file.getQualifiedName(), file.getDisplayName(), file.getDescription(), file.getAdditionalProperties(), entityTypeDef.getGUID(), entityTypeDef.getName(), extendedProperties, methodName);
        return fileAsEntity.getGUID();
    }

    private String createFileInRepository(String typeName, String typeGuid, DataFile file, Map<String, Object> extendedProperties, String externalSourceGuid, String externalSourceName, String userId, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        int ownerType = this.dataEngineCommonHandler.getOwnerTypeOrdinal(file.getOwnerType());
        return this.fileHandler.createAssetInRepository(userId, externalSourceGuid, externalSourceName, file.getQualifiedName(), file.getDisplayName(), file.getDescription(), file.getZoneMembership(), file.getOwner(), ownerType, file.getOriginOrganizationGUID(), file.getOriginBusinessCapabilityGUID(), file.getOtherOriginValues(), file.getAdditionalProperties(), typeGuid, typeName, extendedProperties, methodName);
    }

    private void validateParameters(DataFile file, SchemaType schemaType, String externalSourceGuid, String userId, String methodName) throws InvalidParameterException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)externalSourceGuid, "externalSourceGuid", methodName);
        this.invalidParameterHandler.validateObject((Object)file, "file", methodName);
        this.invalidParameterHandler.validateName(file.getQualifiedName(), "file.qualifiedName", methodName);
        if (schemaType != null) {
            this.invalidParameterHandler.validateObject((Object)schemaType.getQualifiedName(), "schema.qualifiedName", methodName);
        }
    }
}

