/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.handlers;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.dataengine.rest.FindRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineCommonHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class DataEngineFindHandler {
    private final InvalidParameterHandler invalidParameterHandler;
    private final OMRSRepositoryHelper repositoryHelper;
    private final RepositoryHandler repositoryHandler;
    private final String serviceName;
    private final String serverName;
    private final DataEngineCommonHandler dataEngineCommonHandler;

    public DataEngineFindHandler(InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler, String serviceName, String serverName, DataEngineCommonHandler dataEngineCommonHandler) {
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.dataEngineCommonHandler = dataEngineCommonHandler;
    }

    public GUIDListResponse find(FindRequestBody findRequestBody, String userId, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException {
        this.validateParameters(findRequestBody, userId, methodName);
        GUIDListResponse searchResponse = new GUIDListResponse();
        String matchRegex = this.repositoryHelper.getExactMatchRegex(findRequestBody.getIdentifiers().getQualifiedName(), false);
        String typeGuid = this.getTypeGuid(userId, findRequestBody.getType());
        InstanceProperties instanceProperties = this.buildInstanceProperties(userId, matchRegex);
        String externalSourceName = findRequestBody.getExternalSourceName();
        List result = this.repositoryHandler.getMetadataCollection().findEntitiesByProperty(userId, typeGuid, instanceProperties, MatchCriteria.ANY, 0, Collections.singletonList(InstanceStatus.ACTIVE), null, null, null, SequencingOrder.ANY, 50);
        if (!Objects.isNull(result)) {
            List guids = result.stream().filter(ed -> Objects.isNull(externalSourceName) || externalSourceName.contentEquals(ed.getMetadataCollectionName())).map(InstanceHeader::getGUID).collect(Collectors.toList());
            searchResponse.setGUIDs(guids);
        }
        return searchResponse;
    }

    private void validateParameters(FindRequestBody findRequestBody, String userId, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)findRequestBody, "findRequestBody", methodName);
        this.invalidParameterHandler.validateObject((Object)findRequestBody.getIdentifiers(), "findRequestBody.identifiers", methodName);
        this.invalidParameterHandler.validateName(findRequestBody.getIdentifiers().getQualifiedName(), "findRequestBody.identifiers.qualifiedName", methodName);
    }

    private InstanceProperties buildInstanceProperties(String userId, String matchRegex) {
        InstanceProperties instanceProperties = new InstanceProperties();
        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
        primitivePropertyValue.setPrimitiveValue((Object)matchRegex);
        primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
        primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
        instanceProperties.setProperty("qualifiedName", (InstancePropertyValue)primitivePropertyValue);
        return instanceProperties;
    }

    private String getTypeGuid(String userId, String typeName) {
        if (typeName == null) {
            return "a32316b8-dc8c-48c5-b12b-71c1b2a080bf";
        }
        TypeDef typeDef = this.repositoryHelper.getTypeDefByName(userId, typeName);
        return typeDef == null ? "a32316b8-dc8c-48c5-b12b-71c1b2a080bf" : typeDef.getGUID();
    }
}

