/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.handlers;

import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.odpi.openmetadata.accessservices.dataengine.model.DeleteSemantic;
import org.odpi.openmetadata.accessservices.dataengine.model.Topic;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineCommonHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineRegistrationHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;

public class DataEngineTopicHandler {
    private final InvalidParameterHandler invalidParameterHandler;
    private final AssetHandler<Topic> topicHandler;
    private final DataEngineCommonHandler dataEngineCommonHandler;
    private final DataEngineRegistrationHandler registrationHandler;
    public static final String TOPIC_GUID_PARAMETER_NAME = "topicGUID";

    public DataEngineTopicHandler(InvalidParameterHandler invalidParameterHandler, AssetHandler<Topic> topicHandler, DataEngineRegistrationHandler dataEngineRegistrationHandler, DataEngineCommonHandler dataEngineCommonHandler) {
        this.invalidParameterHandler = invalidParameterHandler;
        this.topicHandler = topicHandler;
        this.registrationHandler = dataEngineRegistrationHandler;
        this.dataEngineCommonHandler = dataEngineCommonHandler;
    }

    public String upsertTopic(String userId, Topic topic, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String topicGUID;
        String methodName = "upsertTopic";
        this.validateParameters(userId, "upsertTopic", topic.getQualifiedName(), topic.getDisplayName());
        String externalSourceGUID = this.registrationHandler.getExternalDataEngine(userId, externalSourceName);
        Optional<EntityDetail> originalTopicEntity = this.findTopicEntity(userId, topic.getQualifiedName());
        HashMap<String, String> extendedProperties = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)topic.getTopicType())) {
            extendedProperties.put("topicType", topic.getTopicType());
        }
        int ownerTypeOrdinal = this.dataEngineCommonHandler.getOwnerTypeOrdinal(topic.getOwnerType());
        if (originalTopicEntity.isEmpty()) {
            this.topicHandler.verifyExternalSourceIdentity(userId, externalSourceGUID, externalSourceName, false, false, null, null);
            topicGUID = this.topicHandler.createAssetInRepository(userId, externalSourceGUID, externalSourceName, topic.getQualifiedName(), topic.getDisplayName(), topic.getDescription(), topic.getZoneMembership(), topic.getOwner(), ownerTypeOrdinal, topic.getOriginOrganizationGUID(), topic.getOriginBusinessCapabilityGUID(), topic.getOtherOriginValues(), topic.getAdditionalProperties(), "29100f49-338e-4361-b05d-7e4e8e818325", "Topic", extendedProperties, "upsertTopic");
        } else {
            topicGUID = originalTopicEntity.get().getGUID();
            this.topicHandler.updateAsset(userId, externalSourceGUID, externalSourceName, topicGUID, TOPIC_GUID_PARAMETER_NAME, topic.getQualifiedName(), topic.getDisplayName(), topic.getDescription(), topic.getAdditionalProperties(), "29100f49-338e-4361-b05d-7e4e8e818325", "Topic", extendedProperties, "upsertTopic");
        }
        return topicGUID;
    }

    public Optional<EntityDetail> findTopicEntity(String userId, String qualifiedName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        return this.dataEngineCommonHandler.findEntity(userId, qualifiedName, "Topic");
    }

    private void validateParameters(String userId, String methodName, String qualifiedName, String displayName) throws InvalidParameterException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.validateName(displayName, "displayName", methodName);
    }

    public void removeTopic(String userId, String topicGUID, String externalSourceName, DeleteSemantic deleteSemantic) throws FunctionNotSupportedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeTopic";
        this.dataEngineCommonHandler.validateDeleteSemantic(deleteSemantic, "removeTopic");
        String externalSourceGUID = this.registrationHandler.getExternalDataEngine(userId, externalSourceName);
        this.topicHandler.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, topicGUID, TOPIC_GUID_PARAMETER_NAME, "29100f49-338e-4361-b05d-7e4e8e818325", "Topic", null, null, "removeTopic");
    }
}

