/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.handlers;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineErrorCode;
import org.odpi.openmetadata.accessservices.dataengine.model.Attribute;
import org.odpi.openmetadata.accessservices.dataengine.model.DataItemSortOrder;
import org.odpi.openmetadata.accessservices.dataengine.model.DeleteSemantic;
import org.odpi.openmetadata.accessservices.dataengine.model.OwnerType;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineRegistrationHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.RelationshipDifferences;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataEngineCommonHandler {
    private final String serviceName;
    private final String serverName;
    private final RepositoryHandler repositoryHandler;
    private final OMRSRepositoryHelper repositoryHelper;
    private final InvalidParameterHandler invalidParameterHandler;
    private final DataEngineRegistrationHandler dataEngineRegistrationHandler;
    private static final Logger log = LoggerFactory.getLogger(DataEngineCommonHandler.class);

    public DataEngineCommonHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, DataEngineRegistrationHandler dataEngineRegistrationHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.dataEngineRegistrationHandler = dataEngineRegistrationHandler;
    }

    protected String createExternalEntity(String userId, InstanceProperties instanceProperties, InstanceStatus instanceStatus, String entityTypeName, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createExternalEntity";
        String externalSourceGUID = this.dataEngineRegistrationHandler.getExternalDataEngine(userId, externalSourceName);
        TypeDef entityTypeDef = this.repositoryHelper.getTypeDefByName(userId, entityTypeName);
        return this.repositoryHandler.createEntity(userId, entityTypeDef.getGUID(), entityTypeDef.getName(), externalSourceGUID, externalSourceName, instanceProperties, instanceStatus, "createExternalEntity");
    }

    protected void updateEntity(String userId, String entityGUID, InstanceProperties instanceProperties, String entityTypeName, String externalSourceName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        String methodName = "updateEntity";
        TypeDef entityTypeDef = this.repositoryHelper.getTypeDefByName(userId, entityTypeName);
        String externalSourceGUID = this.dataEngineRegistrationHandler.getExternalDataEngine(userId, externalSourceName);
        this.repositoryHandler.updateEntity(userId, externalSourceGUID, externalSourceName, entityGUID, entityTypeDef.getGUID(), entityTypeName, instanceProperties, null, "updateEntity");
    }

    protected EntityDetail buildEntityDetail(String entityGUID, InstanceProperties instanceProperties) {
        EntityDetail entityDetail = new EntityDetail();
        entityDetail.setGUID(entityGUID);
        entityDetail.setProperties(instanceProperties);
        return entityDetail;
    }

    protected Relationship buildRelationship(String entityGUID, InstanceProperties instanceProperties) {
        Relationship relationship = new Relationship();
        relationship.setGUID(entityGUID);
        relationship.setProperties(instanceProperties);
        return relationship;
    }

    public Optional<EntityDetail> findEntity(String userId, String qualifiedName, String entityTypeName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        String methodName = "findEntity";
        this.invalidParameterHandler.validateUserId(userId, "findEntity");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "findEntity");
        qualifiedName = this.repositoryHelper.getExactMatchRegex(qualifiedName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "qualifiedName", qualifiedName, "findEntity");
        TypeDef entityTypeDef = this.repositoryHelper.getTypeDefByName(userId, entityTypeName);
        Optional<EntityDetail> retrievedEntity = Optional.ofNullable(this.repositoryHandler.getUniqueEntityByName(userId, qualifiedName, "qualifiedName", properties, entityTypeDef.getGUID(), entityTypeDef.getName(), "findEntity"));
        log.trace("Searching for entity with qualifiedName: {}. Result is {}", (Object)qualifiedName, retrievedEntity.map(InstanceHeader::getGUID).orElse(null));
        return retrievedEntity;
    }

    public Optional<EntityDetail> getEntityDetails(String userId, String entityDetailGUID, String entityTypeName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getEntityDetails";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(entityDetailGUID, "guid", methodName);
        return Optional.ofNullable(this.repositoryHandler.getEntityByGUID(userId, entityDetailGUID, "guid", entityTypeName, methodName));
    }

    protected void upsertExternalRelationship(String userId, String firstGUID, String secondGUID, String relationshipTypeName, String firstEntityTypeName, String externalSourceName, InstanceProperties relationshipProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "upsertExternalRelationship";
        this.invalidParameterHandler.validateUserId(userId, "upsertExternalRelationship");
        this.invalidParameterHandler.validateGUID(firstGUID, "guid", "upsertExternalRelationship");
        this.invalidParameterHandler.validateGUID(secondGUID, "guid", "upsertExternalRelationship");
        String externalSourceGUID = this.dataEngineRegistrationHandler.getExternalDataEngine(userId, externalSourceName);
        Optional<Relationship> relationship = this.findRelationship(userId, firstGUID, secondGUID, firstEntityTypeName, relationshipTypeName);
        if (relationship.isEmpty()) {
            TypeDef relationshipTypeDef = this.repositoryHelper.getTypeDefByName(userId, relationshipTypeName);
            this.repositoryHandler.createExternalRelationship(userId, relationshipTypeDef.getGUID(), externalSourceGUID, externalSourceName, firstGUID, secondGUID, relationshipProperties, "upsertExternalRelationship");
        } else {
            Relationship originalRelationship = relationship.get();
            RelationshipDifferences relationshipDifferences = this.repositoryHelper.getRelationshipDifferences(originalRelationship, this.buildRelationship(originalRelationship.getGUID(), relationshipProperties), true);
            if (relationshipDifferences.hasInstancePropertiesDifferences()) {
                this.repositoryHandler.updateRelationshipProperties(userId, externalSourceGUID, externalSourceName, originalRelationship.getGUID(), relationshipProperties, "upsertExternalRelationship");
            }
        }
    }

    protected Optional<Relationship> findRelationship(String userId, String firstGUID, String secondGUID, String firstEntityTypeName, String relationshipTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findRelationship";
        this.invalidParameterHandler.validateUserId(userId, "findRelationship");
        this.invalidParameterHandler.validateName(firstGUID, "guid", "findRelationship");
        this.invalidParameterHandler.validateName(secondGUID, "guid", "findRelationship");
        TypeDef relationshipTypeDef = this.repositoryHelper.getTypeDefByName(userId, relationshipTypeName);
        Relationship relationshipBetweenEntities = this.repositoryHandler.getRelationshipBetweenEntities(userId, firstGUID, firstEntityTypeName, secondGUID, relationshipTypeDef.getGUID(), relationshipTypeDef.getName(), "findRelationship");
        if (relationshipBetweenEntities == null) {
            return Optional.empty();
        }
        if (firstGUID.equalsIgnoreCase(relationshipBetweenEntities.getEntityOneProxy().getGUID()) && secondGUID.equalsIgnoreCase(relationshipBetweenEntities.getEntityTwoProxy().getGUID())) {
            return Optional.of(relationshipBetweenEntities);
        }
        return Optional.empty();
    }

    protected void removeEntity(String userId, String entityGUID, String entityTypeName, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeEntity";
        this.invalidParameterHandler.validateUserId(userId, "removeEntity");
        this.invalidParameterHandler.validateGUID(entityGUID, "guid", "removeEntity");
        TypeDef entityTypeDef = this.repositoryHelper.getTypeDefByName(userId, entityTypeName);
        String externalSourceGUID = this.dataEngineRegistrationHandler.getExternalDataEngine(userId, externalSourceName);
        this.repositoryHandler.removeEntity(userId, externalSourceGUID, externalSourceName, entityGUID, "entityGUID", entityTypeDef.getGUID(), entityTypeDef.getName(), null, null, "removeEntity");
    }

    protected int getOwnerTypeOrdinal(OwnerType ownerType) {
        int ownerTypeOrdinal = OwnerType.USER_ID.getOpenTypeOrdinal();
        if (ownerType != null) {
            ownerTypeOrdinal = ownerType.getOpenTypeOrdinal();
        }
        return ownerTypeOrdinal;
    }

    protected int getSortOrder(Attribute column) {
        int sortOrder = DataItemSortOrder.UNKNOWN.getOpenTypeOrdinal();
        if (column.getSortOrder() != null) {
            sortOrder = column.getSortOrder().getOpenTypeOrdinal();
        }
        return sortOrder;
    }

    public void throwInvalidParameterException(DataEngineErrorCode errorCode, String methodName, String ... params) throws InvalidParameterException {
        throw new InvalidParameterException(errorCode.getMessageDefinition(params), this.getClass().getName(), methodName, "qualifiedName");
    }

    public void throwEntityNotDeletedException(DataEngineErrorCode errorCode, String methodName, String ... params) throws EntityNotDeletedException {
        throw new EntityNotDeletedException(errorCode.getMessageDefinition(params), this.getClass().getName(), methodName);
    }

    protected Set<EntityDetail> getEntitiesForRelationship(String userId, String guid, String relationshipTypeName, String entityTypeName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        String methodName = "getEntitiesForRelationship";
        this.invalidParameterHandler.validateUserId(userId, "getEntitiesForRelationship");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getEntitiesForRelationship");
        TypeDef relationshipTypeDef = this.repositoryHelper.getTypeDefByName(userId, relationshipTypeName);
        List entities = this.repositoryHandler.getEntitiesForRelationshipType(userId, guid, entityTypeName, relationshipTypeDef.getGUID(), relationshipTypeDef.getName(), 0, 0, "getEntitiesForRelationship");
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return new HashSet<EntityDetail>();
        }
        return entities.parallelStream().collect(Collectors.toSet());
    }

    protected Optional<EntityDetail> getEntityForRelationship(String userId, String entityGUID, String relationshipTypeName, String entityTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getEntityForRelationship";
        this.invalidParameterHandler.validateUserId(userId, "getEntityForRelationship");
        this.invalidParameterHandler.validateGUID(entityGUID, "guid", "getEntityForRelationship");
        TypeDef relationshipTypeDef = this.repositoryHelper.getTypeDefByName(userId, relationshipTypeName);
        return Optional.ofNullable(this.repositoryHandler.getEntityForRelationshipType(userId, entityGUID, entityTypeName, relationshipTypeDef.getGUID(), relationshipTypeDef.getName(), "getEntityForRelationship"));
    }

    protected void validateDeleteSemantic(DeleteSemantic deleteSemantic, String methodName) throws FunctionNotSupportedException {
        if (deleteSemantic != DeleteSemantic.SOFT) {
            throw new FunctionNotSupportedException(OMRSErrorCode.METHOD_NOT_IMPLEMENTED.getMessageDefinition(new String[]{methodName, this.getClass().getName(), this.serverName}), this.getClass().getName(), methodName);
        }
    }
}

