/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.handlers;

import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineErrorCode;
import org.odpi.openmetadata.accessservices.dataengine.model.DeleteSemantic;
import org.odpi.openmetadata.accessservices.dataengine.model.SchemaType;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineCommonHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineRegistrationHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineSchemaAttributeHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetailDifferences;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;

public class DataEngineSchemaTypeHandler {
    public static final String SCHEMA_TYPE_GUID_PARAMETER_NAME = "schemaTypeGUID";
    private final String serviceName;
    private final String serverName;
    private final OMRSRepositoryHelper repositoryHelper;
    private final InvalidParameterHandler invalidParameterHandler;
    private final SchemaTypeHandler<SchemaType> schemaTypeHandler;
    private final DataEngineRegistrationHandler dataEngineRegistrationHandler;
    private final DataEngineCommonHandler dataEngineCommonHandler;
    private final DataEngineSchemaAttributeHandler dataEngineSchemaAttributeHandler;

    public DataEngineSchemaTypeHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, SchemaTypeHandler<SchemaType> schemaTypeHandler, DataEngineRegistrationHandler dataEngineRegistrationHandler, DataEngineCommonHandler dataEngineCommonHandler, DataEngineSchemaAttributeHandler dataEngineSchemaAttributeHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.schemaTypeHandler = schemaTypeHandler;
        this.dataEngineRegistrationHandler = dataEngineRegistrationHandler;
        this.dataEngineCommonHandler = dataEngineCommonHandler;
        this.dataEngineSchemaAttributeHandler = dataEngineSchemaAttributeHandler;
    }

    public String upsertSchemaType(String userId, SchemaType schemaType, String anchorGUID, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String schemaTypeGUID;
        String methodName = "upsertSchemaType";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(schemaType.getQualifiedName(), "qualifiedName", methodName);
        this.invalidParameterHandler.validateName(schemaType.getDisplayName(), "displayName", methodName);
        Optional<EntityDetail> originalSchemaTypeEntity = this.findSchemaTypeEntity(userId, schemaType.getQualifiedName());
        SchemaTypeBuilder schemaTypeBuilder = this.getSchemaTypeBuilder(schemaType);
        if (anchorGUID != null) {
            schemaTypeBuilder.setAnchors(userId, anchorGUID, methodName);
        }
        String externalSourceGUID = this.dataEngineRegistrationHandler.getExternalDataEngine(userId, externalSourceName);
        Date now = this.dataEngineCommonHandler.getNow();
        if (originalSchemaTypeEntity.isEmpty()) {
            schemaTypeGUID = this.schemaTypeHandler.addSchemaType(userId, externalSourceGUID, externalSourceName, schemaTypeBuilder, null, null, false, false, now, methodName);
        } else {
            schemaTypeGUID = originalSchemaTypeEntity.get().getGUID();
            EntityDetail updatedSchemaTypeEntity = this.buildSchemaTypeEntityDetail(schemaTypeGUID, schemaType);
            EntityDetailDifferences entityDetailDifferences = this.repositoryHelper.getEntityDetailDifferences(originalSchemaTypeEntity.get(), updatedSchemaTypeEntity, true);
            if (entityDetailDifferences.hasInstancePropertiesDifferences()) {
                this.schemaTypeHandler.updateSchemaType(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, SCHEMA_TYPE_GUID_PARAMETER_NAME, schemaTypeBuilder, true, false, false, now, methodName);
            }
        }
        this.dataEngineSchemaAttributeHandler.upsertSchemaAttributes(userId, schemaType.getAttributeList(), externalSourceName, externalSourceGUID, schemaTypeGUID);
        return schemaTypeGUID;
    }

    public Optional<EntityDetail> findSchemaTypeEntity(String userId, String qualifiedName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        return this.dataEngineCommonHandler.findEntity(userId, qualifiedName, "SchemaType");
    }

    public void addDataFlowRelationship(String userId, String dataSupplierQualifiedName, String dataConsumerQualifiedName, String externalSourceName, String formula, String description) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addDataFlowRelationship";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(dataSupplierQualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.validateName(dataConsumerQualifiedName, "qualifiedName", methodName);
        Optional<EntityDetail> dataSupplierEntity = this.getDataFlowEntity(userId, dataSupplierQualifiedName);
        Optional<EntityDetail> dataconsumertEntity = this.getDataFlowEntity(userId, dataConsumerQualifiedName);
        if (dataSupplierEntity.isEmpty()) {
            this.dataEngineCommonHandler.throwInvalidParameterException(DataEngineErrorCode.REFERENCEABLE_NOT_FOUND, methodName, dataSupplierQualifiedName);
            return;
        }
        if (dataconsumertEntity.isEmpty()) {
            this.dataEngineCommonHandler.throwInvalidParameterException(DataEngineErrorCode.REFERENCEABLE_NOT_FOUND, methodName, dataConsumerQualifiedName);
            return;
        }
        InstanceProperties relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "description", description, methodName);
        relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, relationshipProperties, "formula", formula, methodName);
        this.dataEngineCommonHandler.upsertExternalRelationship(userId, dataSupplierEntity.get().getGUID(), dataconsumertEntity.get().getGUID(), "DataFlow", dataSupplierEntity.get().getType().getTypeDefName(), dataconsumertEntity.get().getType().getTypeDefName(), externalSourceName, relationshipProperties);
    }

    private Optional<EntityDetail> getDataFlowEntity(String userId, String qualifiedName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        EntityDetail entityDetail;
        Optional<EntityDetail> referenceableEntity = this.dataEngineCommonHandler.findEntity(userId, qualifiedName, "Referenceable");
        if (referenceableEntity.isPresent() && "TabularSchemaType".equalsIgnoreCase((entityDetail = referenceableEntity.get()).getType().getTypeDefName())) {
            return this.dataEngineCommonHandler.getEntityForRelationship(userId, entityDetail.getGUID(), "AssetSchemaType", "TabularSchemaType");
        }
        return referenceableEntity;
    }

    public void removeSchemaType(String userId, String schemaTypeGUID, String externalSourceName, DeleteSemantic deleteSemantic) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "removeSchemaType";
        this.dataEngineCommonHandler.validateDeleteSemantic(deleteSemantic, methodName);
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "guid", methodName);
        Set<String> schemaAttributeGUIDs = this.getSchemaAttributesForSchemaType(userId, schemaTypeGUID);
        for (String schemaAttributeGUID : schemaAttributeGUIDs) {
            this.dataEngineCommonHandler.removeEntity(userId, schemaAttributeGUID, "TabularColumn", externalSourceName);
        }
        this.dataEngineCommonHandler.removeEntity(userId, schemaTypeGUID, "TabularSchemaType", externalSourceName);
    }

    private Set<String> getSchemaAttributesForSchemaType(String userId, String schemaTypeGUID) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        Set<EntityDetail> entities = this.dataEngineCommonHandler.getEntitiesForRelationship(userId, schemaTypeGUID, "AttributeForSchema", "SchemaAttribute", "SchemaType");
        if (CollectionUtils.isEmpty(entities)) {
            return new HashSet<String>();
        }
        return entities.parallelStream().map(InstanceHeader::getGUID).collect(Collectors.toSet());
    }

    private EntityDetail buildSchemaTypeEntityDetail(String schemaTypeGUID, SchemaType schemaType) throws InvalidParameterException {
        String methodName = "buildSchemaTypeEntityDetail";
        SchemaTypeBuilder schemaTypeBuilder = this.getSchemaTypeBuilder(schemaType);
        return this.dataEngineCommonHandler.buildEntityDetail(schemaTypeGUID, schemaTypeBuilder.getInstanceProperties(methodName));
    }

    SchemaTypeBuilder getSchemaTypeBuilder(SchemaType schemaType) {
        return new SchemaTypeBuilder(schemaType.getQualifiedName(), schemaType.getDisplayName(), null, schemaType.getVersionNumber(), false, schemaType.getAuthor(), schemaType.getUsage(), schemaType.getEncodingStandard(), null, null, "248975ec-8019-4b8a-9caf-084c8b724233", "TabularSchemaType", null, this.repositoryHelper, this.serviceName, this.serverName);
    }
}

