/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.handlers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineErrorCode;
import org.odpi.openmetadata.accessservices.dataengine.model.DeleteSemantic;
import org.odpi.openmetadata.accessservices.dataengine.model.Engine;
import org.odpi.openmetadata.accessservices.dataengine.model.ProcessingState;
import org.odpi.openmetadata.accessservices.dataengine.server.builders.ExternalDataEnginePropertiesBuilder;
import org.odpi.openmetadata.accessservices.dataengine.server.service.ClockService;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareCapabilityHandler;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;

public class DataEngineRegistrationHandler {
    private static final String EXTERNAL_ENGINE_PARAMETER_NAME = "externalSourceGUID";
    protected static final String SYNC_DATES_BY_KEY = "syncDatesByKey";
    private final String serviceName;
    private final String serverName;
    private final OMRSRepositoryHelper repositoryHelper;
    private final SoftwareCapabilityHandler<Engine> softwareServerCapabilityHandler;
    private final InvalidParameterHandler invalidParameterHandler;
    private final ClockService clockService;

    public DataEngineRegistrationHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, SoftwareCapabilityHandler<Engine> softwareServerCapabilityHandler, ClockService clockService) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.softwareServerCapabilityHandler = softwareServerCapabilityHandler;
        this.clockService = clockService;
    }

    public String upsertExternalDataEngine(String userId, Engine engine) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "upsertExternalDataEngine";
        this.invalidParameterHandler.validateUserId(userId, "upsertExternalDataEngine");
        String externalEngineName = engine.getQualifiedName();
        this.invalidParameterHandler.validateName(externalEngineName, "qualifiedName", "upsertExternalDataEngine");
        TypeDef entityTypeDef = this.repositoryHelper.getTypeDefByName(userId, "Engine");
        String externalEngineGUID = this.getExternalDataEngine(userId, externalEngineName);
        if (externalEngineGUID == null) {
            externalEngineGUID = this.softwareServerCapabilityHandler.createSoftwareCapability(userId, null, null, entityTypeDef.getName(), null, externalEngineName, engine.getName(), engine.getDescription(), engine.getEngineType(), engine.getEngineVersion(), engine.getPatchLevel(), engine.getSource(), engine.getAdditionalProperties(), null, null, null, null, false, false, this.clockService.getNow(), "upsertExternalDataEngine");
        } else {
            ExternalDataEnginePropertiesBuilder builder = this.getExternalDataEnginePropertiesBuilder(engine);
            InstanceProperties properties = builder.getInstanceProperties("upsertExternalDataEngine");
            this.softwareServerCapabilityHandler.updateBeanInRepository(userId, externalEngineGUID, externalEngineName, externalEngineGUID, "guid", entityTypeDef.getGUID(), entityTypeDef.getName(), properties, true, "upsertExternalDataEngine");
        }
        return externalEngineGUID;
    }

    public String getExternalDataEngine(String userId, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getExternalDataEngineByQualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "getExternalDataEngineByQualifiedName");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "getExternalDataEngineByQualifiedName");
        TypeDef entityTypeDef = this.repositoryHelper.getTypeDefByName(userId, "Engine");
        EntityDetail retrievedEntity = this.softwareServerCapabilityHandler.getEntityByValue(userId, qualifiedName, "qualifiedName", entityTypeDef.getGUID(), entityTypeDef.getName(), Collections.singletonList("qualifiedName"), false, false, this.clockService.getNow(), "getExternalDataEngineByQualifiedName");
        if (retrievedEntity == null) {
            return null;
        }
        return retrievedEntity.getGUID();
    }

    public void removeExternalDataEngine(String userId, String qualifiedName, String externalSourceName, DeleteSemantic deleteSemantic) throws FunctionNotSupportedException {
        String methodName = "removeExternalDataEngine";
        throw new FunctionNotSupportedException(OMRSErrorCode.METHOD_NOT_IMPLEMENTED.getMessageDefinition(new String[]{"removeExternalDataEngine", this.getClass().getName(), this.serverName}), this.getClass().getName(), "removeExternalDataEngine");
    }

    ExternalDataEnginePropertiesBuilder getExternalDataEnginePropertiesBuilder(Engine engine) {
        return new ExternalDataEnginePropertiesBuilder(engine.getQualifiedName(), engine.getName(), engine.getDescription(), engine.getEngineType(), engine.getEngineVersion(), engine.getPatchLevel(), engine.getSource(), engine.getAdditionalProperties(), this.repositoryHelper, this.serviceName, this.serverName);
    }

    public void upsertProcessingStateClassification(String userId, ProcessingState processingState, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "upsertProcessingStateClassification";
        this.invalidParameterHandler.validateUserId(userId, "upsertProcessingStateClassification");
        String externalSourceGUID = this.getExternalDataEngine(userId, externalSourceName);
        this.validateExternalDataEngine(externalSourceName, "upsertProcessingStateClassification", externalSourceGUID);
        EntityDetail retrievedEntity = this.getDataEngineEntity(userId, externalSourceName, "upsertProcessingStateClassification");
        Map newSyncDatesByKey = this.updateSyncDatesByKey(processingState, retrievedEntity);
        if (newSyncDatesByKey.isEmpty()) {
            newSyncDatesByKey = processingState.getSyncDatesByKey();
        }
        InstanceProperties instanceProperties = new InstanceProperties();
        instanceProperties = this.repositoryHelper.addLongMapPropertyToInstance(null, instanceProperties, SYNC_DATES_BY_KEY, newSyncDatesByKey, "upsertProcessingStateClassification");
        this.softwareServerCapabilityHandler.setClassificationInRepository(userId, null, null, externalSourceGUID, EXTERNAL_ENGINE_PARAMETER_NAME, "Engine", "261fb0aa-b884-4ee8-87ea-a60510e9751d", "ProcessingState", instanceProperties, true, false, false, this.clockService.getNow(), "upsertProcessingStateClassification");
    }

    public ProcessingState getProcessingStateClassification(String userId, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getProcessingStateClassification";
        this.invalidParameterHandler.validateUserId(userId, "getProcessingStateClassification");
        String externalSourceGUID = this.getExternalDataEngine(userId, externalSourceName);
        this.validateExternalDataEngine(externalSourceName, "getProcessingStateClassification", externalSourceGUID);
        EntityDetail engineEntity = this.getDataEngineEntity(userId, externalSourceName, "getProcessingStateClassification");
        Map<String, Long> syncDatesByKey = this.getSyncDatesByKey(engineEntity);
        return new ProcessingState(syncDatesByKey);
    }

    private EntityDetail getDataEngineEntity(String userId, String externalSourceName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        TypeDef entityTypeDef = this.repositoryHelper.getTypeDefByName(userId, "Engine");
        return this.softwareServerCapabilityHandler.getEntityByValue(userId, externalSourceName, "qualifiedName", entityTypeDef.getGUID(), entityTypeDef.getName(), Collections.singletonList("qualifiedName"), false, false, this.clockService.getNow(), methodName);
    }

    private void validateExternalDataEngine(String externalSourceName, String methodName, String externalSourceGUID) throws InvalidParameterException {
        if (externalSourceGUID == null) {
            ExceptionMessageDefinition messageDefinition = DataEngineErrorCode.ENGINE_NOT_FOUND.getMessageDefinition(new String[]{externalSourceName});
            throw new InvalidParameterException(messageDefinition, this.getClass().getName(), methodName, EXTERNAL_ENGINE_PARAMETER_NAME);
        }
    }

    private Map<String, Long> updateSyncDatesByKey(ProcessingState processingState, EntityDetail retrievedEntity) {
        HashMap<String, Long> newSyncDatesByKey = new HashMap<String, Long>();
        if (retrievedEntity.getClassifications() != null) {
            for (Classification classification : retrievedEntity.getClassifications()) {
                if (classification == null || !classification.getName().equals("ProcessingState")) continue;
                MapPropertyValue syncDatesByKey = (MapPropertyValue)classification.getProperties().getPropertyValue(SYNC_DATES_BY_KEY);
                for (Map.Entry entry : syncDatesByKey.getMapValues().getInstanceProperties().entrySet()) {
                    newSyncDatesByKey.put(entry.getKey().toString(), (long)((Long)((PrimitivePropertyValue)entry.getValue()).getPrimitiveValue()));
                }
                newSyncDatesByKey.putAll(processingState.getSyncDatesByKey());
            }
        }
        return newSyncDatesByKey;
    }

    private Map<String, Long> getSyncDatesByKey(EntityDetail retrievedEntity) {
        HashMap<String, Long> newSyncDatesByKey = new HashMap<String, Long>();
        if (retrievedEntity.getClassifications() != null) {
            for (Classification classification : retrievedEntity.getClassifications()) {
                if (classification == null || !classification.getName().equals("ProcessingState")) continue;
                MapPropertyValue syncDatesByKey = (MapPropertyValue)classification.getProperties().getPropertyValue(SYNC_DATES_BY_KEY);
                for (Map.Entry entry : syncDatesByKey.getMapValues().getInstanceProperties().entrySet()) {
                    newSyncDatesByKey.put(entry.getKey().toString(), (long)((Long)((PrimitivePropertyValue)entry.getValue()).getPrimitiveValue()));
                }
            }
        }
        return newSyncDatesByKey;
    }
}

