/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.handlers;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.odpi.openmetadata.accessservices.dataengine.model.Attribute;
import org.odpi.openmetadata.accessservices.dataengine.model.SchemaType;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineCommonHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineRegistrationHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetailDifferences;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.springframework.util.CollectionUtils;

public class DataEngineSchemaAttributeHandler {
    protected static final String SCHEMA_TYPE_GUID_PARAMETER_NAME = "schemaTypeGUID";
    private final String serviceName;
    private final String serverName;
    private final OMRSRepositoryHelper repositoryHelper;
    private final InvalidParameterHandler invalidParameterHandler;
    private final SchemaAttributeHandler<Attribute, SchemaType> schemaAttributeHandler;
    private final DataEngineRegistrationHandler dataEngineRegistrationHandler;
    private final DataEngineCommonHandler dataEngineCommonHandler;

    public DataEngineSchemaAttributeHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, SchemaAttributeHandler<Attribute, SchemaType> schemaAttributeHandler, DataEngineRegistrationHandler dataEngineRegistrationHandler, DataEngineCommonHandler dataEngineCommonHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.schemaAttributeHandler = schemaAttributeHandler;
        this.dataEngineRegistrationHandler = dataEngineRegistrationHandler;
        this.dataEngineCommonHandler = dataEngineCommonHandler;
    }

    private Optional<EntityDetail> findSchemaAttributeEntity(String userId, String qualifiedName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        return this.dataEngineCommonHandler.findEntity(userId, qualifiedName, "SchemaAttribute");
    }

    public void upsertSchemaAttributes(String userId, List<Attribute> attributeList, String externalSourceName, String externalSourceGUID, String schemaTypeGUID) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        if (CollectionUtils.isEmpty(attributeList)) {
            return;
        }
        for (Attribute tabularColumn : attributeList) {
            Optional<EntityDetail> schemaAttributeEntity = this.findSchemaAttributeEntity(userId, tabularColumn.getQualifiedName());
            if (schemaAttributeEntity.isEmpty()) {
                this.createSchemaAttribute(userId, schemaTypeGUID, tabularColumn, externalSourceName);
                continue;
            }
            String schemaAttributeGUID = schemaAttributeEntity.get().getGUID();
            EntityDetail updatedSchemaAttributeEntity = this.buildSchemaAttributeEntityDetail(schemaAttributeGUID, tabularColumn);
            EntityDetailDifferences entityDetailDifferences = this.repositoryHelper.getEntityDetailDifferences(schemaAttributeEntity.get(), updatedSchemaAttributeEntity, true);
            if (!entityDetailDifferences.hasInstancePropertiesDifferences()) continue;
            this.updateSchemaAttribute(userId, externalSourceGUID, externalSourceName, schemaAttributeGUID, tabularColumn);
        }
    }

    private EntityDetail buildSchemaAttributeEntityDetail(String schemaAttributeGUID, Attribute attribute) throws InvalidParameterException {
        String methodName = "buildSchemaAttributeEntityDetail";
        SchemaAttributeBuilder schemaAttributeBuilder = this.getSchemaAttributeBuilder(attribute);
        return this.dataEngineCommonHandler.buildEntityDetail(schemaAttributeGUID, schemaAttributeBuilder.getInstanceProperties(methodName));
    }

    private SchemaAttributeBuilder getSchemaAttributeBuilder(Attribute attribute) {
        HashMap additionalProperties = new HashMap();
        return new SchemaAttributeBuilder(attribute.getQualifiedName(), attribute.getDisplayName(), attribute.getDescription(), attribute.getPosition(), attribute.getMinCardinality(), attribute.getMaxCardinality(), attribute.getIsDeprecated(), attribute.getDefaultValueOverride(), attribute.getAllowsDuplicateValues(), attribute.getOrderedValues(), this.dataEngineCommonHandler.getSortOrder(attribute), attribute.getMinimumLength(), attribute.getLength(), attribute.getPrecision(), attribute.getIsNullable(), attribute.getNativeClass(), attribute.getAliases(), additionalProperties, attribute.getTypeGuid() != null ? attribute.getTypeGuid() : "d81a0425-4e9b-4f31-bc1c-e18c3566da10", attribute.getTypeName() != null ? attribute.getTypeName() : "TabularColumn", null, this.repositoryHelper, this.serviceName, this.serverName);
    }

    private void createSchemaAttribute(String userId, String schemaTypeGUID, Attribute attribute, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSchemaAttribute";
        String externalSourceGUID = this.dataEngineRegistrationHandler.getExternalDataEngine(userId, externalSourceName);
        this.schemaAttributeHandler.createNestedSchemaAttribute(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, SCHEMA_TYPE_GUID_PARAMETER_NAME, attribute.getQualifiedName(), "qualifiedName", attribute.getDisplayName(), attribute.getDescription(), attribute.getExternalTypeGUID(), attribute.getDataType(), attribute.getDefaultValue(), attribute.getFixedValue(), attribute.getValidValuesSetGUID(), null, attribute.getIsDeprecated(), attribute.getPosition(), attribute.getMinCardinality(), attribute.getMaxCardinality(), attribute.getAllowsDuplicateValues(), attribute.getOrderedValues(), attribute.getDefaultValueOverride(), this.dataEngineCommonHandler.getSortOrder(attribute), attribute.getMinimumLength(), attribute.getLength(), attribute.getPrecision(), attribute.getIsNullable(), attribute.getNativeClass(), attribute.getAliases(), attribute.getAdditionalProperties(), attribute.getTypeName() != null ? attribute.getTypeName() : "TabularColumn", null, null, null, false, false, this.dataEngineCommonHandler.getNow(), "createSchemaAttribute");
    }

    private void updateSchemaAttribute(String userId, String externalSourceGUID, String externalSourceName, String schemaAttributeGUID, Attribute attribute) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateSchemaAttribute";
        SchemaAttributeBuilder schemaAttributeBuilder = this.getSchemaAttributeBuilder(attribute);
        this.schemaAttributeHandler.updateSchemaAttribute(userId, externalSourceGUID, externalSourceName, schemaAttributeGUID, schemaAttributeBuilder.getInstanceProperties("updateSchemaAttribute"), false, false, this.dataEngineCommonHandler.getNow(), "updateSchemaAttribute");
    }
}

