/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.handlers;

import java.util.Optional;
import org.odpi.openmetadata.accessservices.dataengine.model.DeleteSemantic;
import org.odpi.openmetadata.accessservices.dataengine.model.Port;
import org.odpi.openmetadata.accessservices.dataengine.model.PortImplementation;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineCommonHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineRegistrationHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.PortBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.PortHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetailDifferences;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;

public class DataEnginePortHandler {
    private final String serviceName;
    private final String serverName;
    private final OMRSRepositoryHelper repositoryHelper;
    private final InvalidParameterHandler invalidParameterHandler;
    private final DataEngineCommonHandler dataEngineCommonHandler;
    private final PortHandler<Port> portHandler;
    private final DataEngineRegistrationHandler registrationHandler;
    private static final String PROCESS_GUID_PARAMETER_NAME = "processGUID";
    private static final String PORT_GUID_PARAMETER_NAME = "portGUID";
    private static final String SCHEMA_TYPE_GUID_PARAMETER_NAME = "schemaTypeGUID";

    public DataEnginePortHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, DataEngineCommonHandler dataEngineCommonHandler, PortHandler<Port> portHandler, DataEngineRegistrationHandler registrationHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.dataEngineCommonHandler = dataEngineCommonHandler;
        this.portHandler = portHandler;
        this.registrationHandler = registrationHandler;
    }

    public String createPortImplementation(String userId, PortImplementation port, String processGUID, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createPortImplementation";
        this.validatePortParameters(userId, port.getQualifiedName(), port.getDisplayName(), "createPortImplementation");
        this.invalidParameterHandler.validateGUID(processGUID, "guid", "createPortImplementation");
        String externalSourceGUID = this.registrationHandler.getExternalDataEngine(userId, externalSourceName);
        return this.portHandler.createPort(userId, externalSourceGUID, externalSourceName, processGUID, PROCESS_GUID_PARAMETER_NAME, port.getQualifiedName(), port.getDisplayName(), port.getPortType().getOrdinal(), port.getAdditionalProperties(), "PortImplementation", null, false, false, this.dataEngineCommonHandler.getNow(), "createPortImplementation");
    }

    public void updatePortImplementation(String userId, EntityDetail originalPortEntity, PortImplementation port, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updatePortImplementation";
        this.validatePortParameters(userId, port.getQualifiedName(), port.getDisplayName(), "updatePortImplementation");
        String portGUID = originalPortEntity.getGUID();
        String externalSourceGUID = this.registrationHandler.getExternalDataEngine(userId, externalSourceName);
        PortBuilder updatedPortBuilder = new PortBuilder(port.getQualifiedName(), port.getDisplayName(), port.getPortType().getOrdinal(), port.getAdditionalProperties(), externalSourceGUID, externalSourceName, null, this.repositoryHelper, this.serviceName, this.serverName);
        EntityDetail updatedPortEntity = this.dataEngineCommonHandler.buildEntityDetail(portGUID, updatedPortBuilder.getInstanceProperties("updatePortImplementation"));
        EntityDetailDifferences entityDetailDifferences = this.repositoryHelper.getEntityDetailDifferences(originalPortEntity, updatedPortEntity, true);
        if (!entityDetailDifferences.hasInstancePropertiesDifferences()) {
            return;
        }
        this.portHandler.updatePort(userId, externalSourceGUID, externalSourceName, portGUID, PORT_GUID_PARAMETER_NAME, port.getQualifiedName(), port.getDisplayName(), port.getPortType().getOrdinal(), port.getAdditionalProperties(), "PortImplementation", null, null, null, false, false, this.dataEngineCommonHandler.getNow(), "updatePortImplementation");
    }

    public void addPortSchemaRelationship(String userId, String portGUID, String schemaTypeGUID, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addPortSchemaRelationship";
        this.invalidParameterHandler.validateUserId(userId, "addPortSchemaRelationship");
        this.invalidParameterHandler.validateGUID(portGUID, "guid", "addPortSchemaRelationship");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "guid", "addPortSchemaRelationship");
        Optional<Relationship> relationship = this.dataEngineCommonHandler.findRelationship(userId, portGUID, schemaTypeGUID, "Port", "SchemaType", "PortSchema");
        if (relationship.isEmpty()) {
            String externalSourceGUID = this.registrationHandler.getExternalDataEngine(userId, externalSourceName);
            this.portHandler.setupPortSchemaType(userId, externalSourceGUID, externalSourceName, portGUID, PORT_GUID_PARAMETER_NAME, schemaTypeGUID, SCHEMA_TYPE_GUID_PARAMETER_NAME, null, null, false, false, this.dataEngineCommonHandler.getNow(), "addPortSchemaRelationship");
        }
    }

    public Optional<EntityDetail> findSchemaTypeForPort(String userId, String portGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataEngineCommonHandler.getEntityForRelationship(userId, portGUID, "PortSchema", "Port");
    }

    public void removePort(String userId, String portGUID, String externalSourceName, DeleteSemantic deleteSemantic) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "removePort";
        this.dataEngineCommonHandler.validateDeleteSemantic(deleteSemantic, "removePort");
        String externalSourceGUID = this.registrationHandler.getExternalDataEngine(userId, externalSourceName);
        this.portHandler.removePort(userId, externalSourceGUID, externalSourceName, portGUID, PORT_GUID_PARAMETER_NAME, false, false, this.dataEngineCommonHandler.getNow(), "removePort");
    }

    public Optional<EntityDetail> findPortImplementationEntity(String userId, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataEngineCommonHandler.findEntity(userId, qualifiedName, "PortImplementation");
    }

    private void validatePortParameters(String userId, String qualifiedName, String displayName, String methodName) throws InvalidParameterException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(displayName, "displayName", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
    }
}

