/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.spring;

import org.odpi.openmetadata.accessservices.dataengine.rest.DataEngineRegistrationRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.LineageMappingsRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.PortAliasRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.PortImplementationRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.PortListRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.ProcessesRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.SchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.server.service.DataEngineRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/data-engine/users/{userId}"})
public class DataEngineResource {
    private DataEngineRESTServices restAPI = new DataEngineRESTServices();

    @PostMapping(path={"/registration"})
    public GUIDResponse createExternalDataEngine(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @RequestBody DataEngineRegistrationRequestBody requestBody) {
        return this.restAPI.createExternalDataEngine(serverName, userId, requestBody);
    }

    @GetMapping(path={"/registration/{qualifiedName}"})
    public GUIDResponse getExternalDataEngineByQualifiedName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String qualifiedName) {
        return this.restAPI.getExternalDataEngineByQualifiedName(serverName, userId, qualifiedName);
    }

    @PostMapping(path={"/schema-types"})
    public GUIDResponse createOrUpdateSchemaType(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody SchemaTypeRequestBody requestBody) {
        return this.restAPI.createOrUpdateSchemaType(userId, serverName, requestBody);
    }

    @PostMapping(path={"/port-implementations"})
    public GUIDResponse createOrUpdatePortImplementation(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody PortImplementationRequestBody portImplementationRequestBody) {
        return this.restAPI.createOrUpdatePortImplementation(userId, serverName, portImplementationRequestBody);
    }

    @PostMapping(path={"/port-aliases"})
    public GUIDResponse createOrUpdatePortAlias(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody PortAliasRequestBody portAliasRequestBody) {
        return this.restAPI.createOrUpdatePortAlias(userId, serverName, portAliasRequestBody);
    }

    @PostMapping(path={"/processes"})
    public GUIDListResponse createOrUpdateProcesses(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody ProcessesRequestBody processesRequestBody) {
        return this.restAPI.createOrUpdateProcesses(userId, serverName, processesRequestBody);
    }

    @PostMapping(path={"/processes/{processGuid}/ports"})
    public GUIDResponse addPortsToProcess(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @PathVariable(value="processGuid") String processGuid, @RequestBody PortListRequestBody portListRequestBody) {
        return this.restAPI.addPortsToProcess(userId, serverName, processGuid, portListRequestBody);
    }

    @PostMapping(path={"/lineage-mappings"})
    public VoidResponse addLineageMappings(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody LineageMappingsRequestBody lineageMappingsRequestBody) {
        return this.restAPI.addLineageMappings(userId, serverName, lineageMappingsRequestBody);
    }
}

