/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.dataengine.rest.DataEngineRegistrationRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.DataFileRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.DatabaseRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.DeleteRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.LineageMappingsRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.PortAliasRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.PortImplementationRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.ProcessHierarchyRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.ProcessesDeleteRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.ProcessesRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.RelationalTableRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.SchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.server.service.DataEngineRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ConnectionResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/data-engine/users/{userId}"})
@Tag(name="Data Engine OMAS", description="The Data Engine OMAS provides APIs and events for data movement/processing engines to record the changes made to the data landscape.", externalDocs=@ExternalDocumentation(description="Data Engine Open Metadata Access Service (OMAS)", url="https://egeria.odpi.org/open-metadata-implementation/access-services/data-engine/"))
public class DataEngineResource {
    private DataEngineRESTServices restAPI = new DataEngineRESTServices();

    @PostMapping(path={"/registration"})
    public GUIDResponse createExternalDataEngine(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @RequestBody DataEngineRegistrationRequestBody requestBody) {
        return this.restAPI.createExternalDataEngine(serverName, userId, requestBody);
    }

    @GetMapping(path={"/registration/{qualifiedName}"})
    public GUIDResponse getExternalDataEngineByQualifiedName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String qualifiedName) {
        return this.restAPI.getExternalDataEngine(serverName, userId, qualifiedName);
    }

    @DeleteMapping(path={"/registration"})
    public VoidResponse deleteExternalDataEngine(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteExternalDataEngine(userId, serverName, requestBody);
    }

    @PostMapping(path={"/schema-types"})
    public GUIDResponse createOrUpdateSchemaType(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody SchemaTypeRequestBody requestBody) {
        return this.restAPI.upsertSchemaType(userId, serverName, requestBody);
    }

    @DeleteMapping(path={"/schema-types"})
    public VoidResponse deleteSchemaType(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteSchemaType(userId, serverName, requestBody);
    }

    @PostMapping(path={"/port-implementations"})
    public GUIDResponse createOrUpdatePortImplementation(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody PortImplementationRequestBody portImplementationRequestBody) {
        return this.restAPI.upsertPortImplementation(userId, serverName, portImplementationRequestBody);
    }

    @DeleteMapping(path={"/port-implementations"})
    public VoidResponse deletePortImplementation(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deletePort(userId, serverName, requestBody, "PortImplementation");
    }

    @PostMapping(path={"/port-aliases"})
    public GUIDResponse createOrUpdatePortAlias(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody PortAliasRequestBody portAliasRequestBody) {
        return this.restAPI.upsertPortAlias(userId, serverName, portAliasRequestBody);
    }

    @DeleteMapping(path={"/port-aliases"})
    public VoidResponse deletePortAliases(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deletePort(userId, serverName, requestBody, "PortAlias");
    }

    @PostMapping(path={"/process-hierarchies"})
    public GUIDResponse addProcessHierarchy(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody ProcessHierarchyRequestBody processHierarchyRequestBody) {
        return this.restAPI.addProcessHierarchy(userId, serverName, processHierarchyRequestBody);
    }

    @PostMapping(path={"/processes"})
    public GUIDListResponse createOrUpdateProcesses(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody ProcessesRequestBody processesRequestBody) {
        return this.restAPI.upsertProcesses(userId, serverName, processesRequestBody);
    }

    @DeleteMapping(path={"/processes"})
    public VoidResponse deleteProcesses(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody ProcessesDeleteRequestBody requestBody) {
        return this.restAPI.deleteProcesses(userId, serverName, requestBody);
    }

    @PostMapping(path={"/lineage-mappings"})
    public VoidResponse addLineageMappings(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody LineageMappingsRequestBody lineageMappingsRequestBody) {
        return this.restAPI.addLineageMappings(userId, serverName, lineageMappingsRequestBody);
    }

    @GetMapping(path={"/topics/in-topic-connection"})
    public ConnectionResponse getInTopicConnection(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getInTopicConnection(serverName, userId);
    }

    @PostMapping(path={"/databases"})
    public GUIDResponse upsertDatabase(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody DatabaseRequestBody requestBody) {
        return this.restAPI.upsertDatabase(userId, serverName, requestBody);
    }

    @DeleteMapping(path={"/databases"})
    public VoidResponse deleteDatabase(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteDatabase(userId, serverName, requestBody);
    }

    @PostMapping(path={"/relational-tables"})
    public GUIDResponse upsertRelationalTable(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody RelationalTableRequestBody requestBody) {
        return this.restAPI.upsertRelationalTable(userId, serverName, requestBody);
    }

    @DeleteMapping(path={"/relational-tables"})
    public VoidResponse deleteRelationalTable(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteRelationalTable(userId, serverName, requestBody);
    }

    @PostMapping(path={"/data-files"})
    public GUIDResponse upsertDataFile(@PathVariable String serverName, @PathVariable String userId, @RequestBody DataFileRequestBody dataFileRequestBody) {
        return this.restAPI.upsertDataFile(serverName, userId, dataFileRequestBody);
    }

    @DeleteMapping(path={"/data-files"})
    public VoidResponse deleteDataFile(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteDataFile(userId, serverName, requestBody);
    }

    @DeleteMapping(path={"/folders"})
    public VoidResponse deleteFolder(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteFolder(userId, serverName, requestBody);
    }

    @DeleteMapping(path={"/connections"})
    public VoidResponse deleteConnection(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteConnection(userId, serverName, requestBody);
    }

    @DeleteMapping(path={"/endpoints"})
    public VoidResponse deleteEndpoint(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteEndpoint(userId, serverName, requestBody);
    }
}

