/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.dataengine.rest.DataEngineRegistrationRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.DataFileRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.DataFlowsRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.DatabaseRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.DatabaseSchemaRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.DeleteRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.EventTypeRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.FindRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.PortImplementationRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.ProcessHierarchyRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.ProcessRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.ProcessingStateRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.RelationalTableRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.SchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.TopicRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.server.service.DataEngineRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.PropertiesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest.ConnectionResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/data-engine/users/{userId}"})
@Tag(name="Data Engine OMAS", description="The Data Engine OMAS provides APIs and events for data movement/processing engines to record the changes made to the data landscape.", externalDocs=@ExternalDocumentation(description="Data Engine Open Metadata Access Service (OMAS)", url="https://egeria-project.org/services/omas/data-engine/overview/"))
public class DataEngineResource {
    private DataEngineRESTServices restAPI = new DataEngineRESTServices();

    @PostMapping(path={"/registration"})
    @Operation(summary="createExternalDataEngine", description="Registers an external data engine as source of metadata by creating an engine entity.", externalDocs=@ExternalDocumentation(description="Engine", url="https://egeria-project.org/concepts/software-capability/#engine"))
    public GUIDResponse createExternalDataEngine(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @RequestBody DataEngineRegistrationRequestBody requestBody) {
        return this.restAPI.createExternalDataEngine(serverName, userId, requestBody);
    }

    @GetMapping(path={"/registration/{qualifiedName}"})
    @Operation(summary="getExternalDataEngineByQualifiedName", description="Returns the unique identifier of an external data engine from an engine definition.", externalDocs=@ExternalDocumentation(description="Engine", url="https://egeria-project.org/concepts/software-capability/#engine"))
    public GUIDResponse getExternalDataEngineByQualifiedName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String qualifiedName) {
        return this.restAPI.getExternalDataEngine(serverName, userId, qualifiedName);
    }

    @DeleteMapping(path={"/registration"})
    @Operation(summary="deleteExternalDataEngine", description="Deletes the external data engine.", externalDocs=@ExternalDocumentation(description="Engine", url="https://egeria-project.org/concepts/software-capability/#engine"))
    public VoidResponse deleteExternalDataEngine(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteExternalDataEngine(userId, serverName, requestBody);
    }

    @PostMapping(path={"/schema-types"})
    @Operation(summary="createOrUpdateSchemaType", description="Creates a SchemaType entity with schema attributes and relationships.", externalDocs=@ExternalDocumentation(description="SchemaType", url="https://egeria-project.org/concepts/schema/"))
    public GUIDResponse createOrUpdateSchemaType(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody SchemaTypeRequestBody requestBody) {
        return this.restAPI.upsertSchemaType(userId, serverName, requestBody);
    }

    @DeleteMapping(path={"/schema-types"})
    @Operation(summary="deleteSchemaType", description="Removes a SchemaType entity with all the needed relationships.", externalDocs=@ExternalDocumentation(description="SchemaType", url="https://egeria-project.org/concepts/schema/"))
    public VoidResponse deleteSchemaType(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteSchemaType(userId, serverName, requestBody);
    }

    @PostMapping(path={"/port-implementations"})
    @Operation(summary="createOrUpdatePortImplementation", description="Creates the PortImplementation entity.", externalDocs=@ExternalDocumentation(description="Port", url="https://egeria-project.org/types/2/0217-Ports/"))
    public GUIDResponse createOrUpdatePortImplementation(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody PortImplementationRequestBody portImplementationRequestBody) {
        return this.restAPI.upsertPortImplementation(userId, serverName, portImplementationRequestBody);
    }

    @DeleteMapping(path={"/port-implementations"})
    @Operation(summary="deletePortImplementation", description="Deletes the PortImplementation entity.", externalDocs=@ExternalDocumentation(description="Port", url="https://egeria-project.org/types/2/0217-Ports/"))
    public VoidResponse deletePortImplementation(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deletePort(userId, serverName, requestBody, "PortImplementation");
    }

    @PostMapping(path={"/process-hierarchies"})
    @Operation(summary="addProcessHierarchy", description="Adds a ProcessHierarchy relationship between Process entities.", externalDocs=@ExternalDocumentation(description="ProcessHierarchy", url="https://egeria-project.org/types/2/0215-Software-Components/"))
    public GUIDResponse addProcessHierarchy(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody ProcessHierarchyRequestBody processHierarchyRequestBody) {
        return this.restAPI.addProcessHierarchy(userId, serverName, processHierarchyRequestBody);
    }

    @PostMapping(path={"/processes"})
    @Operation(summary="createOrUpdateProcess", description="Creates or updates the Process entity with ports, schema types and all needed relationships.", externalDocs=@ExternalDocumentation(description="Process", url="https://egeria-project.org/types/2/0215-Software-Components/"))
    public GUIDResponse createOrUpdateProcess(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody ProcessRequestBody processRequestBody) {
        return this.restAPI.upsertProcess(userId, serverName, processRequestBody);
    }

    @DeleteMapping(path={"/processes"})
    @Operation(summary="deleteProcess", description="Deletes the Process.", externalDocs=@ExternalDocumentation(description="Process", url="https://egeria-project.org/types/2/0215-Software-Components/"))
    public VoidResponse deleteProcess(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteProcess(userId, serverName, requestBody);
    }

    @PostMapping(path={"/data-flows"})
    @Operation(summary="addDataFlows", description="Adds DataFlow relationships", externalDocs=@ExternalDocumentation(description="DataFlows", url="https://egeria-project.org/types/7/0750-Data-Passing/"))
    public VoidResponse addDataFlows(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody DataFlowsRequestBody dataFlowsRequestBody) {
        return this.restAPI.addDataFlows(userId, serverName, dataFlowsRequestBody);
    }

    @GetMapping(path={"/topics/in-topic-connection"})
    @Operation(summary="getInTopicConnection", description="Gets the connection details used to access Data Engine OMAS input topic.", externalDocs=@ExternalDocumentation(description="InTopic", url="https://egeria-project.org/concepts/in-topic/"))
    public ConnectionResponse getInTopicConnection(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getInTopicConnection(serverName, userId);
    }

    @PostMapping(path={"/databases"})
    @Operation(summary="upsertDatabase", description="Creates a Database entity with all the needed relationships.", externalDocs=@ExternalDocumentation(description="Database", url="https://egeria-project.org/types/2/0224-Databases/"))
    public GUIDResponse upsertDatabase(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody DatabaseRequestBody requestBody) {
        return this.restAPI.upsertDatabase(userId, serverName, requestBody);
    }

    @DeleteMapping(path={"/databases"})
    @Operation(summary="deleteDatabase", description="Deletes the database.", externalDocs=@ExternalDocumentation(description="Database", url="https://egeria-project.org/types/2/0224-Databases/"))
    public VoidResponse deleteDatabase(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteDatabase(userId, serverName, requestBody);
    }

    @PostMapping(path={"/database-schemas"})
    @Operation(summary="upsertDatabaseSchema", description="Creates a Database Schema entity with a relationship to a database, if provided and not virtual.", externalDocs=@ExternalDocumentation(description="DatabaseSchema", url="https://egeria-project.org/types/2/0224-Databases/#deployeddatabaseschema"))
    public GUIDResponse upsertDatabaseSchema(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody DatabaseSchemaRequestBody requestBody) {
        return this.restAPI.upsertDatabaseSchema(userId, serverName, requestBody);
    }

    @DeleteMapping(path={"/database-schemas"})
    @Operation(summary="deleteDatabaseSchema", description="Deletes the database schema.", externalDocs=@ExternalDocumentation(description="DatabaseSchema", url="https://egeria-project.org/types/2/0224-Databases/#deployeddatabaseschema"))
    public VoidResponse deleteDatabaseSchema(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteDatabaseSchema(userId, serverName, requestBody);
    }

    @PostMapping(path={"/relational-tables"})
    @Operation(summary="upsertRelationalTable", description="Creates a RelationalTable entity with all the needed relationships", externalDocs=@ExternalDocumentation(description="RelationalTable", url="https://egeria-project.org/types/5/0534-Relational-Schemas/"))
    public GUIDResponse upsertRelationalTable(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody RelationalTableRequestBody requestBody) {
        return this.restAPI.upsertRelationalTable(userId, serverName, requestBody);
    }

    @DeleteMapping(path={"/relational-tables"})
    @Operation(summary="deleteRelationalTable", description="Deletes the relational table with columns.", externalDocs=@ExternalDocumentation(description="RelationalTable", url="https://egeria-project.org/types/5/0534-Relational-Schemas/"))
    public VoidResponse deleteRelationalTable(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteRelationalTable(userId, serverName, requestBody);
    }

    @PostMapping(path={"/data-files"})
    @Operation(summary="upsertDataFile", description="Adds a DataFile asset or any of its subtype.", externalDocs=@ExternalDocumentation(description="DataFile", url="https://egeria-project.org/types/2/0220-Files-and-Folders/#datafile"))
    public GUIDResponse upsertDataFile(@PathVariable String serverName, @PathVariable String userId, @RequestBody DataFileRequestBody dataFileRequestBody) {
        return this.restAPI.upsertDataFile(serverName, userId, dataFileRequestBody);
    }

    @DeleteMapping(path={"/data-files"})
    @Operation(summary="deleteDataFile", description="Deletes the data file with columns.", externalDocs=@ExternalDocumentation(description="DataFile", url="https://egeria-project.org/types/2/0220-Files-and-Folders/#datafile"))
    public VoidResponse deleteDataFile(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteDataFile(userId, serverName, requestBody);
    }

    @DeleteMapping(path={"/folders"})
    @Operation(summary="deleteFolder", description="Deletes the folder.", externalDocs=@ExternalDocumentation(description="FileFolder", url="https://egeria-project.org/types/2/0220-Files-and-Folders/#filefolder"))
    public VoidResponse deleteFolder(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteFolder(userId, serverName, requestBody);
    }

    @DeleteMapping(path={"/connections"})
    @Operation(summary="deleteConnection", description="Deletes the connection.", externalDocs=@ExternalDocumentation(description="Connection", url="https://egeria-project.org/types/2/0201-Connectors-and-Connections/"))
    public VoidResponse deleteConnection(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteConnection(userId, serverName, requestBody);
    }

    @DeleteMapping(path={"/endpoints"})
    @Operation(summary="deleteEndpoint", description="Deletes the endpoint.", externalDocs=@ExternalDocumentation(description="Endpoint", url="https://egeria-project.org/types/0/0026-Endpoints/"))
    public VoidResponse deleteEndpoint(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteEndpoint(userId, serverName, requestBody);
    }

    @PostMapping(path={"/find"})
    @Operation(summary="find", description="Find assets.", externalDocs=@ExternalDocumentation(description="Asset", url="https://egeria-project.org/concepts/asset/"))
    public GUIDListResponse search(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody FindRequestBody findRequestBody) {
        return this.restAPI.find(userId, serverName, findRequestBody);
    }

    @PostMapping(path={"/topics"})
    @Operation(summary="upsertTopic", description="Creates or updates a Topic entity with all the needed relationships.", externalDocs=@ExternalDocumentation(description="Topic", url="https://egeria-project.org/types/2/0223-Events-and-Logs/#topic"))
    public GUIDResponse upsertTopic(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody TopicRequestBody requestBody) {
        return this.restAPI.upsertTopic(userId, serverName, requestBody);
    }

    @DeleteMapping(path={"/topics"})
    @Operation(summary="deleteTopic", description="Deletes the topic.", externalDocs=@ExternalDocumentation(description="Topic", url="https://egeria-project.org/types/2/0223-Events-and-Logs/#topic"))
    public VoidResponse deleteTopic(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteTopic(userId, serverName, requestBody);
    }

    @PostMapping(path={"/event-types"})
    @Operation(summary="upsertEventType", description="Creates or updates an Event Type entity with all the needed relationships.", externalDocs=@ExternalDocumentation(description="EventType", url="https://egeria-project.org/types/5/0535-Event-Schemas/#eventtype"))
    public GUIDResponse upsertEventType(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody EventTypeRequestBody requestBody) {
        return this.restAPI.upsertEventType(userId, serverName, requestBody);
    }

    @DeleteMapping(path={"/event-types"})
    @Operation(summary="deleteEventType", description="Deletes the EventType.", externalDocs=@ExternalDocumentation(description="EventType", url="https://egeria-project.org/types/5/0535-Event-Schemas/#eventtype"))
    public VoidResponse deleteEventType(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteEventType(userId, serverName, requestBody);
    }

    @PostMapping(path={"/processing-state"})
    @Operation(summary="upsertProcessingState", description="Creates or updates a data engine's processing state classification with the provided properties", externalDocs=@ExternalDocumentation(description="ProcessingState", url="https://egeria-project.org/patterns/metadata-manager/categories-of-metadata/#metadata-relationships-and-classifications"))
    public VoidResponse upsertProcessingState(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestBody ProcessingStateRequestBody requestBody) {
        return this.restAPI.upsertProcessingState(userId, serverName, requestBody);
    }

    @GetMapping(path={"/processing-state"})
    @Operation(summary="upsertProcessingState", description="Gets the data engine's processing state classification properties.", externalDocs=@ExternalDocumentation(description="ProcessingState", url="https://egeria-project.org/patterns/metadata-manager/categories-of-metadata/#metadata-relationships-and-classifications"))
    public PropertiesResponse getProcessingState(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @RequestParam(value="dataEngine") String externalSourceName) {
        return this.restAPI.getProcessingState(userId, serverName, externalSourceName);
    }
}

