/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.connectors.intopic;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.odpi.openmetadata.accessservices.dataengine.event.DataEngineEventHeader;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineAuditCode;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicSenderConnectorBase;

public class DataEngineInTopicClientConnector
extends OpenMetadataTopicSenderConnectorBase {
    public void sendEvent(DataEngineEventHeader event) throws InvalidParameterException, ConnectorCheckedException {
        String methodName = "sendEvent";
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String eventString = objectMapper.writeValueAsString((Object)event);
            super.sendEvent(eventString);
            if (this.auditLog != null) {
                this.auditLog.logMessage("sendEvent", DataEngineAuditCode.IN_TOPIC_EVENT_SENT.getMessageDefinition(new String[]{eventString}));
            }
        }
        catch (ConnectorCheckedException | InvalidParameterException error) {
            throw error;
        }
        catch (Exception error) {
            throw new ConnectorCheckedException(DataEngineErrorCode.UNABLE_TO_SEND_EVENT.getMessageDefinition(new String[]{this.connectionName, event.toString(), error.getClass().getName(), error.getMessage()}), ((Object)((Object)this)).getClass().getName(), "sendEvent", (Throwable)error);
        }
    }
}

