/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.connectors.intopic;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.concurrent.CompletionException;
import org.odpi.openmetadata.accessservices.dataengine.event.DataEngineEventHeader;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineAuditCode;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicSenderConnectorBase;

public class DataEngineInTopicClientConnector
extends OpenMetadataTopicSenderConnectorBase {
    private static final ObjectWriter OBJECT_WRITER = new ObjectMapper().writer();

    public void sendEvent(DataEngineEventHeader event) throws InvalidParameterException, ConnectorCheckedException {
        String methodName = "sendEvent";
        try {
            String eventString = OBJECT_WRITER.writeValueAsString((Object)event);
            super.sendEvent(eventString).join();
            if (this.auditLog != null) {
                this.auditLog.logMessage("sendEvent", DataEngineAuditCode.IN_TOPIC_EVENT_SENT.getMessageDefinition(new String[]{event.getDataEngineEventType().getEventTypeName()}), eventString);
            }
        }
        catch (CompletionException error) {
            if (error.getCause() instanceof ConnectorCheckedException) {
                throw (ConnectorCheckedException)error.getCause();
            }
            if (error.getCause() instanceof InvalidParameterException) {
                throw (InvalidParameterException)error.getCause();
            }
        }
        catch (ConnectorCheckedException | InvalidParameterException error) {
            throw error;
        }
        catch (Exception error) {
            throw new ConnectorCheckedException(DataEngineErrorCode.UNABLE_TO_SEND_EVENT.getMessageDefinition(new String[]{this.connectionName, event.toString(), error.getClass().getName(), error.getMessage()}), ((Object)((Object)this)).getClass().getName(), "sendEvent", (Throwable)error);
        }
    }
}

