/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.datafolder;

import java.io.File;
import org.odpi.openmetadata.adapters.connectors.basicfile.BasicFileStore;
import org.odpi.openmetadata.adapters.connectors.basicfile.ffdc.exception.FileException;
import org.odpi.openmetadata.adapters.connectors.datafolder.ffdc.DataFolderConnectorErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFolderConnector
extends ConnectorBase
implements BasicFileStore {
    protected String dataFolderName = null;
    private static final Logger log = LoggerFactory.getLogger(DataFolderConnector.class);

    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        super.initialize(connectorInstanceId, connectionProperties);
        EndpointProperties endpoint = connectionProperties.getEndpoint();
        if (endpoint != null) {
            this.dataFolderName = endpoint.getAddress();
        } else {
            log.error("Null endpoint");
        }
    }

    private void throwException(DataFolderConnectorErrorCode errorCode, String methodName, String fileStoreName, Throwable caughtException) throws FileException {
        String errorMessage = fileStoreName == null ? errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.connectionBean.getQualifiedName()) : errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(fileStoreName, this.connectionBean.getQualifiedName());
        if (caughtException == null) {
            throw new FileException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), fileStoreName);
        }
        throw new FileException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), caughtException, fileStoreName);
    }

    public File getFile() throws FileException {
        String methodName = "getFile";
        return this.getFile("getFile");
    }

    protected File getFile(String methodName) throws FileException {
        try {
            File dataFolder;
            if (this.dataFolderName == null) {
                this.throwException(DataFolderConnectorErrorCode.FOLDER_NOT_SPECIFIED, methodName, null, null);
            }
            if (!(dataFolder = new File(this.dataFolderName)).exists()) {
                this.throwException(DataFolderConnectorErrorCode.FOLDER_NOT_FOUND, methodName, this.dataFolderName, null);
            }
            if (!dataFolder.isDirectory()) {
                this.throwException(DataFolderConnectorErrorCode.FILE_NOT_DIRECTORY, methodName, this.dataFolderName, null);
            }
            if (!dataFolder.canRead()) {
                this.throwException(DataFolderConnectorErrorCode.FOLDER_NOT_READABLE, methodName, this.dataFolderName, null);
            }
            return dataFolder;
        }
        catch (FileException error) {
            log.debug("Throwing error " + ((Object)((Object)error)).getClass().getSimpleName() + " with message " + error.getMessage());
            throw error;
        }
        catch (SecurityException error) {
            this.throwException(DataFolderConnectorErrorCode.UNEXPECTED_SECURITY_EXCEPTION, methodName, this.dataFolderName, error);
        }
        catch (Throwable error) {
            this.throwException(DataFolderConnectorErrorCode.UNEXPECTED_IO_EXCEPTION, methodName, this.dataFolderName, error);
        }
        return null;
    }

    public void disconnect() {
        try {
            super.disconnect();
        }
        catch (Throwable exec) {
            log.debug("Ignoring unexpected exception " + exec.getClass().getSimpleName() + " with message " + exec.getMessage());
        }
        log.debug("Closing File");
    }
}

