/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.datastore.datafolder.ffdc;

import java.text.MessageFormat;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DataFolderConnectorErrorCode {
    FOLDER_NOT_SPECIFIED(400, "DATA-FOLDER-CONNECTOR-400-001 ", "The folder name is null in the Connection object {0}", "The connector is unable to open the folder because the name of the folder is not passed in the Connection object.", "The name of the folder should be set up in the address property of the connection's Endpoint object."),
    FILE_NOT_DIRECTORY(400, "DATA-FOLDER-CONNECTOR-400-002 ", "The folder {0} given in Connection object {1} is a file", "The connector is unable to work with a file.", "Ensure a valid folder name is passed in the address property in the Endpoint object of the Connection object."),
    FOLDER_NOT_READABLE(400, "DATA-FOLDER-CONNECTOR-400-003 ", "The folder {0} given in Connection object {1} is not readable", "The connector is unable to open the folder.", "Ensure a valid folder name is passed in the address property in the Endpoint object of the Connection object."),
    FOLDER_NOT_FOUND(404, "DATA-FOLDER-CONNECTOR-404-001 ", "The folder named {0} in the Connection object {1} does not exist", "The connector is unable to open the folder.", "Add the name of an existing folder to the address property of the connection's Endpoint object."),
    UNEXPECTED_SECURITY_EXCEPTION(500, "DATA-FOLDER-CONNECTOR-500-001 ", "The connector received an unexpected security exception when reading the file named {0}; the error message was: {1}", "The connector is unable to process the folder.", "Use details from the error message to determine the cause of the error and retry the request once it is resolved."),
    UNEXPECTED_IO_EXCEPTION(500, "DATA-FOLDER-CONNECTOR-500-002 ", "The connector received an unexpected IO exception when reading the folder named {0}; the error message was: {1}", "The connector is unable to process the data in the folder.", "Use details from the error message to determine the cause of the error and retry the request once it is resolved.");

    private int httpErrorCode;
    private String errorMessageId;
    private String errorMessage;
    private String systemAction;
    private String userAction;
    private static final Logger log;

    private DataFolderConnectorErrorCode(int newHTTPErrorCode, String newErrorMessageId, String newErrorMessage, String newSystemAction, String newUserAction) {
        this.httpErrorCode = newHTTPErrorCode;
        this.errorMessageId = newErrorMessageId;
        this.errorMessage = newErrorMessage;
        this.systemAction = newSystemAction;
        this.userAction = newUserAction;
    }

    public int getHTTPErrorCode() {
        return this.httpErrorCode;
    }

    public String getErrorMessageId() {
        return this.errorMessageId;
    }

    public String getUnformattedErrorMessage() {
        return this.errorMessage;
    }

    public String getFormattedErrorMessage(String ... params) {
        log.debug(String.format("<== BasicFileConnectorErrorCode.getMessage(%s)", Arrays.toString(params)));
        MessageFormat mf = new MessageFormat(this.errorMessage);
        String result = mf.format(params);
        log.debug(String.format("==> BasicFileConnectorErrorCode.getMessage(%s): %s", Arrays.toString(params), result));
        return result;
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }

    public String toString() {
        return "BasicFileConnectorErrorCode{httpErrorCode=" + this.httpErrorCode + ", errorMessageId='" + this.errorMessageId + '\'' + ", errorMessage='" + this.errorMessage + '\'' + ", systemAction='" + this.systemAction + '\'' + ", userAction='" + this.userAction + '\'' + '}';
    }

    static {
        log = LoggerFactory.getLogger(DataFolderConnectorErrorCode.class);
    }
}

