/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.datastore.datafolder.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum DataFolderConnectorErrorCode implements ExceptionMessageSet
{
    FOLDER_NOT_SPECIFIED(400, "DATA-FOLDER-CONNECTOR-400-001", "The folder name is null in the Connection object {0}", "The connector is unable to open the folder because the name of the folder is not passed in the Connection object.", "The name of the folder should be set up in the address property of the connection's Endpoint object."),
    FILE_NOT_DIRECTORY(400, "DATA-FOLDER-CONNECTOR-400-002", "The folder {0} given in Connection object {1} is a file", "The connector is unable to work with a file.", "Ensure a valid folder name is passed in the address property in the Endpoint object of the Connection object."),
    FOLDER_NOT_READABLE(400, "DATA-FOLDER-CONNECTOR-400-003", "The folder {0} given in Connection object {1} is not readable", "The connector is unable to open the folder because it does not have permission to read the file.", "Ensure a readable folder name is passed in the address property in the Endpoint object of the Connection object."),
    FOLDER_NOT_FOUND(404, "DATA-FOLDER-CONNECTOR-404-001", "The folder named {0} in the Connection object {1} does not exist", "The connector is unable to open the folder because it does not exist.", "Add the name of an existing folder to the address property of the connection's Endpoint object."),
    UNEXPECTED_SECURITY_EXCEPTION(500, "DATA-FOLDER-CONNECTOR-500-001", "The connector received an unexpected security exception when reading the file named {0}; the error message was: {1}", "The connector is unable to process the folder.", "Use details from the error message to determine the cause of the security exception and retry the request once it is resolved."),
    UNEXPECTED_IO_EXCEPTION(500, "DATA-FOLDER-CONNECTOR-500-002", "The connector received an unexpected IO exception when reading the folder named {0}; the error message was: {1}", "The connector is unable to process the data in the folder.", "Use details from the error message to determine the cause of the error and retry the request once it is resolved.");

    private ExceptionMessageDefinition messageDefinition;

    private DataFolderConnectorErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.messageDefinition = new ExceptionMessageDefinition(httpErrorCode, errorMessageId, errorMessage, systemAction, userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return this.messageDefinition;
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        this.messageDefinition.setMessageParameters(params);
        return this.messageDefinition;
    }

    public String toString() {
        return "DataFolderConnectorErrorCode{messageDefinition=" + this.getMessageDefinition() + "}";
    }
}

