/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ElementHeader;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.MetadataElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseColumnProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseForeignKeyProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabasePrimaryKeyProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DatabaseColumnElement
extends DatabaseColumnProperties
implements MetadataElement,
Serializable {
    private static final long serialVersionUID = 1L;
    private ElementHeader elementHeader = null;
    private DatabasePrimaryKeyProperties primaryKeyProperties = null;
    private DatabaseForeignKeyProperties foreignKeyProperties = null;
    private String referencedColumnGUID = null;
    private String referencedColumnQualifiedName = null;

    public DatabaseColumnElement() {
    }

    public DatabaseColumnElement(DatabaseColumnElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
        }
    }

    @Override
    public ElementHeader getElementHeader() {
        return this.elementHeader;
    }

    @Override
    public void setElementHeader(ElementHeader elementHeader) {
        this.elementHeader = elementHeader;
    }

    public DatabasePrimaryKeyProperties getPrimaryKeyProperties() {
        return this.primaryKeyProperties;
    }

    public void setPrimaryKeyProperties(DatabasePrimaryKeyProperties primaryKeyProperties) {
        this.primaryKeyProperties = primaryKeyProperties;
    }

    public DatabaseForeignKeyProperties getForeignKeyProperties() {
        return this.foreignKeyProperties;
    }

    public void setForeignKeyProperties(DatabaseForeignKeyProperties foreignKeyProperties) {
        this.foreignKeyProperties = foreignKeyProperties;
    }

    public String getReferencedColumnGUID() {
        return this.referencedColumnGUID;
    }

    public void setReferencedColumnGUID(String referencedColumnGUID) {
        this.referencedColumnGUID = referencedColumnGUID;
    }

    public String getReferencedColumnQualifiedName() {
        return this.referencedColumnQualifiedName;
    }

    public void setReferencedColumnQualifiedName(String referencedColumnQualifiedName) {
        this.referencedColumnQualifiedName = referencedColumnQualifiedName;
    }

    @Override
    public String toString() {
        return "DatabaseColumnElement{elementHeader=" + this.elementHeader + ", primaryKeyProperties=" + this.primaryKeyProperties + ", foreignKeyProperties=" + this.foreignKeyProperties + ", referencedColumnGUID='" + this.referencedColumnGUID + '\'' + ", referencedColumnQualifiedName='" + this.referencedColumnQualifiedName + '\'' + ", formula='" + this.getFormula() + '\'' + ", queries=" + this.getQueries() + ", dataType='" + this.getDataType() + '\'' + ", defaultValue='" + this.getDefaultValue() + '\'' + ", elementPosition=" + this.getElementPosition() + ", minCardinality=" + this.getMinCardinality() + ", maxCardinality=" + this.getMaxCardinality() + ", allowsDuplicateValues=" + this.isAllowsDuplicateValues() + ", orderedValues=" + this.isOrderedValues() + ", sortOrder=" + this.getSortOrder() + ", minimumLength=" + this.getMinimumLength() + ", length=" + this.getLength() + ", significantDigits=" + this.getSignificantDigits() + ", nullable=" + this.isNullable() + ", defaultValueOverride='" + this.getDefaultValueOverride() + '\'' + ", anchorGUID='" + this.getAnchorGUID() + '\'' + ", nativeJavaClass='" + this.getNativeJavaClass() + '\'' + ", aliases=" + this.getAliases() + ", deprecated=" + this.isDeprecated() + ", displayName='" + this.getDisplayName() + '\'' + ", description='" + this.getDescription() + '\'' + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", vendorProperties=" + this.getVendorProperties() + ", typeName='" + this.getTypeName() + '\'' + ", extendedProperties=" + this.getExtendedProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        DatabaseColumnElement that = (DatabaseColumnElement)objectToCompare;
        return Objects.equals(this.elementHeader, that.elementHeader) && Objects.equals(this.primaryKeyProperties, that.primaryKeyProperties) && Objects.equals(this.foreignKeyProperties, that.foreignKeyProperties) && Objects.equals(this.referencedColumnGUID, that.referencedColumnGUID) && Objects.equals(this.referencedColumnQualifiedName, that.referencedColumnQualifiedName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementHeader, this.primaryKeyProperties, this.foreignKeyProperties, this.referencedColumnGUID, this.referencedColumnQualifiedName);
    }
}

