/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseColumnProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaAttributeProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=DatabaseColumnProperties.class, name="DatabaseColumnProperties")})
public class TabularColumnProperties
extends SchemaAttributeProperties {
    private static final long serialVersionUID = 1L;
    private String dataType = null;
    private String defaultValue = null;

    public TabularColumnProperties() {
    }

    public TabularColumnProperties(DatabaseColumnProperties template) {
        super(template);
        if (template != null) {
            this.dataType = template.getDataType();
            this.defaultValue = template.getDefaultValue();
        }
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public String toString() {
        return "TabularColumnProperties{dataType='" + this.dataType + '\'' + ", defaultValue='" + this.defaultValue + '\'' + ", elementPosition=" + this.getElementPosition() + ", minCardinality=" + this.getMinCardinality() + ", maxCardinality=" + this.getMaxCardinality() + ", allowsDuplicateValues=" + this.isAllowsDuplicateValues() + ", orderedValues=" + this.isOrderedValues() + ", sortOrder=" + this.getSortOrder() + ", minimumLength=" + this.getMinimumLength() + ", length=" + this.getLength() + ", significantDigits=" + this.getSignificantDigits() + ", nullable=" + this.isNullable() + ", defaultValueOverride='" + this.getDefaultValueOverride() + '\'' + ", anchorGUID='" + this.getAnchorGUID() + '\'' + ", nativeJavaClass='" + this.getNativeJavaClass() + '\'' + ", aliases=" + this.getAliases() + ", deprecated=" + this.isDeprecated() + ", displayName='" + this.getDisplayName() + '\'' + ", description='" + this.getDescription() + '\'' + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", vendorProperties=" + this.getVendorProperties() + ", typeName='" + this.getTypeName() + '\'' + ", extendedProperties=" + this.getExtendedProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        TabularColumnProperties that = (TabularColumnProperties)objectToCompare;
        return Objects.equals(this.dataType, that.dataType) && Objects.equals(this.defaultValue, that.defaultValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dataType, this.defaultValue);
    }
}

