/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.datamanager.events.DataManagerEventType;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ElementHeader;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DataManagerOutTopicEvent
implements Serializable {
    private long eventVersionId = 1L;
    private DataManagerEventType eventType = null;
    private ElementHeader elementHeader = null;

    public DataManagerOutTopicEvent() {
    }

    public DataManagerOutTopicEvent(DataManagerOutTopicEvent template) {
        if (template != null) {
            this.eventVersionId = template.getEventVersionId();
            this.eventType = template.getEventType();
            this.elementHeader = template.getElementHeader();
        }
    }

    public long getEventVersionId() {
        return this.eventVersionId;
    }

    public void setEventVersionId(long eventVersionId) {
    }

    public DataManagerEventType getEventType() {
        return this.eventType;
    }

    public void setEventType(DataManagerEventType eventType) {
        this.eventType = eventType;
    }

    public ElementHeader getElementHeader() {
        return this.elementHeader;
    }

    public void setElementHeader(ElementHeader elementHeader) {
        this.elementHeader = elementHeader;
    }

    public String toString() {
        return "DataManagerOutTopicEvent{eventVersionId=" + this.eventVersionId + ", eventType=" + this.eventType + ", elementHeader=" + this.elementHeader + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        DataManagerOutTopicEvent that = (DataManagerOutTopicEvent)objectToCompare;
        return this.eventVersionId == that.eventVersionId && this.eventType == that.eventType && Objects.equals(this.elementHeader, that.elementHeader);
    }

    public int hashCode() {
        return Objects.hash(this.eventVersionId, this.eventType, this.elementHeader);
    }
}

