/* SPDX-License-Identifier: Apache 2.0 */
/* Copyright Contributors to the ODPi Egeria project. */
package org.odpi.openmetadata.accessservices.datamanager.rest;

import com.fasterxml.jackson.annotation.*;
import org.odpi.openmetadata.accessservices.datamanager.properties.DataFileProperties;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.NONE;
import static com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.PUBLIC_ONLY;

/**
 * NewDataFileRequestBody carries the parameters for creating a new file asset.
 */
@JsonAutoDetect(getterVisibility=PUBLIC_ONLY, setterVisibility=PUBLIC_ONLY, fieldVisibility=NONE)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class NewDataFileRequestBody extends DataFileProperties
{
    private static final long    serialVersionUID = 1L;

    private String              connectorClassName   = null;


    /**
     * Default constructor
     */
    public NewDataFileRequestBody()
    {
    }


    /**
     * Copy/clone constructor
     *
     * @param template object to copy
     */
    public NewDataFileRequestBody(NewDataFileRequestBody template)
    {
        super(template);

        if (template != null)
        {
            connectorClassName = template.getConnectorClassName();
        }
    }


    /**
     * Return the fully qualified class name of the connector provider for this type of file.  If null is
     * passed, the server uses the default file connector.
     *
     * @return string name
     */
    public String getConnectorClassName()
    {
        return connectorClassName;
    }


    /**
     * Set up the fully qualified class name of the connector provider for this type of file.  If null is
     * passed, the server uses the default file connector.
     *
     * @param connectorClassName string name
     */
    public void setConnectorClassName(String connectorClassName)
    {
        this.connectorClassName = connectorClassName;
    }


    /**
     * JSON-style toString
     *
     * @return return string containing the property names and values
     */
    @Override
    public String toString()
    {
        return "NewDataFileRequestBody{" +
                "connectorClassName='" + connectorClassName + '\'' +
                ", fileType='" + getFileType() + '\'' +
                ", createTime=" + getCreateTime() +
                ", modifiedTime=" + getModifiedTime() +
                ", encodingType='" + getEncodingType() + '\'' +
                ", encodingLanguage='" + getEncodingLanguage() + '\'' +
                ", encodingDescription='" + getEncodingDescription() + '\'' +
                ", displayName='" + getDisplayName() + '\'' +
                ", description='" + getDescription() + '\'' +
                ", owner='" + getOwner() + '\'' +
                ", ownerCategory=" + getOwnerCategory() +
                ", zoneMembership=" + getZoneMembership() +
                ", origin=" + getOrigin() +
                ", latestChange='" + getLatestChange() + '\'' +
                ", qualifiedName='" + getQualifiedName() + '\'' +
                ", additionalProperties=" + getAdditionalProperties() +
                ", vendorProperties=" + getVendorProperties() +
                ", typeName='" + getTypeName() + '\'' +
                ", extendedProperties=" + getExtendedProperties() +
                '}';
    }


    /**
     * Return comparison result based on the content of the properties.
     *
     * @param objectToCompare test object
     * @return result of comparison
     */
    @Override
    public boolean equals(Object objectToCompare)
    {
        if (this == objectToCompare)
        {
            return true;
        }
        if (objectToCompare == null || getClass() != objectToCompare.getClass())
        {
            return false;
        }
        if (!super.equals(objectToCompare))
        {
            return false;
        }
        NewDataFileRequestBody that = (NewDataFileRequestBody) objectToCompare;
        return Objects.equals(connectorClassName, that.connectorClassName);
    }


    /**
     * Return hash code for this object
     *
     * @return int hash code
     */
    @Override
    public int hashCode()
    {
        return Objects.hash(super.hashCode(), connectorClassName);
    }
}