/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ElementType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String typeId = null;
    private String typeName = null;
    private List<String> superTypeNames = null;
    private long typeVersion = 0L;
    private String typeDescription = null;

    public ElementType() {
    }

    public ElementType(ElementType templateType) {
        if (templateType != null) {
            this.typeId = templateType.getTypeId();
            this.typeName = templateType.getTypeName();
            this.superTypeNames = templateType.getSuperTypeNames();
            this.typeVersion = templateType.getTypeVersion();
            this.typeDescription = templateType.getTypeDescription();
        }
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setSuperTypeNames(List<String> superTypeNames) {
        this.superTypeNames = superTypeNames;
    }

    public List<String> getSuperTypeNames() {
        if (this.superTypeNames == null) {
            return null;
        }
        if (this.superTypeNames.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.superTypeNames);
    }

    public void setTypeVersion(long typeVersion) {
        this.typeVersion = typeVersion;
    }

    public long getTypeVersion() {
        return this.typeVersion;
    }

    public void setTypeDescription(String typeDescription) {
        this.typeDescription = typeDescription;
    }

    public String getTypeDescription() {
        return this.typeDescription;
    }

    public String toString() {
        return "ElementType{elementTypeId='" + this.typeId + '\'' + ", elementTypeName='" + this.typeName + '\'' + ", elementSuperTypeNames=" + this.superTypeNames + ", elementTypeVersion=" + this.typeVersion + ", elementTypeDescription='" + this.typeDescription + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof ElementType)) {
            return false;
        }
        ElementType that = (ElementType)objectToCompare;
        return this.getTypeVersion() == that.getTypeVersion() && Objects.equals(this.getTypeId(), that.getTypeId()) && Objects.equals(this.getTypeName(), that.getTypeName()) && Objects.equals(this.getSuperTypeNames(), that.getSuperTypeNames()) && Objects.equals(this.getTypeDescription(), that.getTypeDescription());
    }

    public int hashCode() {
        return Objects.hash(this.getTypeId(), this.getTypeName(), this.getSuperTypeNames(), this.getTypeVersion(), this.getTypeDescription());
    }
}

