/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.datamanager.properties.DataItemSortOrder;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaElementProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.TabularColumnProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=TabularColumnProperties.class, name="TabularColumnProperties")})
public class SchemaAttributeProperties
extends SchemaElementProperties {
    private static final long serialVersionUID = 1L;
    private int elementPosition = 0;
    private int minCardinality = 0;
    private int maxCardinality = 0;
    private boolean allowsDuplicateValues = false;
    private boolean orderedValues = false;
    private String defaultValueOverride = null;
    private DataItemSortOrder sortOrder = null;
    private int minimumLength = 0;
    private int length = 0;
    private int precision = 0;
    private boolean isNullable = true;
    private String nativeJavaClass = null;
    private List<String> aliases = null;
    private SchemaTypeProperties schemaType = null;

    public SchemaAttributeProperties() {
    }

    public SchemaAttributeProperties(SchemaAttributeProperties template) {
        super(template);
        if (template != null) {
            this.elementPosition = template.getElementPosition();
            this.minCardinality = template.getMinCardinality();
            this.maxCardinality = template.getMaxCardinality();
            this.allowsDuplicateValues = template.getAllowsDuplicateValues();
            this.orderedValues = template.getOrderedValues();
            this.sortOrder = template.getSortOrder();
            this.minimumLength = template.getMinimumLength();
            this.length = template.getLength();
            this.precision = template.getPrecision();
            this.isNullable = template.getIsNullable();
            this.defaultValueOverride = template.getDefaultValueOverride();
            this.nativeJavaClass = template.getNativeJavaClass();
            this.aliases = template.getAliases();
            this.schemaType = template.getSchemaType();
        }
    }

    public int getElementPosition() {
        return this.elementPosition;
    }

    public void setElementPosition(int elementPosition) {
        this.elementPosition = elementPosition;
    }

    public int getMinCardinality() {
        return this.minCardinality;
    }

    public void setMinCardinality(int minCardinality) {
        this.minCardinality = minCardinality;
    }

    public int getMaxCardinality() {
        return this.maxCardinality;
    }

    public void setMaxCardinality(int maxCardinality) {
        this.maxCardinality = maxCardinality;
    }

    public boolean getAllowsDuplicateValues() {
        return this.allowsDuplicateValues;
    }

    public void setAllowsDuplicateValues(boolean allowsDuplicateValues) {
        this.allowsDuplicateValues = allowsDuplicateValues;
    }

    public boolean getOrderedValues() {
        return this.orderedValues;
    }

    public void setOrderedValues(boolean orderedValues) {
        this.orderedValues = orderedValues;
    }

    public DataItemSortOrder getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(DataItemSortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public int getMinimumLength() {
        return this.minimumLength;
    }

    public void setMinimumLength(int minimumLength) {
        this.minimumLength = minimumLength;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public boolean getIsNullable() {
        return this.isNullable;
    }

    public void setIsNullable(boolean nullable) {
        this.isNullable = nullable;
    }

    public String getDefaultValueOverride() {
        return this.defaultValueOverride;
    }

    public void setDefaultValueOverride(String defaultValueOverride) {
        this.defaultValueOverride = defaultValueOverride;
    }

    public String getNativeJavaClass() {
        return this.nativeJavaClass;
    }

    public void setNativeJavaClass(String nativeJavaClass) {
        this.nativeJavaClass = nativeJavaClass;
    }

    public List<String> getAliases() {
        if (this.aliases == null) {
            return null;
        }
        if (this.aliases.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.aliases);
    }

    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    public SchemaTypeProperties getSchemaType() {
        return this.schemaType;
    }

    public void setSchemaType(SchemaTypeProperties schemaType) {
        this.schemaType = schemaType;
    }

    @Override
    public String toString() {
        return "SchemaAttributeProperties{elementPosition=" + this.elementPosition + ", minCardinality=" + this.minCardinality + ", maxCardinality=" + this.maxCardinality + ", allowsDuplicateValues=" + this.allowsDuplicateValues + ", orderedValues=" + this.orderedValues + ", defaultValueOverride='" + this.defaultValueOverride + '\'' + ", sortOrder=" + this.sortOrder + ", minimumLength=" + this.minimumLength + ", length=" + this.length + ", significantDigits=" + this.precision + ", isNullable=" + this.isNullable + ", nativeJavaClass='" + this.nativeJavaClass + '\'' + ", aliases=" + this.aliases + ", schemaType=" + this.schemaType + ", nullable=" + this.getIsNullable() + ", deprecated=" + this.getIsDeprecated() + ", displayName='" + this.getDisplayName() + '\'' + ", description='" + this.getDescription() + '\'' + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", vendorProperties=" + this.getVendorProperties() + ", typeName='" + this.getTypeName() + '\'' + ", extendedProperties=" + this.getExtendedProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        SchemaAttributeProperties that = (SchemaAttributeProperties)objectToCompare;
        return this.elementPosition == that.elementPosition && this.minCardinality == that.minCardinality && this.maxCardinality == that.maxCardinality && this.allowsDuplicateValues == that.allowsDuplicateValues && this.orderedValues == that.orderedValues && this.minimumLength == that.minimumLength && this.length == that.length && this.precision == that.precision && this.isNullable == that.isNullable && Objects.equals(this.defaultValueOverride, that.defaultValueOverride) && this.sortOrder == that.sortOrder && Objects.equals(this.nativeJavaClass, that.nativeJavaClass) && Objects.equals(this.aliases, that.aliases) && Objects.equals(this.schemaType, that.schemaType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementPosition, this.minCardinality, this.maxCardinality, this.allowsDuplicateValues, this.orderedValues, this.defaultValueOverride, this.sortOrder, this.minimumLength, this.length, this.precision, this.isNullable, this.nativeJavaClass, this.aliases, this.schemaType);
    }
}

