/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.datamanager.properties.DataSetProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DataStoreProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.OwnerCategory;
import org.odpi.openmetadata.accessservices.datamanager.properties.ReferenceableProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=DataSetProperties.class, name="DataSetProperties"), @JsonSubTypes.Type(value=DataStoreProperties.class, name="DataStoreProperties")})
public class AssetProperties
extends ReferenceableProperties {
    private static final long serialVersionUID = 1L;
    private String displayName = null;
    private String description = null;
    private String owner = null;
    private OwnerCategory ownerCategory = null;
    private List<String> zoneMembership = null;
    private String originOrganizationGUID = null;
    private String originBusinessCapabilityGUID = null;
    private Map<String, String> otherOriginValues = null;

    public AssetProperties() {
    }

    public AssetProperties(AssetProperties template) {
        super(template);
        if (template != null) {
            this.displayName = template.getDisplayName();
            this.description = template.getDescription();
            this.owner = template.getOwner();
            this.ownerCategory = template.getOwnerCategory();
            this.zoneMembership = template.getZoneMembership();
            this.originOrganizationGUID = template.getOriginOrganizationGUID();
            this.originBusinessCapabilityGUID = template.getOriginBusinessCapabilityGUID();
            this.otherOriginValues = template.getOtherOriginValues();
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public OwnerCategory getOwnerCategory() {
        return this.ownerCategory;
    }

    public void setOwnerCategory(OwnerCategory ownerType) {
        this.ownerCategory = ownerType;
    }

    public List<String> getZoneMembership() {
        if (this.zoneMembership == null) {
            return null;
        }
        if (this.zoneMembership.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.zoneMembership);
    }

    public void setZoneMembership(List<String> zoneMembership) {
        this.zoneMembership = zoneMembership;
    }

    public String getOriginOrganizationGUID() {
        return this.originOrganizationGUID;
    }

    public void setOriginOrganizationGUID(String originOrganizationGUID) {
        this.originOrganizationGUID = originOrganizationGUID;
    }

    public String getOriginBusinessCapabilityGUID() {
        return this.originBusinessCapabilityGUID;
    }

    public void setOriginBusinessCapabilityGUID(String originBusinessCapabilityGUID) {
        this.originBusinessCapabilityGUID = originBusinessCapabilityGUID;
    }

    public Map<String, String> getOtherOriginValues() {
        if (this.otherOriginValues == null) {
            return null;
        }
        if (this.otherOriginValues.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.otherOriginValues);
    }

    public void setOtherOriginValues(Map<String, String> otherOriginValues) {
        this.otherOriginValues = otherOriginValues;
    }

    @Override
    public String toString() {
        return "AssetProperties{displayName='" + this.displayName + '\'' + ", description='" + this.description + '\'' + ", owner='" + this.owner + '\'' + ", ownerCategory=" + this.ownerCategory + ", zoneMembership=" + this.zoneMembership + ", originOrganizationGUID='" + this.originOrganizationGUID + '\'' + ", originBusinessCapabilityGUID='" + this.originBusinessCapabilityGUID + '\'' + ", otherOriginValues=" + this.otherOriginValues + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", vendorProperties=" + this.getVendorProperties() + ", typeName='" + this.getTypeName() + '\'' + ", extendedProperties=" + this.getExtendedProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetProperties that = (AssetProperties)objectToCompare;
        return Objects.equals(this.displayName, that.displayName) && Objects.equals(this.description, that.description) && Objects.equals(this.owner, that.owner) && this.ownerCategory == that.ownerCategory && Objects.equals(this.zoneMembership, that.zoneMembership) && Objects.equals(this.originOrganizationGUID, that.originOrganizationGUID) && Objects.equals(this.originBusinessCapabilityGUID, that.originBusinessCapabilityGUID) && Objects.equals(this.otherOriginValues, that.otherOriginValues);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.displayName, this.description, this.owner, this.ownerCategory, this.zoneMembership, this.originOrganizationGUID, this.originBusinessCapabilityGUID, this.otherOriginValues);
    }
}

