/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum DataManagerEventType implements Serializable
{
    UNKNOWN_DATA_MANAGER_EVENT(0, "Unknown Event", "An event that is not recognized by the local server."),
    NEW_INFORMATION_VIEW_EVENT(1, "New View Event", "An new information view asset has been added to one of the access point zones."),
    NEW_DEPLOYED_DB_SCHEMA_EVENT(2, "New Deployed Database Schema Event", "An new deployed database schema asset has been added to one of the access point zones. "),
    NEW_TABULAR_SCHEMA_EVENT(3, "New Tabular Schema Event", "An new tabular schema has been added to one of the access point zones. "),
    NEW_TABULAR_COLUMN_EVENT(4, "New Tabular Column Event", "An new tabular column schema asset has been added to one of the access point zones. ");

    private static final long serialVersionUID = 1L;
    private int eventTypeCode;
    private String eventTypeName;
    private String eventTypeDescription;

    private DataManagerEventType(int eventTypeCode, String eventTypeName, String eventTypeDescription) {
        this.eventTypeCode = eventTypeCode;
        this.eventTypeName = eventTypeName;
        this.eventTypeDescription = eventTypeDescription;
    }

    public int getEventTypeCode() {
        return this.eventTypeCode;
    }

    public String getEventTypeName() {
        return this.eventTypeName;
    }

    public String getEventTypeDescription() {
        return this.eventTypeDescription;
    }

    public String toString() {
        return "DataManagerEventType{eventTypeCode=" + this.eventTypeCode + ", eventTypeName='" + this.eventTypeName + '\'' + ", eventTypeDescription='" + this.eventTypeDescription + '\'' + '}';
    }
}

