/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ElementHeader;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.MetadataElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.APISpecificationProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class APISpecificationElement
implements MetadataElement,
Serializable {
    private static final long serialVersionUID = 1L;
    private APISpecificationProperties properties = null;
    private ElementHeader elementHeader = null;
    private int operationCount = 0;

    public APISpecificationElement() {
    }

    public APISpecificationElement(APISpecificationElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.properties = template.getProperties();
            this.operationCount = template.getOperationCount();
        }
    }

    @Override
    public ElementHeader getElementHeader() {
        return this.elementHeader;
    }

    @Override
    public void setElementHeader(ElementHeader elementHeader) {
        this.elementHeader = elementHeader;
    }

    public APISpecificationProperties getProperties() {
        return this.properties;
    }

    public void setProperties(APISpecificationProperties properties) {
        this.properties = properties;
    }

    public int getOperationCount() {
        return this.operationCount;
    }

    public void setOperationCount(int operationCount) {
        this.operationCount = operationCount;
    }

    public String toString() {
        return "APISpecificationElement{properties=" + this.properties + ", elementHeader=" + this.elementHeader + ", operationCount=" + this.operationCount + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        APISpecificationElement that = (APISpecificationElement)objectToCompare;
        return this.operationCount == that.operationCount && Objects.equals(this.properties, that.properties) && Objects.equals(this.elementHeader, that.elementHeader);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementHeader, this.properties, this.operationCount);
    }
}

