/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.datamanager.properties.ConnectionProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ConnectionRequestBody
extends ConnectionProperties {
    private static final long serialVersionUID = 1L;
    private String externalSourceGUID = null;
    private String externalSourceName = null;

    public ConnectionRequestBody() {
    }

    public ConnectionRequestBody(ConnectionRequestBody template) {
        super(template);
        if (template != null) {
            this.externalSourceGUID = template.getExternalSourceGUID();
            this.externalSourceName = template.getExternalSourceName();
        }
    }

    public ConnectionRequestBody(ConnectionProperties template) {
        super(template);
    }

    public String getExternalSourceGUID() {
        return this.externalSourceGUID;
    }

    public void setExternalSourceGUID(String externalSourceGUID) {
        this.externalSourceGUID = externalSourceGUID;
    }

    public String getExternalSourceName() {
        return this.externalSourceName;
    }

    public void setExternalSourceName(String externalSourceName) {
        this.externalSourceName = externalSourceName;
    }

    @Override
    public String toString() {
        return "ConnectionRequestBody{externalSourceGUID='" + this.externalSourceGUID + "', externalSourceName='" + this.externalSourceName + "', displayName='" + this.getDisplayName() + "', description='" + this.getDescription() + "', userId='" + this.getUserId() + "', encryptedPassword='" + this.getEncryptedPassword() + "', clearPassword='" + this.getClearPassword() + "', configurationProperties=" + this.getConfigurationProperties() + ", securedProperties=" + this.getSecuredProperties() + ", qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", vendorProperties=" + this.getVendorProperties() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ConnectionRequestBody that = (ConnectionRequestBody)objectToCompare;
        return Objects.equals(this.externalSourceGUID, that.externalSourceGUID) && Objects.equals(this.externalSourceName, that.externalSourceName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.externalSourceGUID, this.externalSourceName);
    }
}

