/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.datamanager.properties.ReferenceableProperties;
import org.odpi.openmetadata.accessservices.datamanager.rest.ExternalSourceRequestBody;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ReferenceableRequestBody
extends ExternalSourceRequestBody {
    private static final long serialVersionUID = 1L;
    private String parentGUID = null;
    private ReferenceableProperties properties = null;

    public ReferenceableRequestBody() {
    }

    public ReferenceableRequestBody(ReferenceableRequestBody template) {
        super(template);
        if (template != null) {
            this.parentGUID = template.getParentGUID();
            this.properties = template.getProperties();
        }
    }

    public ReferenceableProperties getProperties() {
        return this.properties;
    }

    public void setProperties(ReferenceableProperties properties) {
        this.properties = properties;
    }

    public String getParentGUID() {
        return this.parentGUID;
    }

    public void setParentGUID(String parentGUID) {
        this.parentGUID = parentGUID;
    }

    @Override
    public String toString() {
        return "ReferenceableRequestBody{externalSourceGUID='" + this.getExternalSourceGUID() + "', externalSourceName='" + this.getExternalSourceName() + "', anchorGUID='" + this.parentGUID + "', properties=" + this.properties + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof ReferenceableRequestBody)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ReferenceableRequestBody that = (ReferenceableRequestBody)objectToCompare;
        return Objects.equals(this.parentGUID, that.parentGUID) && Objects.equals(this.properties, that.properties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.parentGUID, this.properties);
    }
}

