/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaElementProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DataContainerProperties
extends SchemaElementProperties {
    private int elementPosition = 0;
    private int minCardinality = 0;
    private int maxCardinality = 0;

    public DataContainerProperties() {
    }

    public DataContainerProperties(DataContainerProperties template) {
        super(template);
        if (template != null) {
            this.elementPosition = template.getElementPosition();
            this.minCardinality = template.getMinCardinality();
            this.maxCardinality = template.getMaxCardinality();
        }
    }

    public int getElementPosition() {
        return this.elementPosition;
    }

    public void setElementPosition(int elementPosition) {
        this.elementPosition = elementPosition;
    }

    public int getMinCardinality() {
        return this.minCardinality;
    }

    public void setMinCardinality(int minCardinality) {
        this.minCardinality = minCardinality;
    }

    public int getMaxCardinality() {
        return this.maxCardinality;
    }

    public void setMaxCardinality(int maxCardinality) {
        this.maxCardinality = maxCardinality;
    }

    @Override
    public String toString() {
        return "DataContainerProperties{elementPosition=" + this.elementPosition + ", minCardinality=" + this.minCardinality + ", maxCardinality=" + this.maxCardinality + ", isDeprecated=" + this.getIsDeprecated() + ", displayName='" + this.getDisplayName() + "', description='" + this.getDescription() + "', qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", vendorProperties=" + this.getVendorProperties() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        DataContainerProperties that = (DataContainerProperties)objectToCompare;
        return this.elementPosition == that.elementPosition && this.minCardinality == that.minCardinality && this.maxCardinality == that.maxCardinality;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementPosition, this.minCardinality, this.maxCardinality);
    }
}

