/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.AuditLogRecordSeverityLevel;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;

public enum DataManagerAuditCode implements AuditLogMessageSet
{
    SERVICE_INITIALIZING("OMAS-DATA-MANAGER-0001", AuditLogRecordSeverityLevel.STARTUP, "The Data Manager Open Metadata Access Service (OMAS) is initializing a new server instance", "The local server has started up a new instance of the Data Manager OMAS.  This service supports the exchange of metadata between data managers.", "No action is required if the Data Manager OMAS service is expected to be started in this server.  If this service is not required then it can be removed from the access service list in the configuration document for this server.  It will then not be started the next time the server starts up."),
    SERVICE_PUBLISHING("OMAS-DATA-MANAGER-0002", AuditLogRecordSeverityLevel.STARTUP, "The Data Manager Open Metadata Access Service (OMAS) is ready to publish data manager notifications to topic {0}", "The local server has started up the event publisher for the Data Manager OMAS.  It will begin publishing data manager metadata changes to its out topic.", "This is part of the normal start up of the service. Check that there are no errors from the event bus."),
    SERVICE_INSTANCE_FAILURE("OMAS-DATA-MANAGER-0003", AuditLogRecordSeverityLevel.EXCEPTION, "The Data Manager Open Metadata Access Service (OMAS) is unable to initialize a new instance; error message is {0}", "The access service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server."),
    SERVICE_INITIALIZED("OMAS-DATA-MANAGER-0004", AuditLogRecordSeverityLevel.STARTUP, "The Data Manager Open Metadata Access Service (OMAS) has initialized a new instance for server {0}", "The Data Manager OMAS has completed initialization of a new instance.", "Verify that this service has initialized successfully with both an in and out topic and it has the correct set of supported zones, publish zones and default zones defined.  Investigate any reported errors.  Also ensure that theenterprise repository services and the OCF metadata management services are initialized."),
    SERVICE_SHUTDOWN("OMAS-DATA-MANAGER-0005", AuditLogRecordSeverityLevel.SHUTDOWN, "The Data Manager Open Metadata Access Service (OMAS) is shutting down server instance {0}", "The local server has requested shut down of an Data Manager OMAS server instance.", "No action is required if this shutdown was intended."),
    PUBLISHING_SHUTDOWN("OMAS-DATA-MANAGER-0006", AuditLogRecordSeverityLevel.SHUTDOWN, "The Data Manager Open Metadata Access Service (OMAS) is no longer publishing events to topic {0}", "The local administrator has requested shut down of an Data Manager OMAS instance.  No more events will be published to the named topic.", "This is part of the normal shutdown of the service.   No action is required if this is serviceshutdown was intentional."),
    PUBLISHING_SHUTDOWN_ERROR("OMAS-DATA-MANAGER-0007", AuditLogRecordSeverityLevel.SHUTDOWN, "The Data Manager Open Metadata Access Service (OMAS) caught an unexpected {0} exception whilst shutting down the out topic {1}. The error message was: {2}", "The local administrator has requested shut down of an Data Manager OMAS instance.  No more events will be published to the named topic, although the connection to the event bus may not be released properly.", "This is part of the normal shutdown of the service. However, an exception is not expected at this point unless it is the consequence of a previous error. Review the error message and any other reported failures to determine if this exception needs special attention."),
    OUT_TOPIC_EVENT("OMAS-DATA-MANAGER-0013", AuditLogRecordSeverityLevel.EVENT, "The Data Manager Open Metadata Access Service (OMAS) has sent event of type: {0}", "The access service sends out notifications about changes to assets located on data managers.  This message is to create a record of the events that are being published.", "This event indicates that one of the assets within a data manager has changed."),
    OUTBOUND_EVENT_EXCEPTION("OMAS-DATA-MANAGER-0018", AuditLogRecordSeverityLevel.EVENT, "Unable to send an outbound event of type {0} for instance with unique identifier of {1} and type name {2} due to exception {3}.  The error message from the exception was {4}", "The system detected an exception whilst attempting to send an event to the out topic.  No event is sent.", "Investigate and correct the source of the error.  Once fixed, events will be sent.");

    private final String logMessageId;
    private final AuditLogRecordSeverityLevel severity;
    private final String logMessage;
    private final String systemAction;
    private final String userAction;

    private DataManagerAuditCode(String messageId, AuditLogRecordSeverityLevel severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "DataManagerAuditCode{logMessageId='" + this.logMessageId + "', severity=" + this.severity + ", logMessage='" + this.logMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

