/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.client;

import org.odpi.openmetadata.accessservices.datamanager.api.DataManagerEventInterface;
import org.odpi.openmetadata.accessservices.datamanager.api.DataManagerEventListener;
import org.odpi.openmetadata.accessservices.datamanager.connectors.outtopic.DataManagerOutTopicClientConnector;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.ffdc.OMAGOCFErrorCode;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ConnectionResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;

public class DataManagerEventListenerClient
implements DataManagerEventInterface {
    private static final String serviceName = "Data Manager OMAS";
    private String serverName;
    private String serverPlatformURLRoot;
    private OCFRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private DataManagerOutTopicClientConnector configurationEventTopicConnector = null;
    private AuditLog auditLog = null;

    public DataManagerEventListenerClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new OCFRESTClient(serverName, serverPlatformURLRoot);
    }

    public DataManagerEventListenerClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new OCFRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public DataManagerEventListenerClient(String serverName, String serverPlatformURLRoot, OCFRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = restClient;
        this.auditLog = auditLog;
    }

    public String getConfigurationServerName() {
        return this.serverName;
    }

    public void registerListener(String userId, DataManagerEventListener listener) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "registerListener";
        String nameParameter = "listener";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/topics/out-topic-connection";
        this.invalidParameterHandler.validateUserId(userId, "registerListener");
        this.invalidParameterHandler.validateObject((Object)listener, "listener", "registerListener");
        if (this.configurationEventTopicConnector == null) {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            ConnectionResponse restResult = this.restClient.callConnectionGetRESTCall("registerListener", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/topics/out-topic-connection", new Object[]{this.serverName, userId});
            Connection topicConnection = restResult.getConnection();
            Connector connector = connectorBroker.getConnector(topicConnection);
            if (connector == null) {
                throw new ConnectorCheckedException(OMAGOCFErrorCode.NULL_CONNECTOR_RETURNED.getMessageDefinition(new String[]{topicConnection.getQualifiedName(), serviceName, this.serverName, this.serverPlatformURLRoot}), this.getClass().getName(), "registerListener");
            }
            if (connector instanceof DataManagerOutTopicClientConnector) {
                this.configurationEventTopicConnector = (DataManagerOutTopicClientConnector)connector;
                this.configurationEventTopicConnector.setAuditLog(this.auditLog);
                this.configurationEventTopicConnector.start();
            } else {
                throw new ConnectorCheckedException(OMAGOCFErrorCode.WRONG_TYPE_OF_CONNECTOR.getMessageDefinition(new String[]{topicConnection.getQualifiedName(), serviceName, this.serverName, this.serverPlatformURLRoot, DataManagerOutTopicClientConnector.class.getName()}), this.getClass().getName(), "registerListener");
            }
        }
        this.configurationEventTopicConnector.registerListener(userId, listener);
    }
}

