/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.client;

import org.odpi.openmetadata.accessservices.datamanager.api.DataManagerIntegratorInterface;
import org.odpi.openmetadata.accessservices.datamanager.client.DataManagerRESTClient;
import org.odpi.openmetadata.accessservices.datamanager.properties.SoftwareServerCapabilitiesProperties;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetClientBase;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class DataManagerIntegratorClient
extends ConnectedAssetClientBase
implements DataManagerIntegratorInterface {
    private DataManagerRESTClient restClient;
    private final String urlTemplatePrefix = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/integrators";

    public DataManagerIntegratorClient(String serverName, String serverManagerRootURL, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverManagerRootURL, auditLog);
        this.restClient = new DataManagerRESTClient(serverName, serverManagerRootURL, auditLog);
    }

    public DataManagerIntegratorClient(String serverName, String serverManagerRootURL) throws InvalidParameterException {
        super(serverName, serverManagerRootURL);
        this.restClient = new DataManagerRESTClient(serverName, serverManagerRootURL);
    }

    public DataManagerIntegratorClient(String serverName, String serverManagerRootURL, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverManagerRootURL, auditLog);
        this.restClient = new DataManagerRESTClient(serverName, serverManagerRootURL, userId, password, auditLog);
    }

    public DataManagerIntegratorClient(String serverName, String serverManagerRootURL, String userId, String password) throws InvalidParameterException {
        super(serverName, serverManagerRootURL);
        this.restClient = new DataManagerRESTClient(serverName, serverManagerRootURL, userId, password);
    }

    public String createDataManagerIntegrator(String userId, SoftwareServerCapabilitiesProperties integratorCapabilities) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDataManagerIntegrator";
        String propertiesParameterName = "integratorCapabilities";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createDataManagerIntegrator");
        this.invalidParameterHandler.validateObject((Object)integratorCapabilities, "integratorCapabilities", "createDataManagerIntegrator");
        this.invalidParameterHandler.validateName(integratorCapabilities.getQualifiedName(), "qualifiedName", "createDataManagerIntegrator");
        String urlTemplate = this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/integrators";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createDataManagerIntegrator", urlTemplate, integratorCapabilities, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public String getDataManagerIntegratorGUID(String userId, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDataManagerIntegratorGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "getDataManagerIntegratorGUID");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "getDataManagerIntegratorGUID");
        String urlTemplate = this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/integrators" + "/by-name/{2}";
        GUIDResponse restResult = this.restClient.callGUIDGetRESTCall("getDataManagerIntegratorGUID", urlTemplate, new Object[]{this.serverName, userId, qualifiedName});
        return restResult.getGUID();
    }
}

